package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.content.complex.EntityIdentifier;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Duplicate", 
    "Index"})
public class EntityValidationDuplicate implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Duplicate")
    protected EntityIdentifier duplicate;

    @JsonProperty("Index")
    protected Integer index;

    protected EntityValidationDuplicate() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityValidationDuplicate";
    }

    @Property(name="Duplicate")
    @JsonIgnore
    public Optional<EntityIdentifier> getDuplicate() {
        return Optional.ofNullable(duplicate);
    }

    public EntityValidationDuplicate withDuplicate(EntityIdentifier duplicate) {
        EntityValidationDuplicate _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityValidationDuplicate");
        _x.duplicate = duplicate;
        return _x;
    }

    @Property(name="Index")
    @JsonIgnore
    public Optional<Integer> getIndex() {
        return Optional.ofNullable(index);
    }

    public EntityValidationDuplicate withIndex(Integer index) {
        EntityValidationDuplicate _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityValidationDuplicate");
        _x.index = index;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private EntityIdentifier duplicate;
        private Integer index;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder duplicate(EntityIdentifier duplicate) {
            this.duplicate = duplicate;
            this.changedFields = changedFields.add("Duplicate");
            return this;
        }

        public Builder index(Integer index) {
            this.index = index;
            this.changedFields = changedFields.add("Index");
            return this;
        }

        public EntityValidationDuplicate build() {
            EntityValidationDuplicate _x = new EntityValidationDuplicate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityValidationDuplicate";
            _x.duplicate = duplicate;
            _x.index = index;
            return _x;
        }
    }

    private EntityValidationDuplicate _copy() {
        EntityValidationDuplicate _x = new EntityValidationDuplicate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.duplicate = duplicate;
        _x.index = index;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityValidationDuplicate[");
        b.append("Duplicate=");
        b.append(this.duplicate);
        b.append(", ");
        b.append("Index=");
        b.append(this.index);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
