package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.subjectlists.complex.FilterValue;
import thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "FilterName", 
    "FilterType", 
    "IsUniverseFilter", 
    "FilterValues"})
public class FilterInfo implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("FilterName")
    protected String filterName;

    @JsonProperty("FilterType")
    protected String filterType;

    @JsonProperty("IsUniverseFilter")
    protected Boolean isUniverseFilter;

    @JsonProperty("FilterValues")
    protected List<FilterValue> filterValues;

    @JsonProperty("FilterValues@nextLink")
    protected String filterValuesNextLink;

    protected FilterInfo() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.FilterInfo";
    }

    @Property(name="FilterName")
    @JsonIgnore
    public Optional<String> getFilterName() {
        return Optional.ofNullable(filterName);
    }

    public FilterInfo withFilterName(String filterName) {
        FilterInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.FilterInfo");
        _x.filterName = filterName;
        return _x;
    }

    @Property(name="FilterType")
    @JsonIgnore
    public Optional<String> getFilterType() {
        return Optional.ofNullable(filterType);
    }

    public FilterInfo withFilterType(String filterType) {
        FilterInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.FilterInfo");
        _x.filterType = filterType;
        return _x;
    }

    @Property(name="IsUniverseFilter")
    @JsonIgnore
    public Optional<Boolean> getIsUniverseFilter() {
        return Optional.ofNullable(isUniverseFilter);
    }

    public FilterInfo withIsUniverseFilter(Boolean isUniverseFilter) {
        FilterInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.FilterInfo");
        _x.isUniverseFilter = isUniverseFilter;
        return _x;
    }

    @Property(name="FilterValues")
    @JsonIgnore
    public CollectionPage<FilterValue> getFilterValues() {
        return new CollectionPage<FilterValue>(contextPath, FilterValue.class, filterValues, Optional.ofNullable(filterValuesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String filterName;
        private String filterType;
        private Boolean isUniverseFilter;
        private List<FilterValue> filterValues;
        private String filterValuesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder filterName(String filterName) {
            this.filterName = filterName;
            this.changedFields = changedFields.add("FilterName");
            return this;
        }

        public Builder filterType(String filterType) {
            this.filterType = filterType;
            this.changedFields = changedFields.add("FilterType");
            return this;
        }

        public Builder isUniverseFilter(Boolean isUniverseFilter) {
            this.isUniverseFilter = isUniverseFilter;
            this.changedFields = changedFields.add("IsUniverseFilter");
            return this;
        }

        public Builder filterValues(List<FilterValue> filterValues) {
            this.filterValues = filterValues;
            this.changedFields = changedFields.add("FilterValues");
            return this;
        }

        public Builder filterValuesNextLink(String filterValuesNextLink) {
            this.filterValuesNextLink = filterValuesNextLink;
            this.changedFields = changedFields.add("FilterValues");
            return this;
        }

        public FilterInfo build() {
            FilterInfo _x = new FilterInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.FilterInfo";
            _x.filterName = filterName;
            _x.filterType = filterType;
            _x.isUniverseFilter = isUniverseFilter;
            _x.filterValues = filterValues;
            _x.filterValuesNextLink = filterValuesNextLink;
            return _x;
        }
    }

    private FilterInfo _copy() {
        FilterInfo _x = new FilterInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.filterName = filterName;
        _x.filterType = filterType;
        _x.isUniverseFilter = isUniverseFilter;
        _x.filterValues = filterValues;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FilterInfo[");
        b.append("FilterName=");
        b.append(this.filterName);
        b.append(", ");
        b.append("FilterType=");
        b.append(this.filterType);
        b.append(", ");
        b.append("IsUniverseFilter=");
        b.append(this.isUniverseFilter);
        b.append(", ");
        b.append("FilterValues=");
        b.append(this.filterValues);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
