package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.extractions.enums.ImportActionEnum;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "PredefinedName", 
    "PredefinedAction", 
    "ImportUserInstruments", 
    "ImportCreatedUserInstrumentsIntoList", 
    "AllowDuplicateInstruments"})
public class InstrumentListImportSettings implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("PredefinedName")
    protected String predefinedName;

    @JsonProperty("PredefinedAction")
    protected ImportActionEnum predefinedAction;

    @JsonProperty("ImportUserInstruments")
    protected Boolean importUserInstruments;

    @JsonProperty("ImportCreatedUserInstrumentsIntoList")
    protected Boolean importCreatedUserInstrumentsIntoList;

    @JsonProperty("AllowDuplicateInstruments")
    protected Boolean allowDuplicateInstruments;

    protected InstrumentListImportSettings() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListImportSettings";
    }

    @Property(name="PredefinedName")
    @JsonIgnore
    public Optional<String> getPredefinedName() {
        return Optional.ofNullable(predefinedName);
    }

    public InstrumentListImportSettings withPredefinedName(String predefinedName) {
        InstrumentListImportSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListImportSettings");
        _x.predefinedName = predefinedName;
        return _x;
    }

    @Property(name="PredefinedAction")
    @JsonIgnore
    public Optional<ImportActionEnum> getPredefinedAction() {
        return Optional.ofNullable(predefinedAction);
    }

    public InstrumentListImportSettings withPredefinedAction(ImportActionEnum predefinedAction) {
        InstrumentListImportSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListImportSettings");
        _x.predefinedAction = predefinedAction;
        return _x;
    }

    @Property(name="ImportUserInstruments")
    @JsonIgnore
    public Optional<Boolean> getImportUserInstruments() {
        return Optional.ofNullable(importUserInstruments);
    }

    public InstrumentListImportSettings withImportUserInstruments(Boolean importUserInstruments) {
        InstrumentListImportSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListImportSettings");
        _x.importUserInstruments = importUserInstruments;
        return _x;
    }

    @Property(name="ImportCreatedUserInstrumentsIntoList")
    @JsonIgnore
    public Optional<Boolean> getImportCreatedUserInstrumentsIntoList() {
        return Optional.ofNullable(importCreatedUserInstrumentsIntoList);
    }

    public InstrumentListImportSettings withImportCreatedUserInstrumentsIntoList(Boolean importCreatedUserInstrumentsIntoList) {
        InstrumentListImportSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListImportSettings");
        _x.importCreatedUserInstrumentsIntoList = importCreatedUserInstrumentsIntoList;
        return _x;
    }

    @Property(name="AllowDuplicateInstruments")
    @JsonIgnore
    public Optional<Boolean> getAllowDuplicateInstruments() {
        return Optional.ofNullable(allowDuplicateInstruments);
    }

    public InstrumentListImportSettings withAllowDuplicateInstruments(Boolean allowDuplicateInstruments) {
        InstrumentListImportSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListImportSettings");
        _x.allowDuplicateInstruments = allowDuplicateInstruments;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String predefinedName;
        private ImportActionEnum predefinedAction;
        private Boolean importUserInstruments;
        private Boolean importCreatedUserInstrumentsIntoList;
        private Boolean allowDuplicateInstruments;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder predefinedName(String predefinedName) {
            this.predefinedName = predefinedName;
            this.changedFields = changedFields.add("PredefinedName");
            return this;
        }

        public Builder predefinedAction(ImportActionEnum predefinedAction) {
            this.predefinedAction = predefinedAction;
            this.changedFields = changedFields.add("PredefinedAction");
            return this;
        }

        public Builder importUserInstruments(Boolean importUserInstruments) {
            this.importUserInstruments = importUserInstruments;
            this.changedFields = changedFields.add("ImportUserInstruments");
            return this;
        }

        public Builder importCreatedUserInstrumentsIntoList(Boolean importCreatedUserInstrumentsIntoList) {
            this.importCreatedUserInstrumentsIntoList = importCreatedUserInstrumentsIntoList;
            this.changedFields = changedFields.add("ImportCreatedUserInstrumentsIntoList");
            return this;
        }

        public Builder allowDuplicateInstruments(Boolean allowDuplicateInstruments) {
            this.allowDuplicateInstruments = allowDuplicateInstruments;
            this.changedFields = changedFields.add("AllowDuplicateInstruments");
            return this;
        }

        public InstrumentListImportSettings build() {
            InstrumentListImportSettings _x = new InstrumentListImportSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListImportSettings";
            _x.predefinedName = predefinedName;
            _x.predefinedAction = predefinedAction;
            _x.importUserInstruments = importUserInstruments;
            _x.importCreatedUserInstrumentsIntoList = importCreatedUserInstrumentsIntoList;
            _x.allowDuplicateInstruments = allowDuplicateInstruments;
            return _x;
        }
    }

    private InstrumentListImportSettings _copy() {
        InstrumentListImportSettings _x = new InstrumentListImportSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.predefinedName = predefinedName;
        _x.predefinedAction = predefinedAction;
        _x.importUserInstruments = importUserInstruments;
        _x.importCreatedUserInstrumentsIntoList = importCreatedUserInstrumentsIntoList;
        _x.allowDuplicateInstruments = allowDuplicateInstruments;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InstrumentListImportSettings[");
        b.append("PredefinedName=");
        b.append(this.predefinedName);
        b.append(", ");
        b.append("PredefinedAction=");
        b.append(this.predefinedAction);
        b.append(", ");
        b.append("ImportUserInstruments=");
        b.append(this.importUserInstruments);
        b.append(", ");
        b.append("ImportCreatedUserInstrumentsIntoList=");
        b.append(this.importCreatedUserInstrumentsIntoList);
        b.append(", ");
        b.append("AllowDuplicateInstruments=");
        b.append(this.allowDuplicateInstruments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
