package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "AllowOpenAccessInstruments", 
    "AllowHistoricalInstruments", 
    "AllowLimitedTermInstruments", 
    "AllowInactiveInstruments", 
    "AllowUnsupportedInstruments", 
    "ExcludeFinrAsPricingSourceForBonds", 
    "UseExchangeCodeInsteadOfLipper", 
    "UseUsQuoteInsteadOfCanadian", 
    "UseConsolidatedQuoteSourceForUsa", 
    "UseConsolidatedQuoteSourceForCanada", 
    "UseDebtOverEquity", 
    "UseOtcPqSource", 
    "AllowSubclassImport"})
public class InstrumentValidationOptions implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AllowOpenAccessInstruments")
    protected Boolean allowOpenAccessInstruments;

    @JsonProperty("AllowHistoricalInstruments")
    protected Boolean allowHistoricalInstruments;

    @JsonProperty("AllowLimitedTermInstruments")
    protected Boolean allowLimitedTermInstruments;

    @JsonProperty("AllowInactiveInstruments")
    protected Boolean allowInactiveInstruments;

    @JsonProperty("AllowUnsupportedInstruments")
    protected Boolean allowUnsupportedInstruments;

    @JsonProperty("ExcludeFinrAsPricingSourceForBonds")
    protected Boolean excludeFinrAsPricingSourceForBonds;

    @JsonProperty("UseExchangeCodeInsteadOfLipper")
    protected Boolean useExchangeCodeInsteadOfLipper;

    @JsonProperty("UseUsQuoteInsteadOfCanadian")
    protected Boolean useUsQuoteInsteadOfCanadian;

    @JsonProperty("UseConsolidatedQuoteSourceForUsa")
    protected Boolean useConsolidatedQuoteSourceForUsa;

    @JsonProperty("UseConsolidatedQuoteSourceForCanada")
    protected Boolean useConsolidatedQuoteSourceForCanada;

    @JsonProperty("UseDebtOverEquity")
    protected Boolean useDebtOverEquity;

    @JsonProperty("UseOtcPqSource")
    protected Boolean useOtcPqSource;

    @JsonProperty("AllowSubclassImport")
    protected Boolean allowSubclassImport;

    protected InstrumentValidationOptions() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions";
    }

    @Property(name="AllowOpenAccessInstruments")
    @JsonIgnore
    public Optional<Boolean> getAllowOpenAccessInstruments() {
        return Optional.ofNullable(allowOpenAccessInstruments);
    }

    public InstrumentValidationOptions withAllowOpenAccessInstruments(Boolean allowOpenAccessInstruments) {
        InstrumentValidationOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions");
        _x.allowOpenAccessInstruments = allowOpenAccessInstruments;
        return _x;
    }

    @Property(name="AllowHistoricalInstruments")
    @JsonIgnore
    public Optional<Boolean> getAllowHistoricalInstruments() {
        return Optional.ofNullable(allowHistoricalInstruments);
    }

    public InstrumentValidationOptions withAllowHistoricalInstruments(Boolean allowHistoricalInstruments) {
        InstrumentValidationOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions");
        _x.allowHistoricalInstruments = allowHistoricalInstruments;
        return _x;
    }

    @Property(name="AllowLimitedTermInstruments")
    @JsonIgnore
    public Optional<Boolean> getAllowLimitedTermInstruments() {
        return Optional.ofNullable(allowLimitedTermInstruments);
    }

    public InstrumentValidationOptions withAllowLimitedTermInstruments(Boolean allowLimitedTermInstruments) {
        InstrumentValidationOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions");
        _x.allowLimitedTermInstruments = allowLimitedTermInstruments;
        return _x;
    }

    @Property(name="AllowInactiveInstruments")
    @JsonIgnore
    public Optional<Boolean> getAllowInactiveInstruments() {
        return Optional.ofNullable(allowInactiveInstruments);
    }

    public InstrumentValidationOptions withAllowInactiveInstruments(Boolean allowInactiveInstruments) {
        InstrumentValidationOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions");
        _x.allowInactiveInstruments = allowInactiveInstruments;
        return _x;
    }

    @Property(name="AllowUnsupportedInstruments")
    @JsonIgnore
    public Optional<Boolean> getAllowUnsupportedInstruments() {
        return Optional.ofNullable(allowUnsupportedInstruments);
    }

    public InstrumentValidationOptions withAllowUnsupportedInstruments(Boolean allowUnsupportedInstruments) {
        InstrumentValidationOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions");
        _x.allowUnsupportedInstruments = allowUnsupportedInstruments;
        return _x;
    }

    @Property(name="ExcludeFinrAsPricingSourceForBonds")
    @JsonIgnore
    public Optional<Boolean> getExcludeFinrAsPricingSourceForBonds() {
        return Optional.ofNullable(excludeFinrAsPricingSourceForBonds);
    }

    public InstrumentValidationOptions withExcludeFinrAsPricingSourceForBonds(Boolean excludeFinrAsPricingSourceForBonds) {
        InstrumentValidationOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions");
        _x.excludeFinrAsPricingSourceForBonds = excludeFinrAsPricingSourceForBonds;
        return _x;
    }

    @Property(name="UseExchangeCodeInsteadOfLipper")
    @JsonIgnore
    public Optional<Boolean> getUseExchangeCodeInsteadOfLipper() {
        return Optional.ofNullable(useExchangeCodeInsteadOfLipper);
    }

    public InstrumentValidationOptions withUseExchangeCodeInsteadOfLipper(Boolean useExchangeCodeInsteadOfLipper) {
        InstrumentValidationOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions");
        _x.useExchangeCodeInsteadOfLipper = useExchangeCodeInsteadOfLipper;
        return _x;
    }

    @Property(name="UseUsQuoteInsteadOfCanadian")
    @JsonIgnore
    public Optional<Boolean> getUseUsQuoteInsteadOfCanadian() {
        return Optional.ofNullable(useUsQuoteInsteadOfCanadian);
    }

    public InstrumentValidationOptions withUseUsQuoteInsteadOfCanadian(Boolean useUsQuoteInsteadOfCanadian) {
        InstrumentValidationOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions");
        _x.useUsQuoteInsteadOfCanadian = useUsQuoteInsteadOfCanadian;
        return _x;
    }

    @Property(name="UseConsolidatedQuoteSourceForUsa")
    @JsonIgnore
    public Optional<Boolean> getUseConsolidatedQuoteSourceForUsa() {
        return Optional.ofNullable(useConsolidatedQuoteSourceForUsa);
    }

    public InstrumentValidationOptions withUseConsolidatedQuoteSourceForUsa(Boolean useConsolidatedQuoteSourceForUsa) {
        InstrumentValidationOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions");
        _x.useConsolidatedQuoteSourceForUsa = useConsolidatedQuoteSourceForUsa;
        return _x;
    }

    @Property(name="UseConsolidatedQuoteSourceForCanada")
    @JsonIgnore
    public Optional<Boolean> getUseConsolidatedQuoteSourceForCanada() {
        return Optional.ofNullable(useConsolidatedQuoteSourceForCanada);
    }

    public InstrumentValidationOptions withUseConsolidatedQuoteSourceForCanada(Boolean useConsolidatedQuoteSourceForCanada) {
        InstrumentValidationOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions");
        _x.useConsolidatedQuoteSourceForCanada = useConsolidatedQuoteSourceForCanada;
        return _x;
    }

    @Property(name="UseDebtOverEquity")
    @JsonIgnore
    public Optional<Boolean> getUseDebtOverEquity() {
        return Optional.ofNullable(useDebtOverEquity);
    }

    public InstrumentValidationOptions withUseDebtOverEquity(Boolean useDebtOverEquity) {
        InstrumentValidationOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions");
        _x.useDebtOverEquity = useDebtOverEquity;
        return _x;
    }

    @Property(name="UseOtcPqSource")
    @JsonIgnore
    public Optional<Boolean> getUseOtcPqSource() {
        return Optional.ofNullable(useOtcPqSource);
    }

    public InstrumentValidationOptions withUseOtcPqSource(Boolean useOtcPqSource) {
        InstrumentValidationOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions");
        _x.useOtcPqSource = useOtcPqSource;
        return _x;
    }

    @Property(name="AllowSubclassImport")
    @JsonIgnore
    public Optional<Boolean> getAllowSubclassImport() {
        return Optional.ofNullable(allowSubclassImport);
    }

    public InstrumentValidationOptions withAllowSubclassImport(Boolean allowSubclassImport) {
        InstrumentValidationOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions");
        _x.allowSubclassImport = allowSubclassImport;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowOpenAccessInstruments;
        private Boolean allowHistoricalInstruments;
        private Boolean allowLimitedTermInstruments;
        private Boolean allowInactiveInstruments;
        private Boolean allowUnsupportedInstruments;
        private Boolean excludeFinrAsPricingSourceForBonds;
        private Boolean useExchangeCodeInsteadOfLipper;
        private Boolean useUsQuoteInsteadOfCanadian;
        private Boolean useConsolidatedQuoteSourceForUsa;
        private Boolean useConsolidatedQuoteSourceForCanada;
        private Boolean useDebtOverEquity;
        private Boolean useOtcPqSource;
        private Boolean allowSubclassImport;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder allowOpenAccessInstruments(Boolean allowOpenAccessInstruments) {
            this.allowOpenAccessInstruments = allowOpenAccessInstruments;
            this.changedFields = changedFields.add("AllowOpenAccessInstruments");
            return this;
        }

        public Builder allowHistoricalInstruments(Boolean allowHistoricalInstruments) {
            this.allowHistoricalInstruments = allowHistoricalInstruments;
            this.changedFields = changedFields.add("AllowHistoricalInstruments");
            return this;
        }

        public Builder allowLimitedTermInstruments(Boolean allowLimitedTermInstruments) {
            this.allowLimitedTermInstruments = allowLimitedTermInstruments;
            this.changedFields = changedFields.add("AllowLimitedTermInstruments");
            return this;
        }

        public Builder allowInactiveInstruments(Boolean allowInactiveInstruments) {
            this.allowInactiveInstruments = allowInactiveInstruments;
            this.changedFields = changedFields.add("AllowInactiveInstruments");
            return this;
        }

        public Builder allowUnsupportedInstruments(Boolean allowUnsupportedInstruments) {
            this.allowUnsupportedInstruments = allowUnsupportedInstruments;
            this.changedFields = changedFields.add("AllowUnsupportedInstruments");
            return this;
        }

        public Builder excludeFinrAsPricingSourceForBonds(Boolean excludeFinrAsPricingSourceForBonds) {
            this.excludeFinrAsPricingSourceForBonds = excludeFinrAsPricingSourceForBonds;
            this.changedFields = changedFields.add("ExcludeFinrAsPricingSourceForBonds");
            return this;
        }

        public Builder useExchangeCodeInsteadOfLipper(Boolean useExchangeCodeInsteadOfLipper) {
            this.useExchangeCodeInsteadOfLipper = useExchangeCodeInsteadOfLipper;
            this.changedFields = changedFields.add("UseExchangeCodeInsteadOfLipper");
            return this;
        }

        public Builder useUsQuoteInsteadOfCanadian(Boolean useUsQuoteInsteadOfCanadian) {
            this.useUsQuoteInsteadOfCanadian = useUsQuoteInsteadOfCanadian;
            this.changedFields = changedFields.add("UseUsQuoteInsteadOfCanadian");
            return this;
        }

        public Builder useConsolidatedQuoteSourceForUsa(Boolean useConsolidatedQuoteSourceForUsa) {
            this.useConsolidatedQuoteSourceForUsa = useConsolidatedQuoteSourceForUsa;
            this.changedFields = changedFields.add("UseConsolidatedQuoteSourceForUsa");
            return this;
        }

        public Builder useConsolidatedQuoteSourceForCanada(Boolean useConsolidatedQuoteSourceForCanada) {
            this.useConsolidatedQuoteSourceForCanada = useConsolidatedQuoteSourceForCanada;
            this.changedFields = changedFields.add("UseConsolidatedQuoteSourceForCanada");
            return this;
        }

        public Builder useDebtOverEquity(Boolean useDebtOverEquity) {
            this.useDebtOverEquity = useDebtOverEquity;
            this.changedFields = changedFields.add("UseDebtOverEquity");
            return this;
        }

        public Builder useOtcPqSource(Boolean useOtcPqSource) {
            this.useOtcPqSource = useOtcPqSource;
            this.changedFields = changedFields.add("UseOtcPqSource");
            return this;
        }

        public Builder allowSubclassImport(Boolean allowSubclassImport) {
            this.allowSubclassImport = allowSubclassImport;
            this.changedFields = changedFields.add("AllowSubclassImport");
            return this;
        }

        public InstrumentValidationOptions build() {
            InstrumentValidationOptions _x = new InstrumentValidationOptions();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentValidationOptions";
            _x.allowOpenAccessInstruments = allowOpenAccessInstruments;
            _x.allowHistoricalInstruments = allowHistoricalInstruments;
            _x.allowLimitedTermInstruments = allowLimitedTermInstruments;
            _x.allowInactiveInstruments = allowInactiveInstruments;
            _x.allowUnsupportedInstruments = allowUnsupportedInstruments;
            _x.excludeFinrAsPricingSourceForBonds = excludeFinrAsPricingSourceForBonds;
            _x.useExchangeCodeInsteadOfLipper = useExchangeCodeInsteadOfLipper;
            _x.useUsQuoteInsteadOfCanadian = useUsQuoteInsteadOfCanadian;
            _x.useConsolidatedQuoteSourceForUsa = useConsolidatedQuoteSourceForUsa;
            _x.useConsolidatedQuoteSourceForCanada = useConsolidatedQuoteSourceForCanada;
            _x.useDebtOverEquity = useDebtOverEquity;
            _x.useOtcPqSource = useOtcPqSource;
            _x.allowSubclassImport = allowSubclassImport;
            return _x;
        }
    }

    private InstrumentValidationOptions _copy() {
        InstrumentValidationOptions _x = new InstrumentValidationOptions();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.allowOpenAccessInstruments = allowOpenAccessInstruments;
        _x.allowHistoricalInstruments = allowHistoricalInstruments;
        _x.allowLimitedTermInstruments = allowLimitedTermInstruments;
        _x.allowInactiveInstruments = allowInactiveInstruments;
        _x.allowUnsupportedInstruments = allowUnsupportedInstruments;
        _x.excludeFinrAsPricingSourceForBonds = excludeFinrAsPricingSourceForBonds;
        _x.useExchangeCodeInsteadOfLipper = useExchangeCodeInsteadOfLipper;
        _x.useUsQuoteInsteadOfCanadian = useUsQuoteInsteadOfCanadian;
        _x.useConsolidatedQuoteSourceForUsa = useConsolidatedQuoteSourceForUsa;
        _x.useConsolidatedQuoteSourceForCanada = useConsolidatedQuoteSourceForCanada;
        _x.useDebtOverEquity = useDebtOverEquity;
        _x.useOtcPqSource = useOtcPqSource;
        _x.allowSubclassImport = allowSubclassImport;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InstrumentValidationOptions[");
        b.append("AllowOpenAccessInstruments=");
        b.append(this.allowOpenAccessInstruments);
        b.append(", ");
        b.append("AllowHistoricalInstruments=");
        b.append(this.allowHistoricalInstruments);
        b.append(", ");
        b.append("AllowLimitedTermInstruments=");
        b.append(this.allowLimitedTermInstruments);
        b.append(", ");
        b.append("AllowInactiveInstruments=");
        b.append(this.allowInactiveInstruments);
        b.append(", ");
        b.append("AllowUnsupportedInstruments=");
        b.append(this.allowUnsupportedInstruments);
        b.append(", ");
        b.append("ExcludeFinrAsPricingSourceForBonds=");
        b.append(this.excludeFinrAsPricingSourceForBonds);
        b.append(", ");
        b.append("UseExchangeCodeInsteadOfLipper=");
        b.append(this.useExchangeCodeInsteadOfLipper);
        b.append(", ");
        b.append("UseUsQuoteInsteadOfCanadian=");
        b.append(this.useUsQuoteInsteadOfCanadian);
        b.append(", ");
        b.append("UseConsolidatedQuoteSourceForUsa=");
        b.append(this.useConsolidatedQuoteSourceForUsa);
        b.append(", ");
        b.append("UseConsolidatedQuoteSourceForCanada=");
        b.append(this.useConsolidatedQuoteSourceForCanada);
        b.append(", ");
        b.append("UseDebtOverEquity=");
        b.append(this.useDebtOverEquity);
        b.append(", ");
        b.append("UseOtcPqSource=");
        b.append(this.useOtcPqSource);
        b.append(", ");
        b.append("AllowSubclassImport=");
        b.append(this.allowSubclassImport);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
