package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentAppendDuplicate;
import thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "AppendedInstrumentCount", 
    "AppendDuplicates"})
public class InstrumentsAppendResult implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AppendedInstrumentCount")
    protected Integer appendedInstrumentCount;

    @JsonProperty("AppendDuplicates")
    protected List<InstrumentAppendDuplicate> appendDuplicates;

    @JsonProperty("AppendDuplicates@nextLink")
    protected String appendDuplicatesNextLink;

    protected InstrumentsAppendResult() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentsAppendResult";
    }

    @Property(name="AppendedInstrumentCount")
    @JsonIgnore
    public Optional<Integer> getAppendedInstrumentCount() {
        return Optional.ofNullable(appendedInstrumentCount);
    }

    public InstrumentsAppendResult withAppendedInstrumentCount(Integer appendedInstrumentCount) {
        InstrumentsAppendResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentsAppendResult");
        _x.appendedInstrumentCount = appendedInstrumentCount;
        return _x;
    }

    @Property(name="AppendDuplicates")
    @JsonIgnore
    public CollectionPage<InstrumentAppendDuplicate> getAppendDuplicates() {
        return new CollectionPage<InstrumentAppendDuplicate>(contextPath, InstrumentAppendDuplicate.class, appendDuplicates, Optional.ofNullable(appendDuplicatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer appendedInstrumentCount;
        private List<InstrumentAppendDuplicate> appendDuplicates;
        private String appendDuplicatesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder appendedInstrumentCount(Integer appendedInstrumentCount) {
            this.appendedInstrumentCount = appendedInstrumentCount;
            this.changedFields = changedFields.add("AppendedInstrumentCount");
            return this;
        }

        public Builder appendDuplicates(List<InstrumentAppendDuplicate> appendDuplicates) {
            this.appendDuplicates = appendDuplicates;
            this.changedFields = changedFields.add("AppendDuplicates");
            return this;
        }

        public Builder appendDuplicatesNextLink(String appendDuplicatesNextLink) {
            this.appendDuplicatesNextLink = appendDuplicatesNextLink;
            this.changedFields = changedFields.add("AppendDuplicates");
            return this;
        }

        public InstrumentsAppendResult build() {
            InstrumentsAppendResult _x = new InstrumentsAppendResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentsAppendResult";
            _x.appendedInstrumentCount = appendedInstrumentCount;
            _x.appendDuplicates = appendDuplicates;
            _x.appendDuplicatesNextLink = appendDuplicatesNextLink;
            return _x;
        }
    }

    private InstrumentsAppendResult _copy() {
        InstrumentsAppendResult _x = new InstrumentsAppendResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.appendedInstrumentCount = appendedInstrumentCount;
        _x.appendDuplicates = appendDuplicates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InstrumentsAppendResult[");
        b.append("AppendedInstrumentCount=");
        b.append(this.appendedInstrumentCount);
        b.append(", ");
        b.append("AppendDuplicates=");
        b.append(this.appendDuplicates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
