package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.complex.ValidatedInstrument;
import thomsonreuters.dss.api.content.schema.SchemaInfo;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentsValidationResult;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ValidatedInstruments", 
    "ValidationResult"})
public class InstrumentsValidateIdentifiersResult implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ValidatedInstruments")
    protected List<ValidatedInstrument> validatedInstruments;

    @JsonProperty("ValidatedInstruments@nextLink")
    protected String validatedInstrumentsNextLink;

    @JsonProperty("ValidationResult")
    protected InstrumentsValidationResult validationResult;

    protected InstrumentsValidateIdentifiersResult() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentsValidateIdentifiersResult";
    }

    @Property(name="ValidatedInstruments")
    @JsonIgnore
    public CollectionPage<ValidatedInstrument> getValidatedInstruments() {
        return new CollectionPage<ValidatedInstrument>(contextPath, ValidatedInstrument.class, validatedInstruments, Optional.ofNullable(validatedInstrumentsNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="ValidationResult")
    @JsonIgnore
    public Optional<InstrumentsValidationResult> getValidationResult() {
        return Optional.ofNullable(validationResult);
    }

    public InstrumentsValidateIdentifiersResult withValidationResult(InstrumentsValidationResult validationResult) {
        InstrumentsValidateIdentifiersResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentsValidateIdentifiersResult");
        _x.validationResult = validationResult;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ValidatedInstrument> validatedInstruments;
        private String validatedInstrumentsNextLink;
        private InstrumentsValidationResult validationResult;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder validatedInstruments(List<ValidatedInstrument> validatedInstruments) {
            this.validatedInstruments = validatedInstruments;
            this.changedFields = changedFields.add("ValidatedInstruments");
            return this;
        }

        public Builder validatedInstrumentsNextLink(String validatedInstrumentsNextLink) {
            this.validatedInstrumentsNextLink = validatedInstrumentsNextLink;
            this.changedFields = changedFields.add("ValidatedInstruments");
            return this;
        }

        public Builder validationResult(InstrumentsValidationResult validationResult) {
            this.validationResult = validationResult;
            this.changedFields = changedFields.add("ValidationResult");
            return this;
        }

        public InstrumentsValidateIdentifiersResult build() {
            InstrumentsValidateIdentifiersResult _x = new InstrumentsValidateIdentifiersResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentsValidateIdentifiersResult";
            _x.validatedInstruments = validatedInstruments;
            _x.validatedInstrumentsNextLink = validatedInstrumentsNextLink;
            _x.validationResult = validationResult;
            return _x;
        }
    }

    private InstrumentsValidateIdentifiersResult _copy() {
        InstrumentsValidateIdentifiersResult _x = new InstrumentsValidateIdentifiersResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.validatedInstruments = validatedInstruments;
        _x.validationResult = validationResult;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InstrumentsValidateIdentifiersResult[");
        b.append("ValidatedInstruments=");
        b.append(this.validatedInstruments);
        b.append(", ");
        b.append("ValidationResult=");
        b.append(this.validationResult);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
