package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentSegment;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentValidationDuplicate;
import thomsonreuters.dss.api.extractions.subjectlists.complex.InstrumentValidationMessage;
import thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ValidInstrumentCount", 
    "OpenAccessSegments", 
    "StandardSegments", 
    "ValidationDuplicates", 
    "Messages"})
public class InstrumentsValidationResult implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ValidInstrumentCount")
    protected Integer validInstrumentCount;

    @JsonProperty("OpenAccessSegments")
    protected List<InstrumentSegment> openAccessSegments;

    @JsonProperty("OpenAccessSegments@nextLink")
    protected String openAccessSegmentsNextLink;

    @JsonProperty("StandardSegments")
    protected List<InstrumentSegment> standardSegments;

    @JsonProperty("StandardSegments@nextLink")
    protected String standardSegmentsNextLink;

    @JsonProperty("ValidationDuplicates")
    protected List<InstrumentValidationDuplicate> validationDuplicates;

    @JsonProperty("ValidationDuplicates@nextLink")
    protected String validationDuplicatesNextLink;

    @JsonProperty("Messages")
    protected List<InstrumentValidationMessage> messages;

    @JsonProperty("Messages@nextLink")
    protected String messagesNextLink;

    protected InstrumentsValidationResult() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentsValidationResult";
    }

    @Property(name="ValidInstrumentCount")
    @JsonIgnore
    public Optional<Integer> getValidInstrumentCount() {
        return Optional.ofNullable(validInstrumentCount);
    }

    public InstrumentsValidationResult withValidInstrumentCount(Integer validInstrumentCount) {
        InstrumentsValidationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentsValidationResult");
        _x.validInstrumentCount = validInstrumentCount;
        return _x;
    }

    @Property(name="OpenAccessSegments")
    @JsonIgnore
    public CollectionPage<InstrumentSegment> getOpenAccessSegments() {
        return new CollectionPage<InstrumentSegment>(contextPath, InstrumentSegment.class, openAccessSegments, Optional.ofNullable(openAccessSegmentsNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="StandardSegments")
    @JsonIgnore
    public CollectionPage<InstrumentSegment> getStandardSegments() {
        return new CollectionPage<InstrumentSegment>(contextPath, InstrumentSegment.class, standardSegments, Optional.ofNullable(standardSegmentsNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="ValidationDuplicates")
    @JsonIgnore
    public CollectionPage<InstrumentValidationDuplicate> getValidationDuplicates() {
        return new CollectionPage<InstrumentValidationDuplicate>(contextPath, InstrumentValidationDuplicate.class, validationDuplicates, Optional.ofNullable(validationDuplicatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="Messages")
    @JsonIgnore
    public CollectionPage<InstrumentValidationMessage> getMessages() {
        return new CollectionPage<InstrumentValidationMessage>(contextPath, InstrumentValidationMessage.class, messages, Optional.ofNullable(messagesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer validInstrumentCount;
        private List<InstrumentSegment> openAccessSegments;
        private String openAccessSegmentsNextLink;
        private List<InstrumentSegment> standardSegments;
        private String standardSegmentsNextLink;
        private List<InstrumentValidationDuplicate> validationDuplicates;
        private String validationDuplicatesNextLink;
        private List<InstrumentValidationMessage> messages;
        private String messagesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder validInstrumentCount(Integer validInstrumentCount) {
            this.validInstrumentCount = validInstrumentCount;
            this.changedFields = changedFields.add("ValidInstrumentCount");
            return this;
        }

        public Builder openAccessSegments(List<InstrumentSegment> openAccessSegments) {
            this.openAccessSegments = openAccessSegments;
            this.changedFields = changedFields.add("OpenAccessSegments");
            return this;
        }

        public Builder openAccessSegmentsNextLink(String openAccessSegmentsNextLink) {
            this.openAccessSegmentsNextLink = openAccessSegmentsNextLink;
            this.changedFields = changedFields.add("OpenAccessSegments");
            return this;
        }

        public Builder standardSegments(List<InstrumentSegment> standardSegments) {
            this.standardSegments = standardSegments;
            this.changedFields = changedFields.add("StandardSegments");
            return this;
        }

        public Builder standardSegmentsNextLink(String standardSegmentsNextLink) {
            this.standardSegmentsNextLink = standardSegmentsNextLink;
            this.changedFields = changedFields.add("StandardSegments");
            return this;
        }

        public Builder validationDuplicates(List<InstrumentValidationDuplicate> validationDuplicates) {
            this.validationDuplicates = validationDuplicates;
            this.changedFields = changedFields.add("ValidationDuplicates");
            return this;
        }

        public Builder validationDuplicatesNextLink(String validationDuplicatesNextLink) {
            this.validationDuplicatesNextLink = validationDuplicatesNextLink;
            this.changedFields = changedFields.add("ValidationDuplicates");
            return this;
        }

        public Builder messages(List<InstrumentValidationMessage> messages) {
            this.messages = messages;
            this.changedFields = changedFields.add("Messages");
            return this;
        }

        public Builder messagesNextLink(String messagesNextLink) {
            this.messagesNextLink = messagesNextLink;
            this.changedFields = changedFields.add("Messages");
            return this;
        }

        public InstrumentsValidationResult build() {
            InstrumentsValidationResult _x = new InstrumentsValidationResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentsValidationResult";
            _x.validInstrumentCount = validInstrumentCount;
            _x.openAccessSegments = openAccessSegments;
            _x.openAccessSegmentsNextLink = openAccessSegmentsNextLink;
            _x.standardSegments = standardSegments;
            _x.standardSegmentsNextLink = standardSegmentsNextLink;
            _x.validationDuplicates = validationDuplicates;
            _x.validationDuplicatesNextLink = validationDuplicatesNextLink;
            _x.messages = messages;
            _x.messagesNextLink = messagesNextLink;
            return _x;
        }
    }

    private InstrumentsValidationResult _copy() {
        InstrumentsValidationResult _x = new InstrumentsValidationResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.validInstrumentCount = validInstrumentCount;
        _x.openAccessSegments = openAccessSegments;
        _x.standardSegments = standardSegments;
        _x.validationDuplicates = validationDuplicates;
        _x.messages = messages;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InstrumentsValidationResult[");
        b.append("ValidInstrumentCount=");
        b.append(this.validInstrumentCount);
        b.append(", ");
        b.append("OpenAccessSegments=");
        b.append(this.openAccessSegments);
        b.append(", ");
        b.append("StandardSegments=");
        b.append(this.standardSegments);
        b.append(", ");
        b.append("ValidationDuplicates=");
        b.append(this.validationDuplicates);
        b.append(", ");
        b.append("Messages=");
        b.append(this.messages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
