package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.subjectlists.complex.CriteriaListFilter;
import thomsonreuters.dss.api.extractions.subjectlists.enums.MultiValueOperator;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Op", 
    "Values"})
public class MultiValueFilter extends CriteriaListFilter implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("Op")
    protected MultiValueOperator op;

    @JsonProperty("Values")
    protected List<String> values;

    @JsonProperty("Values@nextLink")
    protected String valuesNextLink;

    protected MultiValueFilter() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.MultiValueFilter";
    }

    @Property(name="Op")
    @JsonIgnore
    public Optional<MultiValueOperator> getOp() {
        return Optional.ofNullable(op);
    }

    public MultiValueFilter withOp(MultiValueOperator op) {
        MultiValueFilter _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.MultiValueFilter");
        _x.op = op;
        return _x;
    }

    @Property(name="Values")
    @JsonIgnore
    public CollectionPage<String> getValues() {
        return new CollectionPage<String>(contextPath, String.class, values, Optional.ofNullable(valuesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMultiValueFilter() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private MultiValueOperator op;
        private List<String> values;
        private String valuesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder op(MultiValueOperator op) {
            this.op = op;
            this.changedFields = changedFields.add("Op");
            return this;
        }

        public Builder values(List<String> values) {
            this.values = values;
            this.changedFields = changedFields.add("Values");
            return this;
        }

        public Builder valuesNextLink(String valuesNextLink) {
            this.valuesNextLink = valuesNextLink;
            this.changedFields = changedFields.add("Values");
            return this;
        }

        public MultiValueFilter build() {
            MultiValueFilter _x = new MultiValueFilter();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.MultiValueFilter";
            _x.name = name;
            _x.op = op;
            _x.values = values;
            _x.valuesNextLink = valuesNextLink;
            return _x;
        }
    }

    private MultiValueFilter _copy() {
        MultiValueFilter _x = new MultiValueFilter();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.op = op;
        _x.values = values;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MultiValueFilter[");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("Op=");
        b.append(this.op);
        b.append(", ");
        b.append("Values=");
        b.append(this.values);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
