package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.math.BigDecimal;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.subjectlists.complex.CriteriaListFilter;
import thomsonreuters.dss.api.extractions.subjectlists.enums.RangeOperator;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Op", 
    "Max", 
    "Min", 
    "Value"})
public class RangeFilter extends CriteriaListFilter implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("Op")
    protected RangeOperator op;

    @JsonProperty("Max")
    protected BigDecimal max;

    @JsonProperty("Min")
    protected BigDecimal min;

    @JsonProperty("Value")
    protected BigDecimal value;

    protected RangeFilter() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.RangeFilter";
    }

    @Property(name="Op")
    @JsonIgnore
    public Optional<RangeOperator> getOp() {
        return Optional.ofNullable(op);
    }

    public RangeFilter withOp(RangeOperator op) {
        RangeFilter _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.RangeFilter");
        _x.op = op;
        return _x;
    }

    @Property(name="Max")
    @JsonIgnore
    public Optional<BigDecimal> getMax() {
        return Optional.ofNullable(max);
    }

    public RangeFilter withMax(BigDecimal max) {
        RangeFilter _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.RangeFilter");
        _x.max = max;
        return _x;
    }

    @Property(name="Min")
    @JsonIgnore
    public Optional<BigDecimal> getMin() {
        return Optional.ofNullable(min);
    }

    public RangeFilter withMin(BigDecimal min) {
        RangeFilter _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.RangeFilter");
        _x.min = min;
        return _x;
    }

    @Property(name="Value")
    @JsonIgnore
    public Optional<BigDecimal> getValue() {
        return Optional.ofNullable(value);
    }

    public RangeFilter withValue(BigDecimal value) {
        RangeFilter _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.RangeFilter");
        _x.value = value;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRangeFilter() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private RangeOperator op;
        private BigDecimal max;
        private BigDecimal min;
        private BigDecimal value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder op(RangeOperator op) {
            this.op = op;
            this.changedFields = changedFields.add("Op");
            return this;
        }

        public Builder max(BigDecimal max) {
            this.max = max;
            this.changedFields = changedFields.add("Max");
            return this;
        }

        public Builder min(BigDecimal min) {
            this.min = min;
            this.changedFields = changedFields.add("Min");
            return this;
        }

        public Builder value(BigDecimal value) {
            this.value = value;
            this.changedFields = changedFields.add("Value");
            return this;
        }

        public RangeFilter build() {
            RangeFilter _x = new RangeFilter();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.RangeFilter";
            _x.name = name;
            _x.op = op;
            _x.max = max;
            _x.min = min;
            _x.value = value;
            return _x;
        }
    }

    private RangeFilter _copy() {
        RangeFilter _x = new RangeFilter();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.op = op;
        _x.max = max;
        _x.min = min;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RangeFilter[");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("Op=");
        b.append(this.op);
        b.append(", ");
        b.append("Max=");
        b.append(this.max);
        b.append(", ");
        b.append("Min=");
        b.append(this.min);
        b.append(", ");
        b.append("Value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
