package thomsonreuters.dss.api.extractions.subjectlists.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.subjectlists.collection.request.InstrumentListItemCollectionRequest;
import thomsonreuters.dss.api.extractions.subjectlists.entity.SubjectList;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Count", 
    "Created", 
    "Modified"})
public class InstrumentList extends SubjectList implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentList";
    }

    @JsonProperty("Count")
    protected Integer count;

    @JsonProperty("Created")
    protected OffsetDateTime created;

    @JsonProperty("Modified")
    protected OffsetDateTime modified;

    protected InstrumentList() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderInstrumentList() {
        return new Builder();
    }

    public static final class Builder {
        private String listId;
        private String name;
        private Integer count;
        private OffsetDateTime created;
        private OffsetDateTime modified;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder listId(String listId) {
            this.listId = listId;
            this.changedFields = changedFields.add("ListId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.changedFields = changedFields.add("Count");
            return this;
        }

        public Builder created(OffsetDateTime created) {
            this.created = created;
            this.changedFields = changedFields.add("Created");
            return this;
        }

        public Builder modified(OffsetDateTime modified) {
            this.modified = modified;
            this.changedFields = changedFields.add("Modified");
            return this;
        }

        public InstrumentList build() {
            InstrumentList _x = new InstrumentList();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentList";
            _x.listId = listId;
            _x.name = name;
            _x.count = count;
            _x.created = created;
            _x.modified = modified;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && listId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(listId.toString()));
        }
    }

    @Property(name="Count")
    @JsonIgnore
    public Optional<Integer> getCount() {
        return Optional.ofNullable(count);
    }

    public InstrumentList withCount(Integer count) {
        InstrumentList _x = _copy();
        _x.changedFields = changedFields.add("Count");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentList");
        _x.count = count;
        return _x;
    }

    @Property(name="Created")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreated() {
        return Optional.ofNullable(created);
    }

    public InstrumentList withCreated(OffsetDateTime created) {
        InstrumentList _x = _copy();
        _x.changedFields = changedFields.add("Created");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentList");
        _x.created = created;
        return _x;
    }

    @Property(name="Modified")
    @JsonIgnore
    public Optional<OffsetDateTime> getModified() {
        return Optional.ofNullable(modified);
    }

    public InstrumentList withModified(OffsetDateTime modified) {
        InstrumentList _x = _copy();
        _x.changedFields = changedFields.add("Modified");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentList");
        _x.modified = modified;
        return _x;
    }

    @NavigationProperty(name="Items")
    @JsonIgnore
    public InstrumentListItemCollectionRequest getItems() {
        return new InstrumentListItemCollectionRequest(
                        contextPath.addSegment("Items"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InstrumentList patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        InstrumentList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InstrumentList put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        InstrumentList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private InstrumentList _copy() {
        InstrumentList _x = new InstrumentList();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.listId = listId;
        _x.name = name;
        _x.count = count;
        _x.created = created;
        _x.modified = modified;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InstrumentList[");
        b.append("ListId=");
        b.append(this.listId);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("Count=");
        b.append(this.count);
        b.append(", ");
        b.append("Created=");
        b.append(this.created);
        b.append(", ");
        b.append("Modified=");
        b.append(this.modified);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
