package thomsonreuters.dss.api.extractions.subjectlists.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.InstrumentListEntityRequest;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ListId", 
    "Identifier", 
    "IdentifierType", 
    "Source", 
    "UserDefinedIdentifier", 
    "UserDefinedIdentifier2", 
    "UserDefinedIdentifier3", 
    "UserDefinedIdentifier4", 
    "UserDefinedIdentifier5", 
    "UserDefinedIdentifier6", 
    "Order", 
    "Description", 
    "InstrumentListItemKey", 
    "InstrumentKey"})
public class InstrumentListItem implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ListId")
    protected String listId;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("Source")
    protected String source;

    @JsonProperty("UserDefinedIdentifier")
    protected String userDefinedIdentifier;

    @JsonProperty("UserDefinedIdentifier2")
    protected String userDefinedIdentifier2;

    @JsonProperty("UserDefinedIdentifier3")
    protected String userDefinedIdentifier3;

    @JsonProperty("UserDefinedIdentifier4")
    protected String userDefinedIdentifier4;

    @JsonProperty("UserDefinedIdentifier5")
    protected String userDefinedIdentifier5;

    @JsonProperty("UserDefinedIdentifier6")
    protected String userDefinedIdentifier6;

    @JsonProperty("Order")
    protected Integer order;

    @JsonProperty("Description")
    protected String description;

    @JsonProperty("InstrumentListItemKey")
    protected String instrumentListItemKey;

    @JsonProperty("InstrumentKey")
    protected String instrumentKey;

    protected InstrumentListItem() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String listId;
        private String identifier;
        private IdentifierType identifierType;
        private String source;
        private String userDefinedIdentifier;
        private String userDefinedIdentifier2;
        private String userDefinedIdentifier3;
        private String userDefinedIdentifier4;
        private String userDefinedIdentifier5;
        private String userDefinedIdentifier6;
        private Integer order;
        private String description;
        private String instrumentListItemKey;
        private String instrumentKey;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder listId(String listId) {
            this.listId = listId;
            this.changedFields = changedFields.add("ListId");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.changedFields = changedFields.add("Source");
            return this;
        }

        public Builder userDefinedIdentifier(String userDefinedIdentifier) {
            this.userDefinedIdentifier = userDefinedIdentifier;
            this.changedFields = changedFields.add("UserDefinedIdentifier");
            return this;
        }

        public Builder userDefinedIdentifier2(String userDefinedIdentifier2) {
            this.userDefinedIdentifier2 = userDefinedIdentifier2;
            this.changedFields = changedFields.add("UserDefinedIdentifier2");
            return this;
        }

        public Builder userDefinedIdentifier3(String userDefinedIdentifier3) {
            this.userDefinedIdentifier3 = userDefinedIdentifier3;
            this.changedFields = changedFields.add("UserDefinedIdentifier3");
            return this;
        }

        public Builder userDefinedIdentifier4(String userDefinedIdentifier4) {
            this.userDefinedIdentifier4 = userDefinedIdentifier4;
            this.changedFields = changedFields.add("UserDefinedIdentifier4");
            return this;
        }

        public Builder userDefinedIdentifier5(String userDefinedIdentifier5) {
            this.userDefinedIdentifier5 = userDefinedIdentifier5;
            this.changedFields = changedFields.add("UserDefinedIdentifier5");
            return this;
        }

        public Builder userDefinedIdentifier6(String userDefinedIdentifier6) {
            this.userDefinedIdentifier6 = userDefinedIdentifier6;
            this.changedFields = changedFields.add("UserDefinedIdentifier6");
            return this;
        }

        public Builder order(Integer order) {
            this.order = order;
            this.changedFields = changedFields.add("Order");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder instrumentListItemKey(String instrumentListItemKey) {
            this.instrumentListItemKey = instrumentListItemKey;
            this.changedFields = changedFields.add("InstrumentListItemKey");
            return this;
        }

        public Builder instrumentKey(String instrumentKey) {
            this.instrumentKey = instrumentKey;
            this.changedFields = changedFields.add("InstrumentKey");
            return this;
        }

        public InstrumentListItem build() {
            InstrumentListItem _x = new InstrumentListItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem";
            _x.listId = listId;
            _x.identifier = identifier;
            _x.identifierType = identifierType;
            _x.source = source;
            _x.userDefinedIdentifier = userDefinedIdentifier;
            _x.userDefinedIdentifier2 = userDefinedIdentifier2;
            _x.userDefinedIdentifier3 = userDefinedIdentifier3;
            _x.userDefinedIdentifier4 = userDefinedIdentifier4;
            _x.userDefinedIdentifier5 = userDefinedIdentifier5;
            _x.userDefinedIdentifier6 = userDefinedIdentifier6;
            _x.order = order;
            _x.description = description;
            _x.instrumentListItemKey = instrumentListItemKey;
            _x.instrumentKey = instrumentKey;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && instrumentListItemKey != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(instrumentListItemKey.toString()));
        }
    }

    @Property(name="ListId")
    @JsonIgnore
    public Optional<String> getListId() {
        return Optional.ofNullable(listId);
    }

    public InstrumentListItem withListId(String listId) {
        InstrumentListItem _x = _copy();
        _x.changedFields = changedFields.add("ListId");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem");
        _x.listId = listId;
        return _x;
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public InstrumentListItem withIdentifier(String identifier) {
        InstrumentListItem _x = _copy();
        _x.changedFields = changedFields.add("Identifier");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public InstrumentListItem withIdentifierType(IdentifierType identifierType) {
        InstrumentListItem _x = _copy();
        _x.changedFields = changedFields.add("IdentifierType");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="Source")
    @JsonIgnore
    public Optional<String> getSource() {
        return Optional.ofNullable(source);
    }

    public InstrumentListItem withSource(String source) {
        InstrumentListItem _x = _copy();
        _x.changedFields = changedFields.add("Source");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem");
        _x.source = source;
        return _x;
    }

    @Property(name="UserDefinedIdentifier")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier() {
        return Optional.ofNullable(userDefinedIdentifier);
    }

    public InstrumentListItem withUserDefinedIdentifier(String userDefinedIdentifier) {
        InstrumentListItem _x = _copy();
        _x.changedFields = changedFields.add("UserDefinedIdentifier");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem");
        _x.userDefinedIdentifier = userDefinedIdentifier;
        return _x;
    }

    @Property(name="UserDefinedIdentifier2")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier2() {
        return Optional.ofNullable(userDefinedIdentifier2);
    }

    public InstrumentListItem withUserDefinedIdentifier2(String userDefinedIdentifier2) {
        InstrumentListItem _x = _copy();
        _x.changedFields = changedFields.add("UserDefinedIdentifier2");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem");
        _x.userDefinedIdentifier2 = userDefinedIdentifier2;
        return _x;
    }

    @Property(name="UserDefinedIdentifier3")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier3() {
        return Optional.ofNullable(userDefinedIdentifier3);
    }

    public InstrumentListItem withUserDefinedIdentifier3(String userDefinedIdentifier3) {
        InstrumentListItem _x = _copy();
        _x.changedFields = changedFields.add("UserDefinedIdentifier3");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem");
        _x.userDefinedIdentifier3 = userDefinedIdentifier3;
        return _x;
    }

    @Property(name="UserDefinedIdentifier4")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier4() {
        return Optional.ofNullable(userDefinedIdentifier4);
    }

    public InstrumentListItem withUserDefinedIdentifier4(String userDefinedIdentifier4) {
        InstrumentListItem _x = _copy();
        _x.changedFields = changedFields.add("UserDefinedIdentifier4");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem");
        _x.userDefinedIdentifier4 = userDefinedIdentifier4;
        return _x;
    }

    @Property(name="UserDefinedIdentifier5")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier5() {
        return Optional.ofNullable(userDefinedIdentifier5);
    }

    public InstrumentListItem withUserDefinedIdentifier5(String userDefinedIdentifier5) {
        InstrumentListItem _x = _copy();
        _x.changedFields = changedFields.add("UserDefinedIdentifier5");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem");
        _x.userDefinedIdentifier5 = userDefinedIdentifier5;
        return _x;
    }

    @Property(name="UserDefinedIdentifier6")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier6() {
        return Optional.ofNullable(userDefinedIdentifier6);
    }

    public InstrumentListItem withUserDefinedIdentifier6(String userDefinedIdentifier6) {
        InstrumentListItem _x = _copy();
        _x.changedFields = changedFields.add("UserDefinedIdentifier6");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem");
        _x.userDefinedIdentifier6 = userDefinedIdentifier6;
        return _x;
    }

    @Property(name="Order")
    @JsonIgnore
    public Optional<Integer> getOrder() {
        return Optional.ofNullable(order);
    }

    public InstrumentListItem withOrder(Integer order) {
        InstrumentListItem _x = _copy();
        _x.changedFields = changedFields.add("Order");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem");
        _x.order = order;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public InstrumentListItem withDescription(String description) {
        InstrumentListItem _x = _copy();
        _x.changedFields = changedFields.add("Description");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem");
        _x.description = description;
        return _x;
    }

    @Property(name="InstrumentListItemKey")
    @JsonIgnore
    public Optional<String> getInstrumentListItemKey() {
        return Optional.ofNullable(instrumentListItemKey);
    }

    public InstrumentListItem withInstrumentListItemKey(String instrumentListItemKey) {
        InstrumentListItem _x = _copy();
        _x.changedFields = changedFields.add("InstrumentListItemKey");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem");
        _x.instrumentListItemKey = instrumentListItemKey;
        return _x;
    }

    @Property(name="InstrumentKey")
    @JsonIgnore
    public Optional<String> getInstrumentKey() {
        return Optional.ofNullable(instrumentKey);
    }

    public InstrumentListItem withInstrumentKey(String instrumentKey) {
        InstrumentListItem _x = _copy();
        _x.changedFields = changedFields.add("InstrumentKey");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.InstrumentListItem");
        _x.instrumentKey = instrumentKey;
        return _x;
    }

    @NavigationProperty(name="InstrumentList")
    @JsonIgnore
    public InstrumentListEntityRequest getInstrumentList() {
        return new InstrumentListEntityRequest(contextPath.addSegment("InstrumentList"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InstrumentListItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        InstrumentListItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InstrumentListItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        InstrumentListItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private InstrumentListItem _copy() {
        InstrumentListItem _x = new InstrumentListItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.listId = listId;
        _x.identifier = identifier;
        _x.identifierType = identifierType;
        _x.source = source;
        _x.userDefinedIdentifier = userDefinedIdentifier;
        _x.userDefinedIdentifier2 = userDefinedIdentifier2;
        _x.userDefinedIdentifier3 = userDefinedIdentifier3;
        _x.userDefinedIdentifier4 = userDefinedIdentifier4;
        _x.userDefinedIdentifier5 = userDefinedIdentifier5;
        _x.userDefinedIdentifier6 = userDefinedIdentifier6;
        _x.order = order;
        _x.description = description;
        _x.instrumentListItemKey = instrumentListItemKey;
        _x.instrumentKey = instrumentKey;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InstrumentListItem[");
        b.append("ListId=");
        b.append(this.listId);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("Source=");
        b.append(this.source);
        b.append(", ");
        b.append("UserDefinedIdentifier=");
        b.append(this.userDefinedIdentifier);
        b.append(", ");
        b.append("UserDefinedIdentifier2=");
        b.append(this.userDefinedIdentifier2);
        b.append(", ");
        b.append("UserDefinedIdentifier3=");
        b.append(this.userDefinedIdentifier3);
        b.append(", ");
        b.append("UserDefinedIdentifier4=");
        b.append(this.userDefinedIdentifier4);
        b.append(", ");
        b.append("UserDefinedIdentifier5=");
        b.append(this.userDefinedIdentifier5);
        b.append(", ");
        b.append("UserDefinedIdentifier6=");
        b.append(this.userDefinedIdentifier6);
        b.append(", ");
        b.append("Order=");
        b.append(this.order);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("InstrumentListItemKey=");
        b.append(this.instrumentListItemKey);
        b.append(", ");
        b.append("InstrumentKey=");
        b.append(this.instrumentKey);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
