package thomsonreuters.dss.api.extractions.subjectlists.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.extractions.schedules.collection.request.ScheduleCollectionRequest;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ListId", 
    "Name"})
public class SubjectList implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.SubjectList";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ListId")
    protected String listId;

    @JsonProperty("Name")
    protected String name;

    protected SubjectList() {
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && listId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(listId.toString()));
        }
    }

    @Property(name="ListId")
    @JsonIgnore
    public Optional<String> getListId() {
        return Optional.ofNullable(listId);
    }

    public SubjectList withListId(String listId) {
        SubjectList _x = _copy();
        _x.changedFields = changedFields.add("ListId");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.SubjectList");
        _x.listId = listId;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public SubjectList withName(String name) {
        SubjectList _x = _copy();
        _x.changedFields = changedFields.add("Name");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.SubjectList");
        _x.name = name;
        return _x;
    }

    @NavigationProperty(name="Schedules")
    @JsonIgnore
    public ScheduleCollectionRequest getSchedules() {
        return new ScheduleCollectionRequest(
                        contextPath.addSegment("Schedules"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SubjectList patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SubjectList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SubjectList put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SubjectList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SubjectList _copy() {
        SubjectList _x = new SubjectList();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.listId = listId;
        _x.name = name;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SubjectList[");
        b.append("ListId=");
        b.append(this.listId);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
