package thomsonreuters.dss.api.extractions.subjectlists.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import thomsonreuters.dss.api.extractions.subjectlists.collection.request.EntityListItemCollectionRequest;
import thomsonreuters.dss.api.extractions.subjectlists.entity.EntityList;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.EntityListItemEntityRequest;
import thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo;

@JsonIgnoreType
public class EntityListEntityRequest extends EntityRequest<EntityList> {

    public EntityListEntityRequest(ContextPath contextPath) {
        super(EntityList.class, contextPath, SchemaInfo.INSTANCE);
    }

    public EntityListItemCollectionRequest items() {
        return new EntityListItemCollectionRequest(
                        contextPath.addSegment("Items"));
    }

    public EntityListItemEntityRequest items(String entityListItemKey) {
        return new EntityListItemEntityRequest(contextPath.addSegment("Items").addKeys(new NameValue(entityListItemKey.toString())));
    }

}
