package thomsonreuters.dss.api.extractions.subjectlists.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import thomsonreuters.dss.api.extractions.subjectlists.entity.EntityListItem;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.EntityListEntityRequest;
import thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo;

@JsonIgnoreType
public class EntityListItemEntityRequest extends EntityRequest<EntityListItem> {

    public EntityListItemEntityRequest(ContextPath contextPath) {
        super(EntityListItem.class, contextPath, SchemaInfo.INSTANCE);
    }

    public EntityListEntityRequest entityList() {
        return new EntityListEntityRequest(contextPath.addSegment("EntityList"));
    }

}
