package thomsonreuters.dss.api.extractions.subjectlists.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import thomsonreuters.dss.api.extractions.subjectlists.collection.request.InstrumentListItemCollectionRequest;
import thomsonreuters.dss.api.extractions.subjectlists.entity.InstrumentList;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.InstrumentListItemEntityRequest;
import thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo;

@JsonIgnoreType
public class InstrumentListEntityRequest extends EntityRequest<InstrumentList> {

    public InstrumentListEntityRequest(ContextPath contextPath) {
        super(InstrumentList.class, contextPath, SchemaInfo.INSTANCE);
    }

    public InstrumentListItemCollectionRequest items() {
        return new InstrumentListItemCollectionRequest(
                        contextPath.addSegment("Items"));
    }

    public InstrumentListItemEntityRequest items(String instrumentListItemKey) {
        return new InstrumentListItemEntityRequest(contextPath.addSegment("Items").addKeys(new NameValue(instrumentListItemKey.toString())));
    }

}
