package thomsonreuters.dss.api.extractions.subjectlists.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import thomsonreuters.dss.api.extractions.subjectlists.entity.InstrumentListItem;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.InstrumentListEntityRequest;
import thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo;

@JsonIgnoreType
public class InstrumentListItemEntityRequest extends EntityRequest<InstrumentListItem> {

    public InstrumentListItemEntityRequest(ContextPath contextPath) {
        super(InstrumentListItem.class, contextPath, SchemaInfo.INSTANCE);
    }

    public InstrumentListEntityRequest instrumentList() {
        return new InstrumentListEntityRequest(contextPath.addSegment("InstrumentList"));
    }

}
