package thomsonreuters.dss.api.extractions.subjectlists.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import thomsonreuters.dss.api.extractions.schedules.collection.request.ScheduleCollectionRequest;
import thomsonreuters.dss.api.extractions.schedules.entity.request.ScheduleEntityRequest;
import thomsonreuters.dss.api.extractions.subjectlists.entity.SubjectList;
import thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo;

@JsonIgnoreType
public class SubjectListEntityRequest extends EntityRequest<SubjectList> {

    public SubjectListEntityRequest(ContextPath contextPath) {
        super(SubjectList.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ScheduleCollectionRequest schedules() {
        return new ScheduleCollectionRequest(
                        contextPath.addSegment("Schedules"));
    }

    public ScheduleEntityRequest schedules(String scheduleId) {
        return new ScheduleEntityRequest(contextPath.addSegment("Schedules").addKeys(new NameValue(scheduleId.toString())));
    }

}
