package thomsonreuters.dss.api.extractions.subjectlists.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum CriteriaListType implements Enum {

    @JsonProperty("Commodities")
    COMMODITIES("Commodities", "0"),

    @JsonProperty("Loans")
    LOANS("Loans", "1"),

    @JsonProperty("DTC")
    DTC("DTC", "2"),

    @JsonProperty("MifidSubclass")
    MIFID_SUBCLASS("MifidSubclass", "3");

    private final String name;
    private final String value;

    private CriteriaListType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
