package thomsonreuters.dss.api.extractions.subjectlists.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum EntityValidationMessageSeverity implements Enum {

    @JsonProperty("Info")
    INFO("Info", "0"),

    @JsonProperty("Warning")
    WARNING("Warning", "1"),

    @JsonProperty("Error")
    ERROR("Error", "2");

    private final String name;
    private final String value;

    private EntityValidationMessageSeverity(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
