package thomsonreuters.dss.api.extractions.subjectlists.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum InstrumentListExportFormat implements Enum {

    @JsonProperty("Xml")
    XML("Xml", "0"),

    @JsonProperty("Csv")
    CSV("Csv", "1");

    private final String name;
    private final String value;

    private InstrumentListExportFormat(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
