package thomsonreuters.dss.api.extractions.subjectlists.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MultiValueOperator implements Enum {

    @JsonProperty("In")
    IN("In", "0"),

    @JsonProperty("NotIn")
    NOT_IN("NotIn", "1");

    private final String name;
    private final String value;

    private MultiValueOperator(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
