package thomsonreuters.dss.api.extractions.subjectlists.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RangeOperator implements Enum {

    @JsonProperty("Equal")
    EQUAL("Equal", "0"),

    @JsonProperty("NotEqual")
    NOT_EQUAL("NotEqual", "1"),

    @JsonProperty("GreaterThan")
    GREATER_THAN("GreaterThan", "2"),

    @JsonProperty("GreaterThanOrEqual")
    GREATER_THAN_OR_EQUAL("GreaterThanOrEqual", "3"),

    @JsonProperty("LessThan")
    LESS_THAN("LessThan", "4"),

    @JsonProperty("LessThanOrEqual")
    LESS_THAN_OR_EQUAL("LessThanOrEqual", "5"),

    @JsonProperty("Between")
    BETWEEN("Between", "6");

    private final String name;
    private final String value;

    private RangeOperator(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
