package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.enums.InstrumentTypeGroup;
import thomsonreuters.dss.api.content.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "InstrumentTypeGroups", 
    "IdentifierType", 
    "Identifier", 
    "PreferredIdentifierType"})
public class AllInstrumentSearchRequest implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("InstrumentTypeGroups")
    protected List<InstrumentTypeGroup> instrumentTypeGroups;

    @JsonProperty("InstrumentTypeGroups@nextLink")
    protected String instrumentTypeGroupsNextLink;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("PreferredIdentifierType")
    protected IdentifierType preferredIdentifierType;

    protected AllInstrumentSearchRequest() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.AllInstrumentSearchRequest";
    }

    @Property(name="InstrumentTypeGroups")
    @JsonIgnore
    public CollectionPage<InstrumentTypeGroup> getInstrumentTypeGroups() {
        return new CollectionPage<InstrumentTypeGroup>(contextPath, InstrumentTypeGroup.class, instrumentTypeGroups, Optional.ofNullable(instrumentTypeGroupsNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public AllInstrumentSearchRequest withIdentifierType(IdentifierType identifierType) {
        AllInstrumentSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.AllInstrumentSearchRequest");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public AllInstrumentSearchRequest withIdentifier(String identifier) {
        AllInstrumentSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.AllInstrumentSearchRequest");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="PreferredIdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getPreferredIdentifierType() {
        return Optional.ofNullable(preferredIdentifierType);
    }

    public AllInstrumentSearchRequest withPreferredIdentifierType(IdentifierType preferredIdentifierType) {
        AllInstrumentSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.AllInstrumentSearchRequest");
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<InstrumentTypeGroup> instrumentTypeGroups;
        private String instrumentTypeGroupsNextLink;
        private IdentifierType identifierType;
        private String identifier;
        private IdentifierType preferredIdentifierType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder instrumentTypeGroups(List<InstrumentTypeGroup> instrumentTypeGroups) {
            this.instrumentTypeGroups = instrumentTypeGroups;
            this.changedFields = changedFields.add("InstrumentTypeGroups");
            return this;
        }

        public Builder instrumentTypeGroupsNextLink(String instrumentTypeGroupsNextLink) {
            this.instrumentTypeGroupsNextLink = instrumentTypeGroupsNextLink;
            this.changedFields = changedFields.add("InstrumentTypeGroups");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder preferredIdentifierType(IdentifierType preferredIdentifierType) {
            this.preferredIdentifierType = preferredIdentifierType;
            this.changedFields = changedFields.add("PreferredIdentifierType");
            return this;
        }

        public AllInstrumentSearchRequest build() {
            AllInstrumentSearchRequest _x = new AllInstrumentSearchRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.AllInstrumentSearchRequest";
            _x.instrumentTypeGroups = instrumentTypeGroups;
            _x.instrumentTypeGroupsNextLink = instrumentTypeGroupsNextLink;
            _x.identifierType = identifierType;
            _x.identifier = identifier;
            _x.preferredIdentifierType = preferredIdentifierType;
            return _x;
        }
    }

    private AllInstrumentSearchRequest _copy() {
        AllInstrumentSearchRequest _x = new AllInstrumentSearchRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.instrumentTypeGroups = instrumentTypeGroups;
        _x.identifierType = identifierType;
        _x.identifier = identifier;
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AllInstrumentSearchRequest[");
        b.append("InstrumentTypeGroups=");
        b.append(this.instrumentTypeGroups);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("PreferredIdentifierType=");
        b.append(this.preferredIdentifierType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
