package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.fixedincome.cmoabs.enums.CmoAbsStatus;
import thomsonreuters.dss.api.content.fixedincome.cmoabs.schema.SchemaInfo;
import thomsonreuters.dss.api.search.complex.CmoAbsSecurityGroup;
import thomsonreuters.dss.api.search.complex.NumericComparison;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "SecurityGroup", 
    "Issue", 
    "Tranche", 
    "Series", 
    "CouponRate", 
    "AssetStatuses", 
    "CurrencyCodes", 
    "IdentifierType", 
    "Identifier", 
    "PreferredIdentifierType"})
public class CmoAbsSearchRequest implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("SecurityGroup")
    protected CmoAbsSecurityGroup securityGroup;

    @JsonProperty("Issue")
    protected String issue;

    @JsonProperty("Tranche")
    protected String tranche;

    @JsonProperty("Series")
    protected String series;

    @JsonProperty("CouponRate")
    protected NumericComparison couponRate;

    @JsonProperty("AssetStatuses")
    protected List<CmoAbsStatus> assetStatuses;

    @JsonProperty("AssetStatuses@nextLink")
    protected String assetStatusesNextLink;

    @JsonProperty("CurrencyCodes")
    protected List<String> currencyCodes;

    @JsonProperty("CurrencyCodes@nextLink")
    protected String currencyCodesNextLink;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("PreferredIdentifierType")
    protected IdentifierType preferredIdentifierType;

    protected CmoAbsSearchRequest() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.CmoAbsSearchRequest";
    }

    @Property(name="SecurityGroup")
    @JsonIgnore
    public Optional<CmoAbsSecurityGroup> getSecurityGroup() {
        return Optional.ofNullable(securityGroup);
    }

    public CmoAbsSearchRequest withSecurityGroup(CmoAbsSecurityGroup securityGroup) {
        CmoAbsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CmoAbsSearchRequest");
        _x.securityGroup = securityGroup;
        return _x;
    }

    @Property(name="Issue")
    @JsonIgnore
    public Optional<String> getIssue() {
        return Optional.ofNullable(issue);
    }

    public CmoAbsSearchRequest withIssue(String issue) {
        CmoAbsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CmoAbsSearchRequest");
        _x.issue = issue;
        return _x;
    }

    @Property(name="Tranche")
    @JsonIgnore
    public Optional<String> getTranche() {
        return Optional.ofNullable(tranche);
    }

    public CmoAbsSearchRequest withTranche(String tranche) {
        CmoAbsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CmoAbsSearchRequest");
        _x.tranche = tranche;
        return _x;
    }

    @Property(name="Series")
    @JsonIgnore
    public Optional<String> getSeries() {
        return Optional.ofNullable(series);
    }

    public CmoAbsSearchRequest withSeries(String series) {
        CmoAbsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CmoAbsSearchRequest");
        _x.series = series;
        return _x;
    }

    @Property(name="CouponRate")
    @JsonIgnore
    public Optional<NumericComparison> getCouponRate() {
        return Optional.ofNullable(couponRate);
    }

    public CmoAbsSearchRequest withCouponRate(NumericComparison couponRate) {
        CmoAbsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CmoAbsSearchRequest");
        _x.couponRate = couponRate;
        return _x;
    }

    @Property(name="AssetStatuses")
    @JsonIgnore
    public CollectionPage<CmoAbsStatus> getAssetStatuses() {
        return new CollectionPage<CmoAbsStatus>(contextPath, CmoAbsStatus.class, assetStatuses, Optional.ofNullable(assetStatusesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="CurrencyCodes")
    @JsonIgnore
    public CollectionPage<String> getCurrencyCodes() {
        return new CollectionPage<String>(contextPath, String.class, currencyCodes, Optional.ofNullable(currencyCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public CmoAbsSearchRequest withIdentifierType(IdentifierType identifierType) {
        CmoAbsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CmoAbsSearchRequest");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public CmoAbsSearchRequest withIdentifier(String identifier) {
        CmoAbsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CmoAbsSearchRequest");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="PreferredIdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getPreferredIdentifierType() {
        return Optional.ofNullable(preferredIdentifierType);
    }

    public CmoAbsSearchRequest withPreferredIdentifierType(IdentifierType preferredIdentifierType) {
        CmoAbsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CmoAbsSearchRequest");
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CmoAbsSecurityGroup securityGroup;
        private String issue;
        private String tranche;
        private String series;
        private NumericComparison couponRate;
        private List<CmoAbsStatus> assetStatuses;
        private String assetStatusesNextLink;
        private List<String> currencyCodes;
        private String currencyCodesNextLink;
        private IdentifierType identifierType;
        private String identifier;
        private IdentifierType preferredIdentifierType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder securityGroup(CmoAbsSecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            this.changedFields = changedFields.add("SecurityGroup");
            return this;
        }

        public Builder issue(String issue) {
            this.issue = issue;
            this.changedFields = changedFields.add("Issue");
            return this;
        }

        public Builder tranche(String tranche) {
            this.tranche = tranche;
            this.changedFields = changedFields.add("Tranche");
            return this;
        }

        public Builder series(String series) {
            this.series = series;
            this.changedFields = changedFields.add("Series");
            return this;
        }

        public Builder couponRate(NumericComparison couponRate) {
            this.couponRate = couponRate;
            this.changedFields = changedFields.add("CouponRate");
            return this;
        }

        public Builder assetStatuses(List<CmoAbsStatus> assetStatuses) {
            this.assetStatuses = assetStatuses;
            this.changedFields = changedFields.add("AssetStatuses");
            return this;
        }

        public Builder assetStatusesNextLink(String assetStatusesNextLink) {
            this.assetStatusesNextLink = assetStatusesNextLink;
            this.changedFields = changedFields.add("AssetStatuses");
            return this;
        }

        public Builder currencyCodes(List<String> currencyCodes) {
            this.currencyCodes = currencyCodes;
            this.changedFields = changedFields.add("CurrencyCodes");
            return this;
        }

        public Builder currencyCodesNextLink(String currencyCodesNextLink) {
            this.currencyCodesNextLink = currencyCodesNextLink;
            this.changedFields = changedFields.add("CurrencyCodes");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder preferredIdentifierType(IdentifierType preferredIdentifierType) {
            this.preferredIdentifierType = preferredIdentifierType;
            this.changedFields = changedFields.add("PreferredIdentifierType");
            return this;
        }

        public CmoAbsSearchRequest build() {
            CmoAbsSearchRequest _x = new CmoAbsSearchRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.CmoAbsSearchRequest";
            _x.securityGroup = securityGroup;
            _x.issue = issue;
            _x.tranche = tranche;
            _x.series = series;
            _x.couponRate = couponRate;
            _x.assetStatuses = assetStatuses;
            _x.assetStatusesNextLink = assetStatusesNextLink;
            _x.currencyCodes = currencyCodes;
            _x.currencyCodesNextLink = currencyCodesNextLink;
            _x.identifierType = identifierType;
            _x.identifier = identifier;
            _x.preferredIdentifierType = preferredIdentifierType;
            return _x;
        }
    }

    private CmoAbsSearchRequest _copy() {
        CmoAbsSearchRequest _x = new CmoAbsSearchRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.securityGroup = securityGroup;
        _x.issue = issue;
        _x.tranche = tranche;
        _x.series = series;
        _x.couponRate = couponRate;
        _x.assetStatuses = assetStatuses;
        _x.currencyCodes = currencyCodes;
        _x.identifierType = identifierType;
        _x.identifier = identifier;
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CmoAbsSearchRequest[");
        b.append("SecurityGroup=");
        b.append(this.securityGroup);
        b.append(", ");
        b.append("Issue=");
        b.append(this.issue);
        b.append(", ");
        b.append("Tranche=");
        b.append(this.tranche);
        b.append(", ");
        b.append("Series=");
        b.append(this.series);
        b.append(", ");
        b.append("CouponRate=");
        b.append(this.couponRate);
        b.append(", ");
        b.append("AssetStatuses=");
        b.append(this.assetStatuses);
        b.append(", ");
        b.append("CurrencyCodes=");
        b.append(this.currencyCodes);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("PreferredIdentifierType=");
        b.append(this.preferredIdentifierType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
