package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Agency", 
    "AssetBacked", 
    "Cdo", 
    "Cmbs", 
    "WholeLoan", 
    "SubGroupTypeCode"})
public class CmoAbsSecurityGroup implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Agency")
    protected Boolean agency;

    @JsonProperty("AssetBacked")
    protected Boolean assetBacked;

    @JsonProperty("Cdo")
    protected Boolean cdo;

    @JsonProperty("Cmbs")
    protected Boolean cmbs;

    @JsonProperty("WholeLoan")
    protected Boolean wholeLoan;

    @JsonProperty("SubGroupTypeCode")
    protected String subGroupTypeCode;

    protected CmoAbsSecurityGroup() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.CmoAbsSecurityGroup";
    }

    @Property(name="Agency")
    @JsonIgnore
    public Optional<Boolean> getAgency() {
        return Optional.ofNullable(agency);
    }

    public CmoAbsSecurityGroup withAgency(Boolean agency) {
        CmoAbsSecurityGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CmoAbsSecurityGroup");
        _x.agency = agency;
        return _x;
    }

    @Property(name="AssetBacked")
    @JsonIgnore
    public Optional<Boolean> getAssetBacked() {
        return Optional.ofNullable(assetBacked);
    }

    public CmoAbsSecurityGroup withAssetBacked(Boolean assetBacked) {
        CmoAbsSecurityGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CmoAbsSecurityGroup");
        _x.assetBacked = assetBacked;
        return _x;
    }

    @Property(name="Cdo")
    @JsonIgnore
    public Optional<Boolean> getCdo() {
        return Optional.ofNullable(cdo);
    }

    public CmoAbsSecurityGroup withCdo(Boolean cdo) {
        CmoAbsSecurityGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CmoAbsSecurityGroup");
        _x.cdo = cdo;
        return _x;
    }

    @Property(name="Cmbs")
    @JsonIgnore
    public Optional<Boolean> getCmbs() {
        return Optional.ofNullable(cmbs);
    }

    public CmoAbsSecurityGroup withCmbs(Boolean cmbs) {
        CmoAbsSecurityGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CmoAbsSecurityGroup");
        _x.cmbs = cmbs;
        return _x;
    }

    @Property(name="WholeLoan")
    @JsonIgnore
    public Optional<Boolean> getWholeLoan() {
        return Optional.ofNullable(wholeLoan);
    }

    public CmoAbsSecurityGroup withWholeLoan(Boolean wholeLoan) {
        CmoAbsSecurityGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CmoAbsSecurityGroup");
        _x.wholeLoan = wholeLoan;
        return _x;
    }

    @Property(name="SubGroupTypeCode")
    @JsonIgnore
    public Optional<String> getSubGroupTypeCode() {
        return Optional.ofNullable(subGroupTypeCode);
    }

    public CmoAbsSecurityGroup withSubGroupTypeCode(String subGroupTypeCode) {
        CmoAbsSecurityGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CmoAbsSecurityGroup");
        _x.subGroupTypeCode = subGroupTypeCode;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean agency;
        private Boolean assetBacked;
        private Boolean cdo;
        private Boolean cmbs;
        private Boolean wholeLoan;
        private String subGroupTypeCode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder agency(Boolean agency) {
            this.agency = agency;
            this.changedFields = changedFields.add("Agency");
            return this;
        }

        public Builder assetBacked(Boolean assetBacked) {
            this.assetBacked = assetBacked;
            this.changedFields = changedFields.add("AssetBacked");
            return this;
        }

        public Builder cdo(Boolean cdo) {
            this.cdo = cdo;
            this.changedFields = changedFields.add("Cdo");
            return this;
        }

        public Builder cmbs(Boolean cmbs) {
            this.cmbs = cmbs;
            this.changedFields = changedFields.add("Cmbs");
            return this;
        }

        public Builder wholeLoan(Boolean wholeLoan) {
            this.wholeLoan = wholeLoan;
            this.changedFields = changedFields.add("WholeLoan");
            return this;
        }

        public Builder subGroupTypeCode(String subGroupTypeCode) {
            this.subGroupTypeCode = subGroupTypeCode;
            this.changedFields = changedFields.add("SubGroupTypeCode");
            return this;
        }

        public CmoAbsSecurityGroup build() {
            CmoAbsSecurityGroup _x = new CmoAbsSecurityGroup();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.CmoAbsSecurityGroup";
            _x.agency = agency;
            _x.assetBacked = assetBacked;
            _x.cdo = cdo;
            _x.cmbs = cmbs;
            _x.wholeLoan = wholeLoan;
            _x.subGroupTypeCode = subGroupTypeCode;
            return _x;
        }
    }

    private CmoAbsSecurityGroup _copy() {
        CmoAbsSecurityGroup _x = new CmoAbsSecurityGroup();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.agency = agency;
        _x.assetBacked = assetBacked;
        _x.cdo = cdo;
        _x.cmbs = cmbs;
        _x.wholeLoan = wholeLoan;
        _x.subGroupTypeCode = subGroupTypeCode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CmoAbsSecurityGroup[");
        b.append("Agency=");
        b.append(this.agency);
        b.append(", ");
        b.append("AssetBacked=");
        b.append(this.assetBacked);
        b.append(", ");
        b.append("Cdo=");
        b.append(this.cdo);
        b.append(", ");
        b.append("Cmbs=");
        b.append(this.cmbs);
        b.append(", ");
        b.append("WholeLoan=");
        b.append(this.wholeLoan);
        b.append(", ");
        b.append("SubGroupTypeCode=");
        b.append(this.subGroupTypeCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
