package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.commodity.enums.CommodityStatus;
import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.search.complex.DateComparison;
import thomsonreuters.dss.api.search.enums.SetMembershipOperator;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "KeywordQuery", 
    "AssetStatus", 
    "ContractMonthAndYear", 
    "Description", 
    "ExpirationDate", 
    "PrimaryChain", 
    "AssetCategoryCodes", 
    "AssetCategoryCodesOperator", 
    "CurrencyCodes", 
    "CurrencyCodesOperator", 
    "ExchangeCodes", 
    "ExchangeCodesOperator", 
    "FileCodes", 
    "FileCodesOperator", 
    "FrequenciesOfUpdate", 
    "FrequenciesOfUpdateOperator", 
    "LotUnits", 
    "LotUnitsOperator", 
    "RcsUnderlyingProducts", 
    "RcsUnderlyingProductsOperator", 
    "SourceNames", 
    "SourceNamesOperator", 
    "SourceTypes", 
    "SourceTypesOperator", 
    "TrClassificationSchemes", 
    "TrClassificationSchemesOperator", 
    "CommoditiesUnderlyingAssets", 
    "CommoditiesUnderlyingAssetsOperator", 
    "PdpCodes", 
    "PdpCodesOperator", 
    "IdentifierType", 
    "Identifier", 
    "PreferredIdentifierType"})
public class CommoditySearchRequest implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("KeywordQuery")
    protected String keywordQuery;

    @JsonProperty("AssetStatus")
    protected CommodityStatus assetStatus;

    @JsonProperty("ContractMonthAndYear")
    protected String contractMonthAndYear;

    @JsonProperty("Description")
    protected String description;

    @JsonProperty("ExpirationDate")
    protected DateComparison expirationDate;

    @JsonProperty("PrimaryChain")
    protected String primaryChain;

    @JsonProperty("AssetCategoryCodes")
    protected List<String> assetCategoryCodes;

    @JsonProperty("AssetCategoryCodes@nextLink")
    protected String assetCategoryCodesNextLink;

    @JsonProperty("AssetCategoryCodesOperator")
    protected SetMembershipOperator assetCategoryCodesOperator;

    @JsonProperty("CurrencyCodes")
    protected List<String> currencyCodes;

    @JsonProperty("CurrencyCodes@nextLink")
    protected String currencyCodesNextLink;

    @JsonProperty("CurrencyCodesOperator")
    protected SetMembershipOperator currencyCodesOperator;

    @JsonProperty("ExchangeCodes")
    protected List<String> exchangeCodes;

    @JsonProperty("ExchangeCodes@nextLink")
    protected String exchangeCodesNextLink;

    @JsonProperty("ExchangeCodesOperator")
    protected SetMembershipOperator exchangeCodesOperator;

    @JsonProperty("FileCodes")
    protected List<String> fileCodes;

    @JsonProperty("FileCodes@nextLink")
    protected String fileCodesNextLink;

    @JsonProperty("FileCodesOperator")
    protected SetMembershipOperator fileCodesOperator;

    @JsonProperty("FrequenciesOfUpdate")
    protected List<String> frequenciesOfUpdate;

    @JsonProperty("FrequenciesOfUpdate@nextLink")
    protected String frequenciesOfUpdateNextLink;

    @JsonProperty("FrequenciesOfUpdateOperator")
    protected SetMembershipOperator frequenciesOfUpdateOperator;

    @JsonProperty("LotUnits")
    protected List<String> lotUnits;

    @JsonProperty("LotUnits@nextLink")
    protected String lotUnitsNextLink;

    @JsonProperty("LotUnitsOperator")
    protected SetMembershipOperator lotUnitsOperator;

    @JsonProperty("RcsUnderlyingProducts")
    protected List<String> rcsUnderlyingProducts;

    @JsonProperty("RcsUnderlyingProducts@nextLink")
    protected String rcsUnderlyingProductsNextLink;

    @JsonProperty("RcsUnderlyingProductsOperator")
    protected SetMembershipOperator rcsUnderlyingProductsOperator;

    @JsonProperty("SourceNames")
    protected List<String> sourceNames;

    @JsonProperty("SourceNames@nextLink")
    protected String sourceNamesNextLink;

    @JsonProperty("SourceNamesOperator")
    protected SetMembershipOperator sourceNamesOperator;

    @JsonProperty("SourceTypes")
    protected List<String> sourceTypes;

    @JsonProperty("SourceTypes@nextLink")
    protected String sourceTypesNextLink;

    @JsonProperty("SourceTypesOperator")
    protected SetMembershipOperator sourceTypesOperator;

    @JsonProperty("TrClassificationSchemes")
    protected List<String> trClassificationSchemes;

    @JsonProperty("TrClassificationSchemes@nextLink")
    protected String trClassificationSchemesNextLink;

    @JsonProperty("TrClassificationSchemesOperator")
    protected SetMembershipOperator trClassificationSchemesOperator;

    @JsonProperty("CommoditiesUnderlyingAssets")
    protected List<String> commoditiesUnderlyingAssets;

    @JsonProperty("CommoditiesUnderlyingAssets@nextLink")
    protected String commoditiesUnderlyingAssetsNextLink;

    @JsonProperty("CommoditiesUnderlyingAssetsOperator")
    protected SetMembershipOperator commoditiesUnderlyingAssetsOperator;

    @JsonProperty("PdpCodes")
    protected List<String> pdpCodes;

    @JsonProperty("PdpCodes@nextLink")
    protected String pdpCodesNextLink;

    @JsonProperty("PdpCodesOperator")
    protected SetMembershipOperator pdpCodesOperator;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("PreferredIdentifierType")
    protected IdentifierType preferredIdentifierType;

    protected CommoditySearchRequest() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest";
    }

    @Property(name="KeywordQuery")
    @JsonIgnore
    public Optional<String> getKeywordQuery() {
        return Optional.ofNullable(keywordQuery);
    }

    public CommoditySearchRequest withKeywordQuery(String keywordQuery) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.keywordQuery = keywordQuery;
        return _x;
    }

    @Property(name="AssetStatus")
    @JsonIgnore
    public Optional<CommodityStatus> getAssetStatus() {
        return Optional.ofNullable(assetStatus);
    }

    public CommoditySearchRequest withAssetStatus(CommodityStatus assetStatus) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.assetStatus = assetStatus;
        return _x;
    }

    @Property(name="ContractMonthAndYear")
    @JsonIgnore
    public Optional<String> getContractMonthAndYear() {
        return Optional.ofNullable(contractMonthAndYear);
    }

    public CommoditySearchRequest withContractMonthAndYear(String contractMonthAndYear) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.contractMonthAndYear = contractMonthAndYear;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public CommoditySearchRequest withDescription(String description) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.description = description;
        return _x;
    }

    @Property(name="ExpirationDate")
    @JsonIgnore
    public Optional<DateComparison> getExpirationDate() {
        return Optional.ofNullable(expirationDate);
    }

    public CommoditySearchRequest withExpirationDate(DateComparison expirationDate) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.expirationDate = expirationDate;
        return _x;
    }

    @Property(name="PrimaryChain")
    @JsonIgnore
    public Optional<String> getPrimaryChain() {
        return Optional.ofNullable(primaryChain);
    }

    public CommoditySearchRequest withPrimaryChain(String primaryChain) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.primaryChain = primaryChain;
        return _x;
    }

    @Property(name="AssetCategoryCodes")
    @JsonIgnore
    public CollectionPage<String> getAssetCategoryCodes() {
        return new CollectionPage<String>(contextPath, String.class, assetCategoryCodes, Optional.ofNullable(assetCategoryCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="AssetCategoryCodesOperator")
    @JsonIgnore
    public Optional<SetMembershipOperator> getAssetCategoryCodesOperator() {
        return Optional.ofNullable(assetCategoryCodesOperator);
    }

    public CommoditySearchRequest withAssetCategoryCodesOperator(SetMembershipOperator assetCategoryCodesOperator) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.assetCategoryCodesOperator = assetCategoryCodesOperator;
        return _x;
    }

    @Property(name="CurrencyCodes")
    @JsonIgnore
    public CollectionPage<String> getCurrencyCodes() {
        return new CollectionPage<String>(contextPath, String.class, currencyCodes, Optional.ofNullable(currencyCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="CurrencyCodesOperator")
    @JsonIgnore
    public Optional<SetMembershipOperator> getCurrencyCodesOperator() {
        return Optional.ofNullable(currencyCodesOperator);
    }

    public CommoditySearchRequest withCurrencyCodesOperator(SetMembershipOperator currencyCodesOperator) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.currencyCodesOperator = currencyCodesOperator;
        return _x;
    }

    @Property(name="ExchangeCodes")
    @JsonIgnore
    public CollectionPage<String> getExchangeCodes() {
        return new CollectionPage<String>(contextPath, String.class, exchangeCodes, Optional.ofNullable(exchangeCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="ExchangeCodesOperator")
    @JsonIgnore
    public Optional<SetMembershipOperator> getExchangeCodesOperator() {
        return Optional.ofNullable(exchangeCodesOperator);
    }

    public CommoditySearchRequest withExchangeCodesOperator(SetMembershipOperator exchangeCodesOperator) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.exchangeCodesOperator = exchangeCodesOperator;
        return _x;
    }

    @Property(name="FileCodes")
    @JsonIgnore
    public CollectionPage<String> getFileCodes() {
        return new CollectionPage<String>(contextPath, String.class, fileCodes, Optional.ofNullable(fileCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="FileCodesOperator")
    @JsonIgnore
    public Optional<SetMembershipOperator> getFileCodesOperator() {
        return Optional.ofNullable(fileCodesOperator);
    }

    public CommoditySearchRequest withFileCodesOperator(SetMembershipOperator fileCodesOperator) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.fileCodesOperator = fileCodesOperator;
        return _x;
    }

    @Property(name="FrequenciesOfUpdate")
    @JsonIgnore
    public CollectionPage<String> getFrequenciesOfUpdate() {
        return new CollectionPage<String>(contextPath, String.class, frequenciesOfUpdate, Optional.ofNullable(frequenciesOfUpdateNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="FrequenciesOfUpdateOperator")
    @JsonIgnore
    public Optional<SetMembershipOperator> getFrequenciesOfUpdateOperator() {
        return Optional.ofNullable(frequenciesOfUpdateOperator);
    }

    public CommoditySearchRequest withFrequenciesOfUpdateOperator(SetMembershipOperator frequenciesOfUpdateOperator) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.frequenciesOfUpdateOperator = frequenciesOfUpdateOperator;
        return _x;
    }

    @Property(name="LotUnits")
    @JsonIgnore
    public CollectionPage<String> getLotUnits() {
        return new CollectionPage<String>(contextPath, String.class, lotUnits, Optional.ofNullable(lotUnitsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="LotUnitsOperator")
    @JsonIgnore
    public Optional<SetMembershipOperator> getLotUnitsOperator() {
        return Optional.ofNullable(lotUnitsOperator);
    }

    public CommoditySearchRequest withLotUnitsOperator(SetMembershipOperator lotUnitsOperator) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.lotUnitsOperator = lotUnitsOperator;
        return _x;
    }

    @Property(name="RcsUnderlyingProducts")
    @JsonIgnore
    public CollectionPage<String> getRcsUnderlyingProducts() {
        return new CollectionPage<String>(contextPath, String.class, rcsUnderlyingProducts, Optional.ofNullable(rcsUnderlyingProductsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="RcsUnderlyingProductsOperator")
    @JsonIgnore
    public Optional<SetMembershipOperator> getRcsUnderlyingProductsOperator() {
        return Optional.ofNullable(rcsUnderlyingProductsOperator);
    }

    public CommoditySearchRequest withRcsUnderlyingProductsOperator(SetMembershipOperator rcsUnderlyingProductsOperator) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.rcsUnderlyingProductsOperator = rcsUnderlyingProductsOperator;
        return _x;
    }

    @Property(name="SourceNames")
    @JsonIgnore
    public CollectionPage<String> getSourceNames() {
        return new CollectionPage<String>(contextPath, String.class, sourceNames, Optional.ofNullable(sourceNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="SourceNamesOperator")
    @JsonIgnore
    public Optional<SetMembershipOperator> getSourceNamesOperator() {
        return Optional.ofNullable(sourceNamesOperator);
    }

    public CommoditySearchRequest withSourceNamesOperator(SetMembershipOperator sourceNamesOperator) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.sourceNamesOperator = sourceNamesOperator;
        return _x;
    }

    @Property(name="SourceTypes")
    @JsonIgnore
    public CollectionPage<String> getSourceTypes() {
        return new CollectionPage<String>(contextPath, String.class, sourceTypes, Optional.ofNullable(sourceTypesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="SourceTypesOperator")
    @JsonIgnore
    public Optional<SetMembershipOperator> getSourceTypesOperator() {
        return Optional.ofNullable(sourceTypesOperator);
    }

    public CommoditySearchRequest withSourceTypesOperator(SetMembershipOperator sourceTypesOperator) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.sourceTypesOperator = sourceTypesOperator;
        return _x;
    }

    @Property(name="TrClassificationSchemes")
    @JsonIgnore
    public CollectionPage<String> getTrClassificationSchemes() {
        return new CollectionPage<String>(contextPath, String.class, trClassificationSchemes, Optional.ofNullable(trClassificationSchemesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="TrClassificationSchemesOperator")
    @JsonIgnore
    public Optional<SetMembershipOperator> getTrClassificationSchemesOperator() {
        return Optional.ofNullable(trClassificationSchemesOperator);
    }

    public CommoditySearchRequest withTrClassificationSchemesOperator(SetMembershipOperator trClassificationSchemesOperator) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.trClassificationSchemesOperator = trClassificationSchemesOperator;
        return _x;
    }

    @Property(name="CommoditiesUnderlyingAssets")
    @JsonIgnore
    public CollectionPage<String> getCommoditiesUnderlyingAssets() {
        return new CollectionPage<String>(contextPath, String.class, commoditiesUnderlyingAssets, Optional.ofNullable(commoditiesUnderlyingAssetsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="CommoditiesUnderlyingAssetsOperator")
    @JsonIgnore
    public Optional<SetMembershipOperator> getCommoditiesUnderlyingAssetsOperator() {
        return Optional.ofNullable(commoditiesUnderlyingAssetsOperator);
    }

    public CommoditySearchRequest withCommoditiesUnderlyingAssetsOperator(SetMembershipOperator commoditiesUnderlyingAssetsOperator) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.commoditiesUnderlyingAssetsOperator = commoditiesUnderlyingAssetsOperator;
        return _x;
    }

    @Property(name="PdpCodes")
    @JsonIgnore
    public CollectionPage<String> getPdpCodes() {
        return new CollectionPage<String>(contextPath, String.class, pdpCodes, Optional.ofNullable(pdpCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="PdpCodesOperator")
    @JsonIgnore
    public Optional<SetMembershipOperator> getPdpCodesOperator() {
        return Optional.ofNullable(pdpCodesOperator);
    }

    public CommoditySearchRequest withPdpCodesOperator(SetMembershipOperator pdpCodesOperator) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.pdpCodesOperator = pdpCodesOperator;
        return _x;
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public CommoditySearchRequest withIdentifierType(IdentifierType identifierType) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public CommoditySearchRequest withIdentifier(String identifier) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="PreferredIdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getPreferredIdentifierType() {
        return Optional.ofNullable(preferredIdentifierType);
    }

    public CommoditySearchRequest withPreferredIdentifierType(IdentifierType preferredIdentifierType) {
        CommoditySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest");
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String keywordQuery;
        private CommodityStatus assetStatus;
        private String contractMonthAndYear;
        private String description;
        private DateComparison expirationDate;
        private String primaryChain;
        private List<String> assetCategoryCodes;
        private String assetCategoryCodesNextLink;
        private SetMembershipOperator assetCategoryCodesOperator;
        private List<String> currencyCodes;
        private String currencyCodesNextLink;
        private SetMembershipOperator currencyCodesOperator;
        private List<String> exchangeCodes;
        private String exchangeCodesNextLink;
        private SetMembershipOperator exchangeCodesOperator;
        private List<String> fileCodes;
        private String fileCodesNextLink;
        private SetMembershipOperator fileCodesOperator;
        private List<String> frequenciesOfUpdate;
        private String frequenciesOfUpdateNextLink;
        private SetMembershipOperator frequenciesOfUpdateOperator;
        private List<String> lotUnits;
        private String lotUnitsNextLink;
        private SetMembershipOperator lotUnitsOperator;
        private List<String> rcsUnderlyingProducts;
        private String rcsUnderlyingProductsNextLink;
        private SetMembershipOperator rcsUnderlyingProductsOperator;
        private List<String> sourceNames;
        private String sourceNamesNextLink;
        private SetMembershipOperator sourceNamesOperator;
        private List<String> sourceTypes;
        private String sourceTypesNextLink;
        private SetMembershipOperator sourceTypesOperator;
        private List<String> trClassificationSchemes;
        private String trClassificationSchemesNextLink;
        private SetMembershipOperator trClassificationSchemesOperator;
        private List<String> commoditiesUnderlyingAssets;
        private String commoditiesUnderlyingAssetsNextLink;
        private SetMembershipOperator commoditiesUnderlyingAssetsOperator;
        private List<String> pdpCodes;
        private String pdpCodesNextLink;
        private SetMembershipOperator pdpCodesOperator;
        private IdentifierType identifierType;
        private String identifier;
        private IdentifierType preferredIdentifierType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder keywordQuery(String keywordQuery) {
            this.keywordQuery = keywordQuery;
            this.changedFields = changedFields.add("KeywordQuery");
            return this;
        }

        public Builder assetStatus(CommodityStatus assetStatus) {
            this.assetStatus = assetStatus;
            this.changedFields = changedFields.add("AssetStatus");
            return this;
        }

        public Builder contractMonthAndYear(String contractMonthAndYear) {
            this.contractMonthAndYear = contractMonthAndYear;
            this.changedFields = changedFields.add("ContractMonthAndYear");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder expirationDate(DateComparison expirationDate) {
            this.expirationDate = expirationDate;
            this.changedFields = changedFields.add("ExpirationDate");
            return this;
        }

        public Builder primaryChain(String primaryChain) {
            this.primaryChain = primaryChain;
            this.changedFields = changedFields.add("PrimaryChain");
            return this;
        }

        public Builder assetCategoryCodes(List<String> assetCategoryCodes) {
            this.assetCategoryCodes = assetCategoryCodes;
            this.changedFields = changedFields.add("AssetCategoryCodes");
            return this;
        }

        public Builder assetCategoryCodesNextLink(String assetCategoryCodesNextLink) {
            this.assetCategoryCodesNextLink = assetCategoryCodesNextLink;
            this.changedFields = changedFields.add("AssetCategoryCodes");
            return this;
        }

        public Builder assetCategoryCodesOperator(SetMembershipOperator assetCategoryCodesOperator) {
            this.assetCategoryCodesOperator = assetCategoryCodesOperator;
            this.changedFields = changedFields.add("AssetCategoryCodesOperator");
            return this;
        }

        public Builder currencyCodes(List<String> currencyCodes) {
            this.currencyCodes = currencyCodes;
            this.changedFields = changedFields.add("CurrencyCodes");
            return this;
        }

        public Builder currencyCodesNextLink(String currencyCodesNextLink) {
            this.currencyCodesNextLink = currencyCodesNextLink;
            this.changedFields = changedFields.add("CurrencyCodes");
            return this;
        }

        public Builder currencyCodesOperator(SetMembershipOperator currencyCodesOperator) {
            this.currencyCodesOperator = currencyCodesOperator;
            this.changedFields = changedFields.add("CurrencyCodesOperator");
            return this;
        }

        public Builder exchangeCodes(List<String> exchangeCodes) {
            this.exchangeCodes = exchangeCodes;
            this.changedFields = changedFields.add("ExchangeCodes");
            return this;
        }

        public Builder exchangeCodesNextLink(String exchangeCodesNextLink) {
            this.exchangeCodesNextLink = exchangeCodesNextLink;
            this.changedFields = changedFields.add("ExchangeCodes");
            return this;
        }

        public Builder exchangeCodesOperator(SetMembershipOperator exchangeCodesOperator) {
            this.exchangeCodesOperator = exchangeCodesOperator;
            this.changedFields = changedFields.add("ExchangeCodesOperator");
            return this;
        }

        public Builder fileCodes(List<String> fileCodes) {
            this.fileCodes = fileCodes;
            this.changedFields = changedFields.add("FileCodes");
            return this;
        }

        public Builder fileCodesNextLink(String fileCodesNextLink) {
            this.fileCodesNextLink = fileCodesNextLink;
            this.changedFields = changedFields.add("FileCodes");
            return this;
        }

        public Builder fileCodesOperator(SetMembershipOperator fileCodesOperator) {
            this.fileCodesOperator = fileCodesOperator;
            this.changedFields = changedFields.add("FileCodesOperator");
            return this;
        }

        public Builder frequenciesOfUpdate(List<String> frequenciesOfUpdate) {
            this.frequenciesOfUpdate = frequenciesOfUpdate;
            this.changedFields = changedFields.add("FrequenciesOfUpdate");
            return this;
        }

        public Builder frequenciesOfUpdateNextLink(String frequenciesOfUpdateNextLink) {
            this.frequenciesOfUpdateNextLink = frequenciesOfUpdateNextLink;
            this.changedFields = changedFields.add("FrequenciesOfUpdate");
            return this;
        }

        public Builder frequenciesOfUpdateOperator(SetMembershipOperator frequenciesOfUpdateOperator) {
            this.frequenciesOfUpdateOperator = frequenciesOfUpdateOperator;
            this.changedFields = changedFields.add("FrequenciesOfUpdateOperator");
            return this;
        }

        public Builder lotUnits(List<String> lotUnits) {
            this.lotUnits = lotUnits;
            this.changedFields = changedFields.add("LotUnits");
            return this;
        }

        public Builder lotUnitsNextLink(String lotUnitsNextLink) {
            this.lotUnitsNextLink = lotUnitsNextLink;
            this.changedFields = changedFields.add("LotUnits");
            return this;
        }

        public Builder lotUnitsOperator(SetMembershipOperator lotUnitsOperator) {
            this.lotUnitsOperator = lotUnitsOperator;
            this.changedFields = changedFields.add("LotUnitsOperator");
            return this;
        }

        public Builder rcsUnderlyingProducts(List<String> rcsUnderlyingProducts) {
            this.rcsUnderlyingProducts = rcsUnderlyingProducts;
            this.changedFields = changedFields.add("RcsUnderlyingProducts");
            return this;
        }

        public Builder rcsUnderlyingProductsNextLink(String rcsUnderlyingProductsNextLink) {
            this.rcsUnderlyingProductsNextLink = rcsUnderlyingProductsNextLink;
            this.changedFields = changedFields.add("RcsUnderlyingProducts");
            return this;
        }

        public Builder rcsUnderlyingProductsOperator(SetMembershipOperator rcsUnderlyingProductsOperator) {
            this.rcsUnderlyingProductsOperator = rcsUnderlyingProductsOperator;
            this.changedFields = changedFields.add("RcsUnderlyingProductsOperator");
            return this;
        }

        public Builder sourceNames(List<String> sourceNames) {
            this.sourceNames = sourceNames;
            this.changedFields = changedFields.add("SourceNames");
            return this;
        }

        public Builder sourceNamesNextLink(String sourceNamesNextLink) {
            this.sourceNamesNextLink = sourceNamesNextLink;
            this.changedFields = changedFields.add("SourceNames");
            return this;
        }

        public Builder sourceNamesOperator(SetMembershipOperator sourceNamesOperator) {
            this.sourceNamesOperator = sourceNamesOperator;
            this.changedFields = changedFields.add("SourceNamesOperator");
            return this;
        }

        public Builder sourceTypes(List<String> sourceTypes) {
            this.sourceTypes = sourceTypes;
            this.changedFields = changedFields.add("SourceTypes");
            return this;
        }

        public Builder sourceTypesNextLink(String sourceTypesNextLink) {
            this.sourceTypesNextLink = sourceTypesNextLink;
            this.changedFields = changedFields.add("SourceTypes");
            return this;
        }

        public Builder sourceTypesOperator(SetMembershipOperator sourceTypesOperator) {
            this.sourceTypesOperator = sourceTypesOperator;
            this.changedFields = changedFields.add("SourceTypesOperator");
            return this;
        }

        public Builder trClassificationSchemes(List<String> trClassificationSchemes) {
            this.trClassificationSchemes = trClassificationSchemes;
            this.changedFields = changedFields.add("TrClassificationSchemes");
            return this;
        }

        public Builder trClassificationSchemesNextLink(String trClassificationSchemesNextLink) {
            this.trClassificationSchemesNextLink = trClassificationSchemesNextLink;
            this.changedFields = changedFields.add("TrClassificationSchemes");
            return this;
        }

        public Builder trClassificationSchemesOperator(SetMembershipOperator trClassificationSchemesOperator) {
            this.trClassificationSchemesOperator = trClassificationSchemesOperator;
            this.changedFields = changedFields.add("TrClassificationSchemesOperator");
            return this;
        }

        public Builder commoditiesUnderlyingAssets(List<String> commoditiesUnderlyingAssets) {
            this.commoditiesUnderlyingAssets = commoditiesUnderlyingAssets;
            this.changedFields = changedFields.add("CommoditiesUnderlyingAssets");
            return this;
        }

        public Builder commoditiesUnderlyingAssetsNextLink(String commoditiesUnderlyingAssetsNextLink) {
            this.commoditiesUnderlyingAssetsNextLink = commoditiesUnderlyingAssetsNextLink;
            this.changedFields = changedFields.add("CommoditiesUnderlyingAssets");
            return this;
        }

        public Builder commoditiesUnderlyingAssetsOperator(SetMembershipOperator commoditiesUnderlyingAssetsOperator) {
            this.commoditiesUnderlyingAssetsOperator = commoditiesUnderlyingAssetsOperator;
            this.changedFields = changedFields.add("CommoditiesUnderlyingAssetsOperator");
            return this;
        }

        public Builder pdpCodes(List<String> pdpCodes) {
            this.pdpCodes = pdpCodes;
            this.changedFields = changedFields.add("PdpCodes");
            return this;
        }

        public Builder pdpCodesNextLink(String pdpCodesNextLink) {
            this.pdpCodesNextLink = pdpCodesNextLink;
            this.changedFields = changedFields.add("PdpCodes");
            return this;
        }

        public Builder pdpCodesOperator(SetMembershipOperator pdpCodesOperator) {
            this.pdpCodesOperator = pdpCodesOperator;
            this.changedFields = changedFields.add("PdpCodesOperator");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder preferredIdentifierType(IdentifierType preferredIdentifierType) {
            this.preferredIdentifierType = preferredIdentifierType;
            this.changedFields = changedFields.add("PreferredIdentifierType");
            return this;
        }

        public CommoditySearchRequest build() {
            CommoditySearchRequest _x = new CommoditySearchRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest";
            _x.keywordQuery = keywordQuery;
            _x.assetStatus = assetStatus;
            _x.contractMonthAndYear = contractMonthAndYear;
            _x.description = description;
            _x.expirationDate = expirationDate;
            _x.primaryChain = primaryChain;
            _x.assetCategoryCodes = assetCategoryCodes;
            _x.assetCategoryCodesNextLink = assetCategoryCodesNextLink;
            _x.assetCategoryCodesOperator = assetCategoryCodesOperator;
            _x.currencyCodes = currencyCodes;
            _x.currencyCodesNextLink = currencyCodesNextLink;
            _x.currencyCodesOperator = currencyCodesOperator;
            _x.exchangeCodes = exchangeCodes;
            _x.exchangeCodesNextLink = exchangeCodesNextLink;
            _x.exchangeCodesOperator = exchangeCodesOperator;
            _x.fileCodes = fileCodes;
            _x.fileCodesNextLink = fileCodesNextLink;
            _x.fileCodesOperator = fileCodesOperator;
            _x.frequenciesOfUpdate = frequenciesOfUpdate;
            _x.frequenciesOfUpdateNextLink = frequenciesOfUpdateNextLink;
            _x.frequenciesOfUpdateOperator = frequenciesOfUpdateOperator;
            _x.lotUnits = lotUnits;
            _x.lotUnitsNextLink = lotUnitsNextLink;
            _x.lotUnitsOperator = lotUnitsOperator;
            _x.rcsUnderlyingProducts = rcsUnderlyingProducts;
            _x.rcsUnderlyingProductsNextLink = rcsUnderlyingProductsNextLink;
            _x.rcsUnderlyingProductsOperator = rcsUnderlyingProductsOperator;
            _x.sourceNames = sourceNames;
            _x.sourceNamesNextLink = sourceNamesNextLink;
            _x.sourceNamesOperator = sourceNamesOperator;
            _x.sourceTypes = sourceTypes;
            _x.sourceTypesNextLink = sourceTypesNextLink;
            _x.sourceTypesOperator = sourceTypesOperator;
            _x.trClassificationSchemes = trClassificationSchemes;
            _x.trClassificationSchemesNextLink = trClassificationSchemesNextLink;
            _x.trClassificationSchemesOperator = trClassificationSchemesOperator;
            _x.commoditiesUnderlyingAssets = commoditiesUnderlyingAssets;
            _x.commoditiesUnderlyingAssetsNextLink = commoditiesUnderlyingAssetsNextLink;
            _x.commoditiesUnderlyingAssetsOperator = commoditiesUnderlyingAssetsOperator;
            _x.pdpCodes = pdpCodes;
            _x.pdpCodesNextLink = pdpCodesNextLink;
            _x.pdpCodesOperator = pdpCodesOperator;
            _x.identifierType = identifierType;
            _x.identifier = identifier;
            _x.preferredIdentifierType = preferredIdentifierType;
            return _x;
        }
    }

    private CommoditySearchRequest _copy() {
        CommoditySearchRequest _x = new CommoditySearchRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.keywordQuery = keywordQuery;
        _x.assetStatus = assetStatus;
        _x.contractMonthAndYear = contractMonthAndYear;
        _x.description = description;
        _x.expirationDate = expirationDate;
        _x.primaryChain = primaryChain;
        _x.assetCategoryCodes = assetCategoryCodes;
        _x.assetCategoryCodesOperator = assetCategoryCodesOperator;
        _x.currencyCodes = currencyCodes;
        _x.currencyCodesOperator = currencyCodesOperator;
        _x.exchangeCodes = exchangeCodes;
        _x.exchangeCodesOperator = exchangeCodesOperator;
        _x.fileCodes = fileCodes;
        _x.fileCodesOperator = fileCodesOperator;
        _x.frequenciesOfUpdate = frequenciesOfUpdate;
        _x.frequenciesOfUpdateOperator = frequenciesOfUpdateOperator;
        _x.lotUnits = lotUnits;
        _x.lotUnitsOperator = lotUnitsOperator;
        _x.rcsUnderlyingProducts = rcsUnderlyingProducts;
        _x.rcsUnderlyingProductsOperator = rcsUnderlyingProductsOperator;
        _x.sourceNames = sourceNames;
        _x.sourceNamesOperator = sourceNamesOperator;
        _x.sourceTypes = sourceTypes;
        _x.sourceTypesOperator = sourceTypesOperator;
        _x.trClassificationSchemes = trClassificationSchemes;
        _x.trClassificationSchemesOperator = trClassificationSchemesOperator;
        _x.commoditiesUnderlyingAssets = commoditiesUnderlyingAssets;
        _x.commoditiesUnderlyingAssetsOperator = commoditiesUnderlyingAssetsOperator;
        _x.pdpCodes = pdpCodes;
        _x.pdpCodesOperator = pdpCodesOperator;
        _x.identifierType = identifierType;
        _x.identifier = identifier;
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CommoditySearchRequest[");
        b.append("KeywordQuery=");
        b.append(this.keywordQuery);
        b.append(", ");
        b.append("AssetStatus=");
        b.append(this.assetStatus);
        b.append(", ");
        b.append("ContractMonthAndYear=");
        b.append(this.contractMonthAndYear);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("ExpirationDate=");
        b.append(this.expirationDate);
        b.append(", ");
        b.append("PrimaryChain=");
        b.append(this.primaryChain);
        b.append(", ");
        b.append("AssetCategoryCodes=");
        b.append(this.assetCategoryCodes);
        b.append(", ");
        b.append("AssetCategoryCodesOperator=");
        b.append(this.assetCategoryCodesOperator);
        b.append(", ");
        b.append("CurrencyCodes=");
        b.append(this.currencyCodes);
        b.append(", ");
        b.append("CurrencyCodesOperator=");
        b.append(this.currencyCodesOperator);
        b.append(", ");
        b.append("ExchangeCodes=");
        b.append(this.exchangeCodes);
        b.append(", ");
        b.append("ExchangeCodesOperator=");
        b.append(this.exchangeCodesOperator);
        b.append(", ");
        b.append("FileCodes=");
        b.append(this.fileCodes);
        b.append(", ");
        b.append("FileCodesOperator=");
        b.append(this.fileCodesOperator);
        b.append(", ");
        b.append("FrequenciesOfUpdate=");
        b.append(this.frequenciesOfUpdate);
        b.append(", ");
        b.append("FrequenciesOfUpdateOperator=");
        b.append(this.frequenciesOfUpdateOperator);
        b.append(", ");
        b.append("LotUnits=");
        b.append(this.lotUnits);
        b.append(", ");
        b.append("LotUnitsOperator=");
        b.append(this.lotUnitsOperator);
        b.append(", ");
        b.append("RcsUnderlyingProducts=");
        b.append(this.rcsUnderlyingProducts);
        b.append(", ");
        b.append("RcsUnderlyingProductsOperator=");
        b.append(this.rcsUnderlyingProductsOperator);
        b.append(", ");
        b.append("SourceNames=");
        b.append(this.sourceNames);
        b.append(", ");
        b.append("SourceNamesOperator=");
        b.append(this.sourceNamesOperator);
        b.append(", ");
        b.append("SourceTypes=");
        b.append(this.sourceTypes);
        b.append(", ");
        b.append("SourceTypesOperator=");
        b.append(this.sourceTypesOperator);
        b.append(", ");
        b.append("TrClassificationSchemes=");
        b.append(this.trClassificationSchemes);
        b.append(", ");
        b.append("TrClassificationSchemesOperator=");
        b.append(this.trClassificationSchemesOperator);
        b.append(", ");
        b.append("CommoditiesUnderlyingAssets=");
        b.append(this.commoditiesUnderlyingAssets);
        b.append(", ");
        b.append("CommoditiesUnderlyingAssetsOperator=");
        b.append(this.commoditiesUnderlyingAssetsOperator);
        b.append(", ");
        b.append("PdpCodes=");
        b.append(this.pdpCodes);
        b.append(", ");
        b.append("PdpCodesOperator=");
        b.append(this.pdpCodesOperator);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("PreferredIdentifierType=");
        b.append(this.preferredIdentifierType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
