package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.content.commodity.enums.CommodityStatus;
import thomsonreuters.dss.api.content.complex.ValidatedInstrument;
import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.enums.InstrumentType;
import thomsonreuters.dss.api.content.enums.ValidityStatus;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "LongDescription", 
    "AssetStatus", 
    "CurrencyCode", 
    "CurrencyCodeDescription", 
    "ExchangeCode", 
    "ExchangeCodeDescription", 
    "FileCode", 
    "FileCodeDescription", 
    "RcsUnderlyingProduct", 
    "TrClassificationScheme", 
    "ContractMonthAndYear", 
    "PrimaryChainOrTile", 
    "AssetCategory", 
    "FrequencyOfUpdate", 
    "LotUnits", 
    "SourceName", 
    "SourceType", 
    "CommoditiesUnderlyingAsset", 
    "ExpirationDate"})
public class CommoditySearchResult extends ValidatedInstrument implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("LongDescription")
    protected String longDescription;

    @JsonProperty("AssetStatus")
    protected CommodityStatus assetStatus;

    @JsonProperty("CurrencyCode")
    protected String currencyCode;

    @JsonProperty("CurrencyCodeDescription")
    protected String currencyCodeDescription;

    @JsonProperty("ExchangeCode")
    protected String exchangeCode;

    @JsonProperty("ExchangeCodeDescription")
    protected String exchangeCodeDescription;

    @JsonProperty("FileCode")
    protected String fileCode;

    @JsonProperty("FileCodeDescription")
    protected String fileCodeDescription;

    @JsonProperty("RcsUnderlyingProduct")
    protected String rcsUnderlyingProduct;

    @JsonProperty("TrClassificationScheme")
    protected String trClassificationScheme;

    @JsonProperty("ContractMonthAndYear")
    protected String contractMonthAndYear;

    @JsonProperty("PrimaryChainOrTile")
    protected String primaryChainOrTile;

    @JsonProperty("AssetCategory")
    protected String assetCategory;

    @JsonProperty("FrequencyOfUpdate")
    protected String frequencyOfUpdate;

    @JsonProperty("LotUnits")
    protected String lotUnits;

    @JsonProperty("SourceName")
    protected String sourceName;

    @JsonProperty("SourceType")
    protected String sourceType;

    @JsonProperty("CommoditiesUnderlyingAsset")
    protected String commoditiesUnderlyingAsset;

    @JsonProperty("ExpirationDate")
    protected OffsetDateTime expirationDate;

    protected CommoditySearchResult() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.CommoditySearchResult";
    }

    @Property(name="LongDescription")
    @JsonIgnore
    public Optional<String> getLongDescription() {
        return Optional.ofNullable(longDescription);
    }

    public CommoditySearchResult withLongDescription(String longDescription) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.longDescription = longDescription;
        return _x;
    }

    @Property(name="AssetStatus")
    @JsonIgnore
    public Optional<CommodityStatus> getAssetStatus() {
        return Optional.ofNullable(assetStatus);
    }

    public CommoditySearchResult withAssetStatus(CommodityStatus assetStatus) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.assetStatus = assetStatus;
        return _x;
    }

    @Property(name="CurrencyCode")
    @JsonIgnore
    public Optional<String> getCurrencyCode() {
        return Optional.ofNullable(currencyCode);
    }

    public CommoditySearchResult withCurrencyCode(String currencyCode) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.currencyCode = currencyCode;
        return _x;
    }

    @Property(name="CurrencyCodeDescription")
    @JsonIgnore
    public Optional<String> getCurrencyCodeDescription() {
        return Optional.ofNullable(currencyCodeDescription);
    }

    public CommoditySearchResult withCurrencyCodeDescription(String currencyCodeDescription) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.currencyCodeDescription = currencyCodeDescription;
        return _x;
    }

    @Property(name="ExchangeCode")
    @JsonIgnore
    public Optional<String> getExchangeCode() {
        return Optional.ofNullable(exchangeCode);
    }

    public CommoditySearchResult withExchangeCode(String exchangeCode) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.exchangeCode = exchangeCode;
        return _x;
    }

    @Property(name="ExchangeCodeDescription")
    @JsonIgnore
    public Optional<String> getExchangeCodeDescription() {
        return Optional.ofNullable(exchangeCodeDescription);
    }

    public CommoditySearchResult withExchangeCodeDescription(String exchangeCodeDescription) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.exchangeCodeDescription = exchangeCodeDescription;
        return _x;
    }

    @Property(name="FileCode")
    @JsonIgnore
    public Optional<String> getFileCode() {
        return Optional.ofNullable(fileCode);
    }

    public CommoditySearchResult withFileCode(String fileCode) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.fileCode = fileCode;
        return _x;
    }

    @Property(name="FileCodeDescription")
    @JsonIgnore
    public Optional<String> getFileCodeDescription() {
        return Optional.ofNullable(fileCodeDescription);
    }

    public CommoditySearchResult withFileCodeDescription(String fileCodeDescription) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.fileCodeDescription = fileCodeDescription;
        return _x;
    }

    @Property(name="RcsUnderlyingProduct")
    @JsonIgnore
    public Optional<String> getRcsUnderlyingProduct() {
        return Optional.ofNullable(rcsUnderlyingProduct);
    }

    public CommoditySearchResult withRcsUnderlyingProduct(String rcsUnderlyingProduct) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.rcsUnderlyingProduct = rcsUnderlyingProduct;
        return _x;
    }

    @Property(name="TrClassificationScheme")
    @JsonIgnore
    public Optional<String> getTrClassificationScheme() {
        return Optional.ofNullable(trClassificationScheme);
    }

    public CommoditySearchResult withTrClassificationScheme(String trClassificationScheme) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.trClassificationScheme = trClassificationScheme;
        return _x;
    }

    @Property(name="ContractMonthAndYear")
    @JsonIgnore
    public Optional<String> getContractMonthAndYear() {
        return Optional.ofNullable(contractMonthAndYear);
    }

    public CommoditySearchResult withContractMonthAndYear(String contractMonthAndYear) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.contractMonthAndYear = contractMonthAndYear;
        return _x;
    }

    @Property(name="PrimaryChainOrTile")
    @JsonIgnore
    public Optional<String> getPrimaryChainOrTile() {
        return Optional.ofNullable(primaryChainOrTile);
    }

    public CommoditySearchResult withPrimaryChainOrTile(String primaryChainOrTile) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.primaryChainOrTile = primaryChainOrTile;
        return _x;
    }

    @Property(name="AssetCategory")
    @JsonIgnore
    public Optional<String> getAssetCategory() {
        return Optional.ofNullable(assetCategory);
    }

    public CommoditySearchResult withAssetCategory(String assetCategory) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.assetCategory = assetCategory;
        return _x;
    }

    @Property(name="FrequencyOfUpdate")
    @JsonIgnore
    public Optional<String> getFrequencyOfUpdate() {
        return Optional.ofNullable(frequencyOfUpdate);
    }

    public CommoditySearchResult withFrequencyOfUpdate(String frequencyOfUpdate) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.frequencyOfUpdate = frequencyOfUpdate;
        return _x;
    }

    @Property(name="LotUnits")
    @JsonIgnore
    public Optional<String> getLotUnits() {
        return Optional.ofNullable(lotUnits);
    }

    public CommoditySearchResult withLotUnits(String lotUnits) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.lotUnits = lotUnits;
        return _x;
    }

    @Property(name="SourceName")
    @JsonIgnore
    public Optional<String> getSourceName() {
        return Optional.ofNullable(sourceName);
    }

    public CommoditySearchResult withSourceName(String sourceName) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.sourceName = sourceName;
        return _x;
    }

    @Property(name="SourceType")
    @JsonIgnore
    public Optional<String> getSourceType() {
        return Optional.ofNullable(sourceType);
    }

    public CommoditySearchResult withSourceType(String sourceType) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.sourceType = sourceType;
        return _x;
    }

    @Property(name="CommoditiesUnderlyingAsset")
    @JsonIgnore
    public Optional<String> getCommoditiesUnderlyingAsset() {
        return Optional.ofNullable(commoditiesUnderlyingAsset);
    }

    public CommoditySearchResult withCommoditiesUnderlyingAsset(String commoditiesUnderlyingAsset) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.commoditiesUnderlyingAsset = commoditiesUnderlyingAsset;
        return _x;
    }

    @Property(name="ExpirationDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDate() {
        return Optional.ofNullable(expirationDate);
    }

    public CommoditySearchResult withExpirationDate(OffsetDateTime expirationDate) {
        CommoditySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.CommoditySearchResult");
        _x.expirationDate = expirationDate;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCommoditySearchResult() {
        return new Builder();
    }

    public static final class Builder {
        private String key;
        private String description;
        private InstrumentType instrumentType;
        private ValidityStatus status;
        private String source;
        private String identifier;
        private IdentifierType identifierType;
        private String userDefinedIdentifier;
        private String userDefinedIdentifier2;
        private String userDefinedIdentifier3;
        private String userDefinedIdentifier4;
        private String userDefinedIdentifier5;
        private String userDefinedIdentifier6;
        private String longDescription;
        private CommodityStatus assetStatus;
        private String currencyCode;
        private String currencyCodeDescription;
        private String exchangeCode;
        private String exchangeCodeDescription;
        private String fileCode;
        private String fileCodeDescription;
        private String rcsUnderlyingProduct;
        private String trClassificationScheme;
        private String contractMonthAndYear;
        private String primaryChainOrTile;
        private String assetCategory;
        private String frequencyOfUpdate;
        private String lotUnits;
        private String sourceName;
        private String sourceType;
        private String commoditiesUnderlyingAsset;
        private OffsetDateTime expirationDate;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder key(String key) {
            this.key = key;
            this.changedFields = changedFields.add("Key");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder instrumentType(InstrumentType instrumentType) {
            this.instrumentType = instrumentType;
            this.changedFields = changedFields.add("InstrumentType");
            return this;
        }

        public Builder status(ValidityStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("Status");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.changedFields = changedFields.add("Source");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder userDefinedIdentifier(String userDefinedIdentifier) {
            this.userDefinedIdentifier = userDefinedIdentifier;
            this.changedFields = changedFields.add("UserDefinedIdentifier");
            return this;
        }

        public Builder userDefinedIdentifier2(String userDefinedIdentifier2) {
            this.userDefinedIdentifier2 = userDefinedIdentifier2;
            this.changedFields = changedFields.add("UserDefinedIdentifier2");
            return this;
        }

        public Builder userDefinedIdentifier3(String userDefinedIdentifier3) {
            this.userDefinedIdentifier3 = userDefinedIdentifier3;
            this.changedFields = changedFields.add("UserDefinedIdentifier3");
            return this;
        }

        public Builder userDefinedIdentifier4(String userDefinedIdentifier4) {
            this.userDefinedIdentifier4 = userDefinedIdentifier4;
            this.changedFields = changedFields.add("UserDefinedIdentifier4");
            return this;
        }

        public Builder userDefinedIdentifier5(String userDefinedIdentifier5) {
            this.userDefinedIdentifier5 = userDefinedIdentifier5;
            this.changedFields = changedFields.add("UserDefinedIdentifier5");
            return this;
        }

        public Builder userDefinedIdentifier6(String userDefinedIdentifier6) {
            this.userDefinedIdentifier6 = userDefinedIdentifier6;
            this.changedFields = changedFields.add("UserDefinedIdentifier6");
            return this;
        }

        public Builder longDescription(String longDescription) {
            this.longDescription = longDescription;
            this.changedFields = changedFields.add("LongDescription");
            return this;
        }

        public Builder assetStatus(CommodityStatus assetStatus) {
            this.assetStatus = assetStatus;
            this.changedFields = changedFields.add("AssetStatus");
            return this;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            this.changedFields = changedFields.add("CurrencyCode");
            return this;
        }

        public Builder currencyCodeDescription(String currencyCodeDescription) {
            this.currencyCodeDescription = currencyCodeDescription;
            this.changedFields = changedFields.add("CurrencyCodeDescription");
            return this;
        }

        public Builder exchangeCode(String exchangeCode) {
            this.exchangeCode = exchangeCode;
            this.changedFields = changedFields.add("ExchangeCode");
            return this;
        }

        public Builder exchangeCodeDescription(String exchangeCodeDescription) {
            this.exchangeCodeDescription = exchangeCodeDescription;
            this.changedFields = changedFields.add("ExchangeCodeDescription");
            return this;
        }

        public Builder fileCode(String fileCode) {
            this.fileCode = fileCode;
            this.changedFields = changedFields.add("FileCode");
            return this;
        }

        public Builder fileCodeDescription(String fileCodeDescription) {
            this.fileCodeDescription = fileCodeDescription;
            this.changedFields = changedFields.add("FileCodeDescription");
            return this;
        }

        public Builder rcsUnderlyingProduct(String rcsUnderlyingProduct) {
            this.rcsUnderlyingProduct = rcsUnderlyingProduct;
            this.changedFields = changedFields.add("RcsUnderlyingProduct");
            return this;
        }

        public Builder trClassificationScheme(String trClassificationScheme) {
            this.trClassificationScheme = trClassificationScheme;
            this.changedFields = changedFields.add("TrClassificationScheme");
            return this;
        }

        public Builder contractMonthAndYear(String contractMonthAndYear) {
            this.contractMonthAndYear = contractMonthAndYear;
            this.changedFields = changedFields.add("ContractMonthAndYear");
            return this;
        }

        public Builder primaryChainOrTile(String primaryChainOrTile) {
            this.primaryChainOrTile = primaryChainOrTile;
            this.changedFields = changedFields.add("PrimaryChainOrTile");
            return this;
        }

        public Builder assetCategory(String assetCategory) {
            this.assetCategory = assetCategory;
            this.changedFields = changedFields.add("AssetCategory");
            return this;
        }

        public Builder frequencyOfUpdate(String frequencyOfUpdate) {
            this.frequencyOfUpdate = frequencyOfUpdate;
            this.changedFields = changedFields.add("FrequencyOfUpdate");
            return this;
        }

        public Builder lotUnits(String lotUnits) {
            this.lotUnits = lotUnits;
            this.changedFields = changedFields.add("LotUnits");
            return this;
        }

        public Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            this.changedFields = changedFields.add("SourceName");
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            this.changedFields = changedFields.add("SourceType");
            return this;
        }

        public Builder commoditiesUnderlyingAsset(String commoditiesUnderlyingAsset) {
            this.commoditiesUnderlyingAsset = commoditiesUnderlyingAsset;
            this.changedFields = changedFields.add("CommoditiesUnderlyingAsset");
            return this;
        }

        public Builder expirationDate(OffsetDateTime expirationDate) {
            this.expirationDate = expirationDate;
            this.changedFields = changedFields.add("ExpirationDate");
            return this;
        }

        public CommoditySearchResult build() {
            CommoditySearchResult _x = new CommoditySearchResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.CommoditySearchResult";
            _x.key = key;
            _x.description = description;
            _x.instrumentType = instrumentType;
            _x.status = status;
            _x.source = source;
            _x.identifier = identifier;
            _x.identifierType = identifierType;
            _x.userDefinedIdentifier = userDefinedIdentifier;
            _x.userDefinedIdentifier2 = userDefinedIdentifier2;
            _x.userDefinedIdentifier3 = userDefinedIdentifier3;
            _x.userDefinedIdentifier4 = userDefinedIdentifier4;
            _x.userDefinedIdentifier5 = userDefinedIdentifier5;
            _x.userDefinedIdentifier6 = userDefinedIdentifier6;
            _x.longDescription = longDescription;
            _x.assetStatus = assetStatus;
            _x.currencyCode = currencyCode;
            _x.currencyCodeDescription = currencyCodeDescription;
            _x.exchangeCode = exchangeCode;
            _x.exchangeCodeDescription = exchangeCodeDescription;
            _x.fileCode = fileCode;
            _x.fileCodeDescription = fileCodeDescription;
            _x.rcsUnderlyingProduct = rcsUnderlyingProduct;
            _x.trClassificationScheme = trClassificationScheme;
            _x.contractMonthAndYear = contractMonthAndYear;
            _x.primaryChainOrTile = primaryChainOrTile;
            _x.assetCategory = assetCategory;
            _x.frequencyOfUpdate = frequencyOfUpdate;
            _x.lotUnits = lotUnits;
            _x.sourceName = sourceName;
            _x.sourceType = sourceType;
            _x.commoditiesUnderlyingAsset = commoditiesUnderlyingAsset;
            _x.expirationDate = expirationDate;
            return _x;
        }
    }

    private CommoditySearchResult _copy() {
        CommoditySearchResult _x = new CommoditySearchResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.key = key;
        _x.description = description;
        _x.instrumentType = instrumentType;
        _x.status = status;
        _x.source = source;
        _x.identifier = identifier;
        _x.identifierType = identifierType;
        _x.userDefinedIdentifier = userDefinedIdentifier;
        _x.userDefinedIdentifier2 = userDefinedIdentifier2;
        _x.userDefinedIdentifier3 = userDefinedIdentifier3;
        _x.userDefinedIdentifier4 = userDefinedIdentifier4;
        _x.userDefinedIdentifier5 = userDefinedIdentifier5;
        _x.userDefinedIdentifier6 = userDefinedIdentifier6;
        _x.longDescription = longDescription;
        _x.assetStatus = assetStatus;
        _x.currencyCode = currencyCode;
        _x.currencyCodeDescription = currencyCodeDescription;
        _x.exchangeCode = exchangeCode;
        _x.exchangeCodeDescription = exchangeCodeDescription;
        _x.fileCode = fileCode;
        _x.fileCodeDescription = fileCodeDescription;
        _x.rcsUnderlyingProduct = rcsUnderlyingProduct;
        _x.trClassificationScheme = trClassificationScheme;
        _x.contractMonthAndYear = contractMonthAndYear;
        _x.primaryChainOrTile = primaryChainOrTile;
        _x.assetCategory = assetCategory;
        _x.frequencyOfUpdate = frequencyOfUpdate;
        _x.lotUnits = lotUnits;
        _x.sourceName = sourceName;
        _x.sourceType = sourceType;
        _x.commoditiesUnderlyingAsset = commoditiesUnderlyingAsset;
        _x.expirationDate = expirationDate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CommoditySearchResult[");
        b.append("Key=");
        b.append(this.key);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("InstrumentType=");
        b.append(this.instrumentType);
        b.append(", ");
        b.append("Status=");
        b.append(this.status);
        b.append(", ");
        b.append("Source=");
        b.append(this.source);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("UserDefinedIdentifier=");
        b.append(this.userDefinedIdentifier);
        b.append(", ");
        b.append("UserDefinedIdentifier2=");
        b.append(this.userDefinedIdentifier2);
        b.append(", ");
        b.append("UserDefinedIdentifier3=");
        b.append(this.userDefinedIdentifier3);
        b.append(", ");
        b.append("UserDefinedIdentifier4=");
        b.append(this.userDefinedIdentifier4);
        b.append(", ");
        b.append("UserDefinedIdentifier5=");
        b.append(this.userDefinedIdentifier5);
        b.append(", ");
        b.append("UserDefinedIdentifier6=");
        b.append(this.userDefinedIdentifier6);
        b.append(", ");
        b.append("LongDescription=");
        b.append(this.longDescription);
        b.append(", ");
        b.append("AssetStatus=");
        b.append(this.assetStatus);
        b.append(", ");
        b.append("CurrencyCode=");
        b.append(this.currencyCode);
        b.append(", ");
        b.append("CurrencyCodeDescription=");
        b.append(this.currencyCodeDescription);
        b.append(", ");
        b.append("ExchangeCode=");
        b.append(this.exchangeCode);
        b.append(", ");
        b.append("ExchangeCodeDescription=");
        b.append(this.exchangeCodeDescription);
        b.append(", ");
        b.append("FileCode=");
        b.append(this.fileCode);
        b.append(", ");
        b.append("FileCodeDescription=");
        b.append(this.fileCodeDescription);
        b.append(", ");
        b.append("RcsUnderlyingProduct=");
        b.append(this.rcsUnderlyingProduct);
        b.append(", ");
        b.append("TrClassificationScheme=");
        b.append(this.trClassificationScheme);
        b.append(", ");
        b.append("ContractMonthAndYear=");
        b.append(this.contractMonthAndYear);
        b.append(", ");
        b.append("PrimaryChainOrTile=");
        b.append(this.primaryChainOrTile);
        b.append(", ");
        b.append("AssetCategory=");
        b.append(this.assetCategory);
        b.append(", ");
        b.append("FrequencyOfUpdate=");
        b.append(this.frequencyOfUpdate);
        b.append(", ");
        b.append("LotUnits=");
        b.append(this.lotUnits);
        b.append(", ");
        b.append("SourceName=");
        b.append(this.sourceName);
        b.append(", ");
        b.append("SourceType=");
        b.append(this.sourceType);
        b.append(", ");
        b.append("CommoditiesUnderlyingAsset=");
        b.append(this.commoditiesUnderlyingAsset);
        b.append(", ");
        b.append("ExpirationDate=");
        b.append(this.expirationDate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
