package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Start", 
    "End"})
public class DateTimeRange implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Start")
    protected OffsetDateTime start;

    @JsonProperty("End")
    protected OffsetDateTime end;

    protected DateTimeRange() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.DateTimeRange";
    }

    @Property(name="Start")
    @JsonIgnore
    public Optional<OffsetDateTime> getStart() {
        return Optional.ofNullable(start);
    }

    public DateTimeRange withStart(OffsetDateTime start) {
        DateTimeRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.DateTimeRange");
        _x.start = start;
        return _x;
    }

    @Property(name="End")
    @JsonIgnore
    public Optional<OffsetDateTime> getEnd() {
        return Optional.ofNullable(end);
    }

    public DateTimeRange withEnd(OffsetDateTime end) {
        DateTimeRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.DateTimeRange");
        _x.end = end;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime start;
        private OffsetDateTime end;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder start(OffsetDateTime start) {
            this.start = start;
            this.changedFields = changedFields.add("Start");
            return this;
        }

        public Builder end(OffsetDateTime end) {
            this.end = end;
            this.changedFields = changedFields.add("End");
            return this;
        }

        public DateTimeRange build() {
            DateTimeRange _x = new DateTimeRange();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.DateTimeRange";
            _x.start = start;
            _x.end = end;
            return _x;
        }
    }

    private DateTimeRange _copy() {
        DateTimeRange _x = new DateTimeRange();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.start = start;
        _x.end = end;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DateTimeRange[");
        b.append("Start=");
        b.append(this.start);
        b.append(", ");
        b.append("End=");
        b.append(this.end);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
