package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.math.BigDecimal;
import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Value", 
    "Min", 
    "Max"})
public class DecimalValueRange implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Value")
    protected BigDecimal value;

    @JsonProperty("Min")
    protected BigDecimal min;

    @JsonProperty("Max")
    protected BigDecimal max;

    protected DecimalValueRange() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.DecimalValueRange";
    }

    @Property(name="Value")
    @JsonIgnore
    public Optional<BigDecimal> getValue() {
        return Optional.ofNullable(value);
    }

    public DecimalValueRange withValue(BigDecimal value) {
        DecimalValueRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.DecimalValueRange");
        _x.value = value;
        return _x;
    }

    @Property(name="Min")
    @JsonIgnore
    public Optional<BigDecimal> getMin() {
        return Optional.ofNullable(min);
    }

    public DecimalValueRange withMin(BigDecimal min) {
        DecimalValueRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.DecimalValueRange");
        _x.min = min;
        return _x;
    }

    @Property(name="Max")
    @JsonIgnore
    public Optional<BigDecimal> getMax() {
        return Optional.ofNullable(max);
    }

    public DecimalValueRange withMax(BigDecimal max) {
        DecimalValueRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.DecimalValueRange");
        _x.max = max;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BigDecimal value;
        private BigDecimal min;
        private BigDecimal max;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder value(BigDecimal value) {
            this.value = value;
            this.changedFields = changedFields.add("Value");
            return this;
        }

        public Builder min(BigDecimal min) {
            this.min = min;
            this.changedFields = changedFields.add("Min");
            return this;
        }

        public Builder max(BigDecimal max) {
            this.max = max;
            this.changedFields = changedFields.add("Max");
            return this;
        }

        public DecimalValueRange build() {
            DecimalValueRange _x = new DecimalValueRange();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.DecimalValueRange";
            _x.value = value;
            _x.min = min;
            _x.max = max;
            return _x;
        }
    }

    private DecimalValueRange _copy() {
        DecimalValueRange _x = new DecimalValueRange();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.value = value;
        _x.min = min;
        _x.max = max;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DecimalValueRange[");
        b.append("Value=");
        b.append(this.value);
        b.append(", ");
        b.append("Min=");
        b.append(this.min);
        b.append(", ");
        b.append("Max=");
        b.append(this.max);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
