package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Name", 
    "OfficialNameOnly", 
    "DomicileCodes", 
    "CountryOfIncorporationCodes", 
    "TrBusinessClassificationCodes", 
    "VerifiedOnly", 
    "RegulatedOnly", 
    "IssuersOnly", 
    "ActiveOnly", 
    "IdentifierType", 
    "Identifier", 
    "PreferredIdentifierType"})
public class EntitySearchRequest implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("OfficialNameOnly")
    protected Boolean officialNameOnly;

    @JsonProperty("DomicileCodes")
    protected List<String> domicileCodes;

    @JsonProperty("DomicileCodes@nextLink")
    protected String domicileCodesNextLink;

    @JsonProperty("CountryOfIncorporationCodes")
    protected List<String> countryOfIncorporationCodes;

    @JsonProperty("CountryOfIncorporationCodes@nextLink")
    protected String countryOfIncorporationCodesNextLink;

    @JsonProperty("TrBusinessClassificationCodes")
    protected List<String> trBusinessClassificationCodes;

    @JsonProperty("TrBusinessClassificationCodes@nextLink")
    protected String trBusinessClassificationCodesNextLink;

    @JsonProperty("VerifiedOnly")
    protected Boolean verifiedOnly;

    @JsonProperty("RegulatedOnly")
    protected Boolean regulatedOnly;

    @JsonProperty("IssuersOnly")
    protected Boolean issuersOnly;

    @JsonProperty("ActiveOnly")
    protected Boolean activeOnly;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("PreferredIdentifierType")
    protected IdentifierType preferredIdentifierType;

    protected EntitySearchRequest() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.EntitySearchRequest";
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public EntitySearchRequest withName(String name) {
        EntitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EntitySearchRequest");
        _x.name = name;
        return _x;
    }

    @Property(name="OfficialNameOnly")
    @JsonIgnore
    public Optional<Boolean> getOfficialNameOnly() {
        return Optional.ofNullable(officialNameOnly);
    }

    public EntitySearchRequest withOfficialNameOnly(Boolean officialNameOnly) {
        EntitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EntitySearchRequest");
        _x.officialNameOnly = officialNameOnly;
        return _x;
    }

    @Property(name="DomicileCodes")
    @JsonIgnore
    public CollectionPage<String> getDomicileCodes() {
        return new CollectionPage<String>(contextPath, String.class, domicileCodes, Optional.ofNullable(domicileCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="CountryOfIncorporationCodes")
    @JsonIgnore
    public CollectionPage<String> getCountryOfIncorporationCodes() {
        return new CollectionPage<String>(contextPath, String.class, countryOfIncorporationCodes, Optional.ofNullable(countryOfIncorporationCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="TrBusinessClassificationCodes")
    @JsonIgnore
    public CollectionPage<String> getTrBusinessClassificationCodes() {
        return new CollectionPage<String>(contextPath, String.class, trBusinessClassificationCodes, Optional.ofNullable(trBusinessClassificationCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="VerifiedOnly")
    @JsonIgnore
    public Optional<Boolean> getVerifiedOnly() {
        return Optional.ofNullable(verifiedOnly);
    }

    public EntitySearchRequest withVerifiedOnly(Boolean verifiedOnly) {
        EntitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EntitySearchRequest");
        _x.verifiedOnly = verifiedOnly;
        return _x;
    }

    @Property(name="RegulatedOnly")
    @JsonIgnore
    public Optional<Boolean> getRegulatedOnly() {
        return Optional.ofNullable(regulatedOnly);
    }

    public EntitySearchRequest withRegulatedOnly(Boolean regulatedOnly) {
        EntitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EntitySearchRequest");
        _x.regulatedOnly = regulatedOnly;
        return _x;
    }

    @Property(name="IssuersOnly")
    @JsonIgnore
    public Optional<Boolean> getIssuersOnly() {
        return Optional.ofNullable(issuersOnly);
    }

    public EntitySearchRequest withIssuersOnly(Boolean issuersOnly) {
        EntitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EntitySearchRequest");
        _x.issuersOnly = issuersOnly;
        return _x;
    }

    @Property(name="ActiveOnly")
    @JsonIgnore
    public Optional<Boolean> getActiveOnly() {
        return Optional.ofNullable(activeOnly);
    }

    public EntitySearchRequest withActiveOnly(Boolean activeOnly) {
        EntitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EntitySearchRequest");
        _x.activeOnly = activeOnly;
        return _x;
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public EntitySearchRequest withIdentifierType(IdentifierType identifierType) {
        EntitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EntitySearchRequest");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public EntitySearchRequest withIdentifier(String identifier) {
        EntitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EntitySearchRequest");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="PreferredIdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getPreferredIdentifierType() {
        return Optional.ofNullable(preferredIdentifierType);
    }

    public EntitySearchRequest withPreferredIdentifierType(IdentifierType preferredIdentifierType) {
        EntitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EntitySearchRequest");
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private Boolean officialNameOnly;
        private List<String> domicileCodes;
        private String domicileCodesNextLink;
        private List<String> countryOfIncorporationCodes;
        private String countryOfIncorporationCodesNextLink;
        private List<String> trBusinessClassificationCodes;
        private String trBusinessClassificationCodesNextLink;
        private Boolean verifiedOnly;
        private Boolean regulatedOnly;
        private Boolean issuersOnly;
        private Boolean activeOnly;
        private IdentifierType identifierType;
        private String identifier;
        private IdentifierType preferredIdentifierType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder officialNameOnly(Boolean officialNameOnly) {
            this.officialNameOnly = officialNameOnly;
            this.changedFields = changedFields.add("OfficialNameOnly");
            return this;
        }

        public Builder domicileCodes(List<String> domicileCodes) {
            this.domicileCodes = domicileCodes;
            this.changedFields = changedFields.add("DomicileCodes");
            return this;
        }

        public Builder domicileCodesNextLink(String domicileCodesNextLink) {
            this.domicileCodesNextLink = domicileCodesNextLink;
            this.changedFields = changedFields.add("DomicileCodes");
            return this;
        }

        public Builder countryOfIncorporationCodes(List<String> countryOfIncorporationCodes) {
            this.countryOfIncorporationCodes = countryOfIncorporationCodes;
            this.changedFields = changedFields.add("CountryOfIncorporationCodes");
            return this;
        }

        public Builder countryOfIncorporationCodesNextLink(String countryOfIncorporationCodesNextLink) {
            this.countryOfIncorporationCodesNextLink = countryOfIncorporationCodesNextLink;
            this.changedFields = changedFields.add("CountryOfIncorporationCodes");
            return this;
        }

        public Builder trBusinessClassificationCodes(List<String> trBusinessClassificationCodes) {
            this.trBusinessClassificationCodes = trBusinessClassificationCodes;
            this.changedFields = changedFields.add("TrBusinessClassificationCodes");
            return this;
        }

        public Builder trBusinessClassificationCodesNextLink(String trBusinessClassificationCodesNextLink) {
            this.trBusinessClassificationCodesNextLink = trBusinessClassificationCodesNextLink;
            this.changedFields = changedFields.add("TrBusinessClassificationCodes");
            return this;
        }

        public Builder verifiedOnly(Boolean verifiedOnly) {
            this.verifiedOnly = verifiedOnly;
            this.changedFields = changedFields.add("VerifiedOnly");
            return this;
        }

        public Builder regulatedOnly(Boolean regulatedOnly) {
            this.regulatedOnly = regulatedOnly;
            this.changedFields = changedFields.add("RegulatedOnly");
            return this;
        }

        public Builder issuersOnly(Boolean issuersOnly) {
            this.issuersOnly = issuersOnly;
            this.changedFields = changedFields.add("IssuersOnly");
            return this;
        }

        public Builder activeOnly(Boolean activeOnly) {
            this.activeOnly = activeOnly;
            this.changedFields = changedFields.add("ActiveOnly");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder preferredIdentifierType(IdentifierType preferredIdentifierType) {
            this.preferredIdentifierType = preferredIdentifierType;
            this.changedFields = changedFields.add("PreferredIdentifierType");
            return this;
        }

        public EntitySearchRequest build() {
            EntitySearchRequest _x = new EntitySearchRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.EntitySearchRequest";
            _x.name = name;
            _x.officialNameOnly = officialNameOnly;
            _x.domicileCodes = domicileCodes;
            _x.domicileCodesNextLink = domicileCodesNextLink;
            _x.countryOfIncorporationCodes = countryOfIncorporationCodes;
            _x.countryOfIncorporationCodesNextLink = countryOfIncorporationCodesNextLink;
            _x.trBusinessClassificationCodes = trBusinessClassificationCodes;
            _x.trBusinessClassificationCodesNextLink = trBusinessClassificationCodesNextLink;
            _x.verifiedOnly = verifiedOnly;
            _x.regulatedOnly = regulatedOnly;
            _x.issuersOnly = issuersOnly;
            _x.activeOnly = activeOnly;
            _x.identifierType = identifierType;
            _x.identifier = identifier;
            _x.preferredIdentifierType = preferredIdentifierType;
            return _x;
        }
    }

    private EntitySearchRequest _copy() {
        EntitySearchRequest _x = new EntitySearchRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.officialNameOnly = officialNameOnly;
        _x.domicileCodes = domicileCodes;
        _x.countryOfIncorporationCodes = countryOfIncorporationCodes;
        _x.trBusinessClassificationCodes = trBusinessClassificationCodes;
        _x.verifiedOnly = verifiedOnly;
        _x.regulatedOnly = regulatedOnly;
        _x.issuersOnly = issuersOnly;
        _x.activeOnly = activeOnly;
        _x.identifierType = identifierType;
        _x.identifier = identifier;
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntitySearchRequest[");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("OfficialNameOnly=");
        b.append(this.officialNameOnly);
        b.append(", ");
        b.append("DomicileCodes=");
        b.append(this.domicileCodes);
        b.append(", ");
        b.append("CountryOfIncorporationCodes=");
        b.append(this.countryOfIncorporationCodes);
        b.append(", ");
        b.append("TrBusinessClassificationCodes=");
        b.append(this.trBusinessClassificationCodes);
        b.append(", ");
        b.append("VerifiedOnly=");
        b.append(this.verifiedOnly);
        b.append(", ");
        b.append("RegulatedOnly=");
        b.append(this.regulatedOnly);
        b.append(", ");
        b.append("IssuersOnly=");
        b.append(this.issuersOnly);
        b.append(", ");
        b.append("ActiveOnly=");
        b.append(this.activeOnly);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("PreferredIdentifierType=");
        b.append(this.preferredIdentifierType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
