package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.content.complex.ValidatedEntity;
import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.enums.InstrumentType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Type", 
    "Domicile", 
    "CountryOfIncorporation", 
    "ParentOrgId", 
    "UltimateParentOrgId"})
public class EntitySearchResult extends ValidatedEntity implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("Type")
    protected String type;

    @JsonProperty("Domicile")
    protected String domicile;

    @JsonProperty("CountryOfIncorporation")
    protected String countryOfIncorporation;

    @JsonProperty("ParentOrgId")
    protected String parentOrgId;

    @JsonProperty("UltimateParentOrgId")
    protected String ultimateParentOrgId;

    protected EntitySearchResult() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.EntitySearchResult";
    }

    @Property(name="Type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public EntitySearchResult withType(String type) {
        EntitySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EntitySearchResult");
        _x.type = type;
        return _x;
    }

    @Property(name="Domicile")
    @JsonIgnore
    public Optional<String> getDomicile() {
        return Optional.ofNullable(domicile);
    }

    public EntitySearchResult withDomicile(String domicile) {
        EntitySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EntitySearchResult");
        _x.domicile = domicile;
        return _x;
    }

    @Property(name="CountryOfIncorporation")
    @JsonIgnore
    public Optional<String> getCountryOfIncorporation() {
        return Optional.ofNullable(countryOfIncorporation);
    }

    public EntitySearchResult withCountryOfIncorporation(String countryOfIncorporation) {
        EntitySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EntitySearchResult");
        _x.countryOfIncorporation = countryOfIncorporation;
        return _x;
    }

    @Property(name="ParentOrgId")
    @JsonIgnore
    public Optional<String> getParentOrgId() {
        return Optional.ofNullable(parentOrgId);
    }

    public EntitySearchResult withParentOrgId(String parentOrgId) {
        EntitySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EntitySearchResult");
        _x.parentOrgId = parentOrgId;
        return _x;
    }

    @Property(name="UltimateParentOrgId")
    @JsonIgnore
    public Optional<String> getUltimateParentOrgId() {
        return Optional.ofNullable(ultimateParentOrgId);
    }

    public EntitySearchResult withUltimateParentOrgId(String ultimateParentOrgId) {
        EntitySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EntitySearchResult");
        _x.ultimateParentOrgId = ultimateParentOrgId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEntitySearchResult() {
        return new Builder();
    }

    public static final class Builder {
        private String key;
        private String description;
        private InstrumentType instrumentType;
        private String identifier;
        private IdentifierType identifierType;
        private String userDefinedIdentifier;
        private String userDefinedIdentifier2;
        private String userDefinedIdentifier3;
        private String userDefinedIdentifier4;
        private String userDefinedIdentifier5;
        private String userDefinedIdentifier6;
        private String type;
        private String domicile;
        private String countryOfIncorporation;
        private String parentOrgId;
        private String ultimateParentOrgId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder key(String key) {
            this.key = key;
            this.changedFields = changedFields.add("Key");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder instrumentType(InstrumentType instrumentType) {
            this.instrumentType = instrumentType;
            this.changedFields = changedFields.add("InstrumentType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder userDefinedIdentifier(String userDefinedIdentifier) {
            this.userDefinedIdentifier = userDefinedIdentifier;
            this.changedFields = changedFields.add("UserDefinedIdentifier");
            return this;
        }

        public Builder userDefinedIdentifier2(String userDefinedIdentifier2) {
            this.userDefinedIdentifier2 = userDefinedIdentifier2;
            this.changedFields = changedFields.add("UserDefinedIdentifier2");
            return this;
        }

        public Builder userDefinedIdentifier3(String userDefinedIdentifier3) {
            this.userDefinedIdentifier3 = userDefinedIdentifier3;
            this.changedFields = changedFields.add("UserDefinedIdentifier3");
            return this;
        }

        public Builder userDefinedIdentifier4(String userDefinedIdentifier4) {
            this.userDefinedIdentifier4 = userDefinedIdentifier4;
            this.changedFields = changedFields.add("UserDefinedIdentifier4");
            return this;
        }

        public Builder userDefinedIdentifier5(String userDefinedIdentifier5) {
            this.userDefinedIdentifier5 = userDefinedIdentifier5;
            this.changedFields = changedFields.add("UserDefinedIdentifier5");
            return this;
        }

        public Builder userDefinedIdentifier6(String userDefinedIdentifier6) {
            this.userDefinedIdentifier6 = userDefinedIdentifier6;
            this.changedFields = changedFields.add("UserDefinedIdentifier6");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("Type");
            return this;
        }

        public Builder domicile(String domicile) {
            this.domicile = domicile;
            this.changedFields = changedFields.add("Domicile");
            return this;
        }

        public Builder countryOfIncorporation(String countryOfIncorporation) {
            this.countryOfIncorporation = countryOfIncorporation;
            this.changedFields = changedFields.add("CountryOfIncorporation");
            return this;
        }

        public Builder parentOrgId(String parentOrgId) {
            this.parentOrgId = parentOrgId;
            this.changedFields = changedFields.add("ParentOrgId");
            return this;
        }

        public Builder ultimateParentOrgId(String ultimateParentOrgId) {
            this.ultimateParentOrgId = ultimateParentOrgId;
            this.changedFields = changedFields.add("UltimateParentOrgId");
            return this;
        }

        public EntitySearchResult build() {
            EntitySearchResult _x = new EntitySearchResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.EntitySearchResult";
            _x.key = key;
            _x.description = description;
            _x.instrumentType = instrumentType;
            _x.identifier = identifier;
            _x.identifierType = identifierType;
            _x.userDefinedIdentifier = userDefinedIdentifier;
            _x.userDefinedIdentifier2 = userDefinedIdentifier2;
            _x.userDefinedIdentifier3 = userDefinedIdentifier3;
            _x.userDefinedIdentifier4 = userDefinedIdentifier4;
            _x.userDefinedIdentifier5 = userDefinedIdentifier5;
            _x.userDefinedIdentifier6 = userDefinedIdentifier6;
            _x.type = type;
            _x.domicile = domicile;
            _x.countryOfIncorporation = countryOfIncorporation;
            _x.parentOrgId = parentOrgId;
            _x.ultimateParentOrgId = ultimateParentOrgId;
            return _x;
        }
    }

    private EntitySearchResult _copy() {
        EntitySearchResult _x = new EntitySearchResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.key = key;
        _x.description = description;
        _x.instrumentType = instrumentType;
        _x.identifier = identifier;
        _x.identifierType = identifierType;
        _x.userDefinedIdentifier = userDefinedIdentifier;
        _x.userDefinedIdentifier2 = userDefinedIdentifier2;
        _x.userDefinedIdentifier3 = userDefinedIdentifier3;
        _x.userDefinedIdentifier4 = userDefinedIdentifier4;
        _x.userDefinedIdentifier5 = userDefinedIdentifier5;
        _x.userDefinedIdentifier6 = userDefinedIdentifier6;
        _x.type = type;
        _x.domicile = domicile;
        _x.countryOfIncorporation = countryOfIncorporation;
        _x.parentOrgId = parentOrgId;
        _x.ultimateParentOrgId = ultimateParentOrgId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntitySearchResult[");
        b.append("Key=");
        b.append(this.key);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("InstrumentType=");
        b.append(this.instrumentType);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("UserDefinedIdentifier=");
        b.append(this.userDefinedIdentifier);
        b.append(", ");
        b.append("UserDefinedIdentifier2=");
        b.append(this.userDefinedIdentifier2);
        b.append(", ");
        b.append("UserDefinedIdentifier3=");
        b.append(this.userDefinedIdentifier3);
        b.append(", ");
        b.append("UserDefinedIdentifier4=");
        b.append(this.userDefinedIdentifier4);
        b.append(", ");
        b.append("UserDefinedIdentifier5=");
        b.append(this.userDefinedIdentifier5);
        b.append(", ");
        b.append("UserDefinedIdentifier6=");
        b.append(this.userDefinedIdentifier6);
        b.append(", ");
        b.append("Type=");
        b.append(this.type);
        b.append(", ");
        b.append("Domicile=");
        b.append(this.domicile);
        b.append(", ");
        b.append("CountryOfIncorporation=");
        b.append(this.countryOfIncorporation);
        b.append(", ");
        b.append("ParentOrgId=");
        b.append(this.parentOrgId);
        b.append(", ");
        b.append("UltimateParentOrgId=");
        b.append(this.ultimateParentOrgId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
