package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.equity.enums.EquityStatus;
import thomsonreuters.dss.api.content.equity.enums.FairValueIndicator;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "SubTypeCodes", 
    "AssetCategoryCodes", 
    "CompanyName", 
    "CurrencyCodes", 
    "Description", 
    "DomicileCodes", 
    "FairValueIndicator", 
    "ExchangeCodes", 
    "GicsCodes", 
    "FileCodes", 
    "OrgId", 
    "AssetStatus", 
    "Ticker", 
    "IdentifierType", 
    "Identifier", 
    "PreferredIdentifierType"})
public class EquitySearchRequest implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("SubTypeCodes")
    protected List<String> subTypeCodes;

    @JsonProperty("SubTypeCodes@nextLink")
    protected String subTypeCodesNextLink;

    @JsonProperty("AssetCategoryCodes")
    protected List<String> assetCategoryCodes;

    @JsonProperty("AssetCategoryCodes@nextLink")
    protected String assetCategoryCodesNextLink;

    @JsonProperty("CompanyName")
    protected String companyName;

    @JsonProperty("CurrencyCodes")
    protected List<String> currencyCodes;

    @JsonProperty("CurrencyCodes@nextLink")
    protected String currencyCodesNextLink;

    @JsonProperty("Description")
    protected String description;

    @JsonProperty("DomicileCodes")
    protected List<String> domicileCodes;

    @JsonProperty("DomicileCodes@nextLink")
    protected String domicileCodesNextLink;

    @JsonProperty("FairValueIndicator")
    protected FairValueIndicator fairValueIndicator;

    @JsonProperty("ExchangeCodes")
    protected List<String> exchangeCodes;

    @JsonProperty("ExchangeCodes@nextLink")
    protected String exchangeCodesNextLink;

    @JsonProperty("GicsCodes")
    protected List<String> gicsCodes;

    @JsonProperty("GicsCodes@nextLink")
    protected String gicsCodesNextLink;

    @JsonProperty("FileCodes")
    protected List<String> fileCodes;

    @JsonProperty("FileCodes@nextLink")
    protected String fileCodesNextLink;

    @JsonProperty("OrgId")
    protected String orgId;

    @JsonProperty("AssetStatus")
    protected EquityStatus assetStatus;

    @JsonProperty("Ticker")
    protected String ticker;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("PreferredIdentifierType")
    protected IdentifierType preferredIdentifierType;

    protected EquitySearchRequest() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.EquitySearchRequest";
    }

    @Property(name="SubTypeCodes")
    @JsonIgnore
    public CollectionPage<String> getSubTypeCodes() {
        return new CollectionPage<String>(contextPath, String.class, subTypeCodes, Optional.ofNullable(subTypeCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="AssetCategoryCodes")
    @JsonIgnore
    public CollectionPage<String> getAssetCategoryCodes() {
        return new CollectionPage<String>(contextPath, String.class, assetCategoryCodes, Optional.ofNullable(assetCategoryCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="CompanyName")
    @JsonIgnore
    public Optional<String> getCompanyName() {
        return Optional.ofNullable(companyName);
    }

    public EquitySearchRequest withCompanyName(String companyName) {
        EquitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchRequest");
        _x.companyName = companyName;
        return _x;
    }

    @Property(name="CurrencyCodes")
    @JsonIgnore
    public CollectionPage<String> getCurrencyCodes() {
        return new CollectionPage<String>(contextPath, String.class, currencyCodes, Optional.ofNullable(currencyCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public EquitySearchRequest withDescription(String description) {
        EquitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchRequest");
        _x.description = description;
        return _x;
    }

    @Property(name="DomicileCodes")
    @JsonIgnore
    public CollectionPage<String> getDomicileCodes() {
        return new CollectionPage<String>(contextPath, String.class, domicileCodes, Optional.ofNullable(domicileCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="FairValueIndicator")
    @JsonIgnore
    public Optional<FairValueIndicator> getFairValueIndicator() {
        return Optional.ofNullable(fairValueIndicator);
    }

    public EquitySearchRequest withFairValueIndicator(FairValueIndicator fairValueIndicator) {
        EquitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchRequest");
        _x.fairValueIndicator = fairValueIndicator;
        return _x;
    }

    @Property(name="ExchangeCodes")
    @JsonIgnore
    public CollectionPage<String> getExchangeCodes() {
        return new CollectionPage<String>(contextPath, String.class, exchangeCodes, Optional.ofNullable(exchangeCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="GicsCodes")
    @JsonIgnore
    public CollectionPage<String> getGicsCodes() {
        return new CollectionPage<String>(contextPath, String.class, gicsCodes, Optional.ofNullable(gicsCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="FileCodes")
    @JsonIgnore
    public CollectionPage<String> getFileCodes() {
        return new CollectionPage<String>(contextPath, String.class, fileCodes, Optional.ofNullable(fileCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="OrgId")
    @JsonIgnore
    public Optional<String> getOrgId() {
        return Optional.ofNullable(orgId);
    }

    public EquitySearchRequest withOrgId(String orgId) {
        EquitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchRequest");
        _x.orgId = orgId;
        return _x;
    }

    @Property(name="AssetStatus")
    @JsonIgnore
    public Optional<EquityStatus> getAssetStatus() {
        return Optional.ofNullable(assetStatus);
    }

    public EquitySearchRequest withAssetStatus(EquityStatus assetStatus) {
        EquitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchRequest");
        _x.assetStatus = assetStatus;
        return _x;
    }

    @Property(name="Ticker")
    @JsonIgnore
    public Optional<String> getTicker() {
        return Optional.ofNullable(ticker);
    }

    public EquitySearchRequest withTicker(String ticker) {
        EquitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchRequest");
        _x.ticker = ticker;
        return _x;
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public EquitySearchRequest withIdentifierType(IdentifierType identifierType) {
        EquitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchRequest");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public EquitySearchRequest withIdentifier(String identifier) {
        EquitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchRequest");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="PreferredIdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getPreferredIdentifierType() {
        return Optional.ofNullable(preferredIdentifierType);
    }

    public EquitySearchRequest withPreferredIdentifierType(IdentifierType preferredIdentifierType) {
        EquitySearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchRequest");
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> subTypeCodes;
        private String subTypeCodesNextLink;
        private List<String> assetCategoryCodes;
        private String assetCategoryCodesNextLink;
        private String companyName;
        private List<String> currencyCodes;
        private String currencyCodesNextLink;
        private String description;
        private List<String> domicileCodes;
        private String domicileCodesNextLink;
        private FairValueIndicator fairValueIndicator;
        private List<String> exchangeCodes;
        private String exchangeCodesNextLink;
        private List<String> gicsCodes;
        private String gicsCodesNextLink;
        private List<String> fileCodes;
        private String fileCodesNextLink;
        private String orgId;
        private EquityStatus assetStatus;
        private String ticker;
        private IdentifierType identifierType;
        private String identifier;
        private IdentifierType preferredIdentifierType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder subTypeCodes(List<String> subTypeCodes) {
            this.subTypeCodes = subTypeCodes;
            this.changedFields = changedFields.add("SubTypeCodes");
            return this;
        }

        public Builder subTypeCodesNextLink(String subTypeCodesNextLink) {
            this.subTypeCodesNextLink = subTypeCodesNextLink;
            this.changedFields = changedFields.add("SubTypeCodes");
            return this;
        }

        public Builder assetCategoryCodes(List<String> assetCategoryCodes) {
            this.assetCategoryCodes = assetCategoryCodes;
            this.changedFields = changedFields.add("AssetCategoryCodes");
            return this;
        }

        public Builder assetCategoryCodesNextLink(String assetCategoryCodesNextLink) {
            this.assetCategoryCodesNextLink = assetCategoryCodesNextLink;
            this.changedFields = changedFields.add("AssetCategoryCodes");
            return this;
        }

        public Builder companyName(String companyName) {
            this.companyName = companyName;
            this.changedFields = changedFields.add("CompanyName");
            return this;
        }

        public Builder currencyCodes(List<String> currencyCodes) {
            this.currencyCodes = currencyCodes;
            this.changedFields = changedFields.add("CurrencyCodes");
            return this;
        }

        public Builder currencyCodesNextLink(String currencyCodesNextLink) {
            this.currencyCodesNextLink = currencyCodesNextLink;
            this.changedFields = changedFields.add("CurrencyCodes");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder domicileCodes(List<String> domicileCodes) {
            this.domicileCodes = domicileCodes;
            this.changedFields = changedFields.add("DomicileCodes");
            return this;
        }

        public Builder domicileCodesNextLink(String domicileCodesNextLink) {
            this.domicileCodesNextLink = domicileCodesNextLink;
            this.changedFields = changedFields.add("DomicileCodes");
            return this;
        }

        public Builder fairValueIndicator(FairValueIndicator fairValueIndicator) {
            this.fairValueIndicator = fairValueIndicator;
            this.changedFields = changedFields.add("FairValueIndicator");
            return this;
        }

        public Builder exchangeCodes(List<String> exchangeCodes) {
            this.exchangeCodes = exchangeCodes;
            this.changedFields = changedFields.add("ExchangeCodes");
            return this;
        }

        public Builder exchangeCodesNextLink(String exchangeCodesNextLink) {
            this.exchangeCodesNextLink = exchangeCodesNextLink;
            this.changedFields = changedFields.add("ExchangeCodes");
            return this;
        }

        public Builder gicsCodes(List<String> gicsCodes) {
            this.gicsCodes = gicsCodes;
            this.changedFields = changedFields.add("GicsCodes");
            return this;
        }

        public Builder gicsCodesNextLink(String gicsCodesNextLink) {
            this.gicsCodesNextLink = gicsCodesNextLink;
            this.changedFields = changedFields.add("GicsCodes");
            return this;
        }

        public Builder fileCodes(List<String> fileCodes) {
            this.fileCodes = fileCodes;
            this.changedFields = changedFields.add("FileCodes");
            return this;
        }

        public Builder fileCodesNextLink(String fileCodesNextLink) {
            this.fileCodesNextLink = fileCodesNextLink;
            this.changedFields = changedFields.add("FileCodes");
            return this;
        }

        public Builder orgId(String orgId) {
            this.orgId = orgId;
            this.changedFields = changedFields.add("OrgId");
            return this;
        }

        public Builder assetStatus(EquityStatus assetStatus) {
            this.assetStatus = assetStatus;
            this.changedFields = changedFields.add("AssetStatus");
            return this;
        }

        public Builder ticker(String ticker) {
            this.ticker = ticker;
            this.changedFields = changedFields.add("Ticker");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder preferredIdentifierType(IdentifierType preferredIdentifierType) {
            this.preferredIdentifierType = preferredIdentifierType;
            this.changedFields = changedFields.add("PreferredIdentifierType");
            return this;
        }

        public EquitySearchRequest build() {
            EquitySearchRequest _x = new EquitySearchRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.EquitySearchRequest";
            _x.subTypeCodes = subTypeCodes;
            _x.subTypeCodesNextLink = subTypeCodesNextLink;
            _x.assetCategoryCodes = assetCategoryCodes;
            _x.assetCategoryCodesNextLink = assetCategoryCodesNextLink;
            _x.companyName = companyName;
            _x.currencyCodes = currencyCodes;
            _x.currencyCodesNextLink = currencyCodesNextLink;
            _x.description = description;
            _x.domicileCodes = domicileCodes;
            _x.domicileCodesNextLink = domicileCodesNextLink;
            _x.fairValueIndicator = fairValueIndicator;
            _x.exchangeCodes = exchangeCodes;
            _x.exchangeCodesNextLink = exchangeCodesNextLink;
            _x.gicsCodes = gicsCodes;
            _x.gicsCodesNextLink = gicsCodesNextLink;
            _x.fileCodes = fileCodes;
            _x.fileCodesNextLink = fileCodesNextLink;
            _x.orgId = orgId;
            _x.assetStatus = assetStatus;
            _x.ticker = ticker;
            _x.identifierType = identifierType;
            _x.identifier = identifier;
            _x.preferredIdentifierType = preferredIdentifierType;
            return _x;
        }
    }

    private EquitySearchRequest _copy() {
        EquitySearchRequest _x = new EquitySearchRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.subTypeCodes = subTypeCodes;
        _x.assetCategoryCodes = assetCategoryCodes;
        _x.companyName = companyName;
        _x.currencyCodes = currencyCodes;
        _x.description = description;
        _x.domicileCodes = domicileCodes;
        _x.fairValueIndicator = fairValueIndicator;
        _x.exchangeCodes = exchangeCodes;
        _x.gicsCodes = gicsCodes;
        _x.fileCodes = fileCodes;
        _x.orgId = orgId;
        _x.assetStatus = assetStatus;
        _x.ticker = ticker;
        _x.identifierType = identifierType;
        _x.identifier = identifier;
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EquitySearchRequest[");
        b.append("SubTypeCodes=");
        b.append(this.subTypeCodes);
        b.append(", ");
        b.append("AssetCategoryCodes=");
        b.append(this.assetCategoryCodes);
        b.append(", ");
        b.append("CompanyName=");
        b.append(this.companyName);
        b.append(", ");
        b.append("CurrencyCodes=");
        b.append(this.currencyCodes);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("DomicileCodes=");
        b.append(this.domicileCodes);
        b.append(", ");
        b.append("FairValueIndicator=");
        b.append(this.fairValueIndicator);
        b.append(", ");
        b.append("ExchangeCodes=");
        b.append(this.exchangeCodes);
        b.append(", ");
        b.append("GicsCodes=");
        b.append(this.gicsCodes);
        b.append(", ");
        b.append("FileCodes=");
        b.append(this.fileCodes);
        b.append(", ");
        b.append("OrgId=");
        b.append(this.orgId);
        b.append(", ");
        b.append("AssetStatus=");
        b.append(this.assetStatus);
        b.append(", ");
        b.append("Ticker=");
        b.append(this.ticker);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("PreferredIdentifierType=");
        b.append(this.preferredIdentifierType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
