package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.content.complex.ValidatedInstrument;
import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.enums.InstrumentType;
import thomsonreuters.dss.api.content.enums.ValidityStatus;
import thomsonreuters.dss.api.content.equity.enums.EquityStatus;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "DomicileCode", 
    "CurrencyCodes", 
    "SubTypeCode", 
    "AssetStatus", 
    "IssuerName", 
    "IssuerOrgId", 
    "Exchange", 
    "FileCode"})
public class EquitySearchResult extends ValidatedInstrument implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("DomicileCode")
    protected String domicileCode;

    @JsonProperty("CurrencyCodes")
    protected String currencyCodes;

    @JsonProperty("SubTypeCode")
    protected String subTypeCode;

    @JsonProperty("AssetStatus")
    protected EquityStatus assetStatus;

    @JsonProperty("IssuerName")
    protected String issuerName;

    @JsonProperty("IssuerOrgId")
    protected String issuerOrgId;

    @JsonProperty("Exchange")
    protected String exchange;

    @JsonProperty("FileCode")
    protected String fileCode;

    protected EquitySearchResult() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.EquitySearchResult";
    }

    @Property(name="DomicileCode")
    @JsonIgnore
    public Optional<String> getDomicileCode() {
        return Optional.ofNullable(domicileCode);
    }

    public EquitySearchResult withDomicileCode(String domicileCode) {
        EquitySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchResult");
        _x.domicileCode = domicileCode;
        return _x;
    }

    @Property(name="CurrencyCodes")
    @JsonIgnore
    public Optional<String> getCurrencyCodes() {
        return Optional.ofNullable(currencyCodes);
    }

    public EquitySearchResult withCurrencyCodes(String currencyCodes) {
        EquitySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchResult");
        _x.currencyCodes = currencyCodes;
        return _x;
    }

    @Property(name="SubTypeCode")
    @JsonIgnore
    public Optional<String> getSubTypeCode() {
        return Optional.ofNullable(subTypeCode);
    }

    public EquitySearchResult withSubTypeCode(String subTypeCode) {
        EquitySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchResult");
        _x.subTypeCode = subTypeCode;
        return _x;
    }

    @Property(name="AssetStatus")
    @JsonIgnore
    public Optional<EquityStatus> getAssetStatus() {
        return Optional.ofNullable(assetStatus);
    }

    public EquitySearchResult withAssetStatus(EquityStatus assetStatus) {
        EquitySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchResult");
        _x.assetStatus = assetStatus;
        return _x;
    }

    @Property(name="IssuerName")
    @JsonIgnore
    public Optional<String> getIssuerName() {
        return Optional.ofNullable(issuerName);
    }

    public EquitySearchResult withIssuerName(String issuerName) {
        EquitySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchResult");
        _x.issuerName = issuerName;
        return _x;
    }

    @Property(name="IssuerOrgId")
    @JsonIgnore
    public Optional<String> getIssuerOrgId() {
        return Optional.ofNullable(issuerOrgId);
    }

    public EquitySearchResult withIssuerOrgId(String issuerOrgId) {
        EquitySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchResult");
        _x.issuerOrgId = issuerOrgId;
        return _x;
    }

    @Property(name="Exchange")
    @JsonIgnore
    public Optional<String> getExchange() {
        return Optional.ofNullable(exchange);
    }

    public EquitySearchResult withExchange(String exchange) {
        EquitySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchResult");
        _x.exchange = exchange;
        return _x;
    }

    @Property(name="FileCode")
    @JsonIgnore
    public Optional<String> getFileCode() {
        return Optional.ofNullable(fileCode);
    }

    public EquitySearchResult withFileCode(String fileCode) {
        EquitySearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.EquitySearchResult");
        _x.fileCode = fileCode;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEquitySearchResult() {
        return new Builder();
    }

    public static final class Builder {
        private String key;
        private String description;
        private InstrumentType instrumentType;
        private ValidityStatus status;
        private String source;
        private String identifier;
        private IdentifierType identifierType;
        private String userDefinedIdentifier;
        private String userDefinedIdentifier2;
        private String userDefinedIdentifier3;
        private String userDefinedIdentifier4;
        private String userDefinedIdentifier5;
        private String userDefinedIdentifier6;
        private String domicileCode;
        private String currencyCodes;
        private String subTypeCode;
        private EquityStatus assetStatus;
        private String issuerName;
        private String issuerOrgId;
        private String exchange;
        private String fileCode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder key(String key) {
            this.key = key;
            this.changedFields = changedFields.add("Key");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder instrumentType(InstrumentType instrumentType) {
            this.instrumentType = instrumentType;
            this.changedFields = changedFields.add("InstrumentType");
            return this;
        }

        public Builder status(ValidityStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("Status");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.changedFields = changedFields.add("Source");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder userDefinedIdentifier(String userDefinedIdentifier) {
            this.userDefinedIdentifier = userDefinedIdentifier;
            this.changedFields = changedFields.add("UserDefinedIdentifier");
            return this;
        }

        public Builder userDefinedIdentifier2(String userDefinedIdentifier2) {
            this.userDefinedIdentifier2 = userDefinedIdentifier2;
            this.changedFields = changedFields.add("UserDefinedIdentifier2");
            return this;
        }

        public Builder userDefinedIdentifier3(String userDefinedIdentifier3) {
            this.userDefinedIdentifier3 = userDefinedIdentifier3;
            this.changedFields = changedFields.add("UserDefinedIdentifier3");
            return this;
        }

        public Builder userDefinedIdentifier4(String userDefinedIdentifier4) {
            this.userDefinedIdentifier4 = userDefinedIdentifier4;
            this.changedFields = changedFields.add("UserDefinedIdentifier4");
            return this;
        }

        public Builder userDefinedIdentifier5(String userDefinedIdentifier5) {
            this.userDefinedIdentifier5 = userDefinedIdentifier5;
            this.changedFields = changedFields.add("UserDefinedIdentifier5");
            return this;
        }

        public Builder userDefinedIdentifier6(String userDefinedIdentifier6) {
            this.userDefinedIdentifier6 = userDefinedIdentifier6;
            this.changedFields = changedFields.add("UserDefinedIdentifier6");
            return this;
        }

        public Builder domicileCode(String domicileCode) {
            this.domicileCode = domicileCode;
            this.changedFields = changedFields.add("DomicileCode");
            return this;
        }

        public Builder currencyCodes(String currencyCodes) {
            this.currencyCodes = currencyCodes;
            this.changedFields = changedFields.add("CurrencyCodes");
            return this;
        }

        public Builder subTypeCode(String subTypeCode) {
            this.subTypeCode = subTypeCode;
            this.changedFields = changedFields.add("SubTypeCode");
            return this;
        }

        public Builder assetStatus(EquityStatus assetStatus) {
            this.assetStatus = assetStatus;
            this.changedFields = changedFields.add("AssetStatus");
            return this;
        }

        public Builder issuerName(String issuerName) {
            this.issuerName = issuerName;
            this.changedFields = changedFields.add("IssuerName");
            return this;
        }

        public Builder issuerOrgId(String issuerOrgId) {
            this.issuerOrgId = issuerOrgId;
            this.changedFields = changedFields.add("IssuerOrgId");
            return this;
        }

        public Builder exchange(String exchange) {
            this.exchange = exchange;
            this.changedFields = changedFields.add("Exchange");
            return this;
        }

        public Builder fileCode(String fileCode) {
            this.fileCode = fileCode;
            this.changedFields = changedFields.add("FileCode");
            return this;
        }

        public EquitySearchResult build() {
            EquitySearchResult _x = new EquitySearchResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.EquitySearchResult";
            _x.key = key;
            _x.description = description;
            _x.instrumentType = instrumentType;
            _x.status = status;
            _x.source = source;
            _x.identifier = identifier;
            _x.identifierType = identifierType;
            _x.userDefinedIdentifier = userDefinedIdentifier;
            _x.userDefinedIdentifier2 = userDefinedIdentifier2;
            _x.userDefinedIdentifier3 = userDefinedIdentifier3;
            _x.userDefinedIdentifier4 = userDefinedIdentifier4;
            _x.userDefinedIdentifier5 = userDefinedIdentifier5;
            _x.userDefinedIdentifier6 = userDefinedIdentifier6;
            _x.domicileCode = domicileCode;
            _x.currencyCodes = currencyCodes;
            _x.subTypeCode = subTypeCode;
            _x.assetStatus = assetStatus;
            _x.issuerName = issuerName;
            _x.issuerOrgId = issuerOrgId;
            _x.exchange = exchange;
            _x.fileCode = fileCode;
            return _x;
        }
    }

    private EquitySearchResult _copy() {
        EquitySearchResult _x = new EquitySearchResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.key = key;
        _x.description = description;
        _x.instrumentType = instrumentType;
        _x.status = status;
        _x.source = source;
        _x.identifier = identifier;
        _x.identifierType = identifierType;
        _x.userDefinedIdentifier = userDefinedIdentifier;
        _x.userDefinedIdentifier2 = userDefinedIdentifier2;
        _x.userDefinedIdentifier3 = userDefinedIdentifier3;
        _x.userDefinedIdentifier4 = userDefinedIdentifier4;
        _x.userDefinedIdentifier5 = userDefinedIdentifier5;
        _x.userDefinedIdentifier6 = userDefinedIdentifier6;
        _x.domicileCode = domicileCode;
        _x.currencyCodes = currencyCodes;
        _x.subTypeCode = subTypeCode;
        _x.assetStatus = assetStatus;
        _x.issuerName = issuerName;
        _x.issuerOrgId = issuerOrgId;
        _x.exchange = exchange;
        _x.fileCode = fileCode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EquitySearchResult[");
        b.append("Key=");
        b.append(this.key);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("InstrumentType=");
        b.append(this.instrumentType);
        b.append(", ");
        b.append("Status=");
        b.append(this.status);
        b.append(", ");
        b.append("Source=");
        b.append(this.source);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("UserDefinedIdentifier=");
        b.append(this.userDefinedIdentifier);
        b.append(", ");
        b.append("UserDefinedIdentifier2=");
        b.append(this.userDefinedIdentifier2);
        b.append(", ");
        b.append("UserDefinedIdentifier3=");
        b.append(this.userDefinedIdentifier3);
        b.append(", ");
        b.append("UserDefinedIdentifier4=");
        b.append(this.userDefinedIdentifier4);
        b.append(", ");
        b.append("UserDefinedIdentifier5=");
        b.append(this.userDefinedIdentifier5);
        b.append(", ");
        b.append("UserDefinedIdentifier6=");
        b.append(this.userDefinedIdentifier6);
        b.append(", ");
        b.append("DomicileCode=");
        b.append(this.domicileCode);
        b.append(", ");
        b.append("CurrencyCodes=");
        b.append(this.currencyCodes);
        b.append(", ");
        b.append("SubTypeCode=");
        b.append(this.subTypeCode);
        b.append(", ");
        b.append("AssetStatus=");
        b.append(this.assetStatus);
        b.append(", ");
        b.append("IssuerName=");
        b.append(this.issuerName);
        b.append(", ");
        b.append("IssuerOrgId=");
        b.append(this.issuerOrgId);
        b.append(", ");
        b.append("Exchange=");
        b.append(this.exchange);
        b.append(", ");
        b.append("FileCode=");
        b.append(this.fileCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
