package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Field", 
    "Value", 
    "Timestamp"})
public class FidHistoryEvent implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Field")
    protected String field;

    @JsonProperty("Value")
    protected String value;

    @JsonProperty("Timestamp")
    protected OffsetDateTime timestamp;

    protected FidHistoryEvent() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.FidHistoryEvent";
    }

    @Property(name="Field")
    @JsonIgnore
    public Optional<String> getField() {
        return Optional.ofNullable(field);
    }

    public FidHistoryEvent withField(String field) {
        FidHistoryEvent _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FidHistoryEvent");
        _x.field = field;
        return _x;
    }

    @Property(name="Value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    public FidHistoryEvent withValue(String value) {
        FidHistoryEvent _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FidHistoryEvent");
        _x.value = value;
        return _x;
    }

    @Property(name="Timestamp")
    @JsonIgnore
    public Optional<OffsetDateTime> getTimestamp() {
        return Optional.ofNullable(timestamp);
    }

    public FidHistoryEvent withTimestamp(OffsetDateTime timestamp) {
        FidHistoryEvent _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FidHistoryEvent");
        _x.timestamp = timestamp;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String field;
        private String value;
        private OffsetDateTime timestamp;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder field(String field) {
            this.field = field;
            this.changedFields = changedFields.add("Field");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("Value");
            return this;
        }

        public Builder timestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            this.changedFields = changedFields.add("Timestamp");
            return this;
        }

        public FidHistoryEvent build() {
            FidHistoryEvent _x = new FidHistoryEvent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.FidHistoryEvent";
            _x.field = field;
            _x.value = value;
            _x.timestamp = timestamp;
            return _x;
        }
    }

    private FidHistoryEvent _copy() {
        FidHistoryEvent _x = new FidHistoryEvent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.field = field;
        _x.value = value;
        _x.timestamp = timestamp;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FidHistoryEvent[");
        b.append("Field=");
        b.append(this.field);
        b.append(", ");
        b.append("Value=");
        b.append(this.value);
        b.append(", ");
        b.append("Timestamp=");
        b.append(this.timestamp);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
