package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.fund.enums.FundStatus;
import thomsonreuters.dss.api.content.fund.enums.FundSubType;
import thomsonreuters.dss.api.content.fund.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "AssetStatus", 
    "FundName", 
    "FundAdministrator", 
    "PortfolioManager", 
    "DomicileCodes", 
    "CurrencyCodes", 
    "SubTypes", 
    "IdentifierType", 
    "Identifier", 
    "PreferredIdentifierType"})
public class FundSearchRequest implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AssetStatus")
    protected FundStatus assetStatus;

    @JsonProperty("FundName")
    protected String fundName;

    @JsonProperty("FundAdministrator")
    protected String fundAdministrator;

    @JsonProperty("PortfolioManager")
    protected String portfolioManager;

    @JsonProperty("DomicileCodes")
    protected List<String> domicileCodes;

    @JsonProperty("DomicileCodes@nextLink")
    protected String domicileCodesNextLink;

    @JsonProperty("CurrencyCodes")
    protected List<String> currencyCodes;

    @JsonProperty("CurrencyCodes@nextLink")
    protected String currencyCodesNextLink;

    @JsonProperty("SubTypes")
    protected List<FundSubType> subTypes;

    @JsonProperty("SubTypes@nextLink")
    protected String subTypesNextLink;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("PreferredIdentifierType")
    protected IdentifierType preferredIdentifierType;

    protected FundSearchRequest() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.FundSearchRequest";
    }

    @Property(name="AssetStatus")
    @JsonIgnore
    public Optional<FundStatus> getAssetStatus() {
        return Optional.ofNullable(assetStatus);
    }

    public FundSearchRequest withAssetStatus(FundStatus assetStatus) {
        FundSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchRequest");
        _x.assetStatus = assetStatus;
        return _x;
    }

    @Property(name="FundName")
    @JsonIgnore
    public Optional<String> getFundName() {
        return Optional.ofNullable(fundName);
    }

    public FundSearchRequest withFundName(String fundName) {
        FundSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchRequest");
        _x.fundName = fundName;
        return _x;
    }

    @Property(name="FundAdministrator")
    @JsonIgnore
    public Optional<String> getFundAdministrator() {
        return Optional.ofNullable(fundAdministrator);
    }

    public FundSearchRequest withFundAdministrator(String fundAdministrator) {
        FundSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchRequest");
        _x.fundAdministrator = fundAdministrator;
        return _x;
    }

    @Property(name="PortfolioManager")
    @JsonIgnore
    public Optional<String> getPortfolioManager() {
        return Optional.ofNullable(portfolioManager);
    }

    public FundSearchRequest withPortfolioManager(String portfolioManager) {
        FundSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchRequest");
        _x.portfolioManager = portfolioManager;
        return _x;
    }

    @Property(name="DomicileCodes")
    @JsonIgnore
    public CollectionPage<String> getDomicileCodes() {
        return new CollectionPage<String>(contextPath, String.class, domicileCodes, Optional.ofNullable(domicileCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="CurrencyCodes")
    @JsonIgnore
    public CollectionPage<String> getCurrencyCodes() {
        return new CollectionPage<String>(contextPath, String.class, currencyCodes, Optional.ofNullable(currencyCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="SubTypes")
    @JsonIgnore
    public CollectionPage<FundSubType> getSubTypes() {
        return new CollectionPage<FundSubType>(contextPath, FundSubType.class, subTypes, Optional.ofNullable(subTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public FundSearchRequest withIdentifierType(IdentifierType identifierType) {
        FundSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchRequest");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public FundSearchRequest withIdentifier(String identifier) {
        FundSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchRequest");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="PreferredIdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getPreferredIdentifierType() {
        return Optional.ofNullable(preferredIdentifierType);
    }

    public FundSearchRequest withPreferredIdentifierType(IdentifierType preferredIdentifierType) {
        FundSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchRequest");
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private FundStatus assetStatus;
        private String fundName;
        private String fundAdministrator;
        private String portfolioManager;
        private List<String> domicileCodes;
        private String domicileCodesNextLink;
        private List<String> currencyCodes;
        private String currencyCodesNextLink;
        private List<FundSubType> subTypes;
        private String subTypesNextLink;
        private IdentifierType identifierType;
        private String identifier;
        private IdentifierType preferredIdentifierType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder assetStatus(FundStatus assetStatus) {
            this.assetStatus = assetStatus;
            this.changedFields = changedFields.add("AssetStatus");
            return this;
        }

        public Builder fundName(String fundName) {
            this.fundName = fundName;
            this.changedFields = changedFields.add("FundName");
            return this;
        }

        public Builder fundAdministrator(String fundAdministrator) {
            this.fundAdministrator = fundAdministrator;
            this.changedFields = changedFields.add("FundAdministrator");
            return this;
        }

        public Builder portfolioManager(String portfolioManager) {
            this.portfolioManager = portfolioManager;
            this.changedFields = changedFields.add("PortfolioManager");
            return this;
        }

        public Builder domicileCodes(List<String> domicileCodes) {
            this.domicileCodes = domicileCodes;
            this.changedFields = changedFields.add("DomicileCodes");
            return this;
        }

        public Builder domicileCodesNextLink(String domicileCodesNextLink) {
            this.domicileCodesNextLink = domicileCodesNextLink;
            this.changedFields = changedFields.add("DomicileCodes");
            return this;
        }

        public Builder currencyCodes(List<String> currencyCodes) {
            this.currencyCodes = currencyCodes;
            this.changedFields = changedFields.add("CurrencyCodes");
            return this;
        }

        public Builder currencyCodesNextLink(String currencyCodesNextLink) {
            this.currencyCodesNextLink = currencyCodesNextLink;
            this.changedFields = changedFields.add("CurrencyCodes");
            return this;
        }

        public Builder subTypes(List<FundSubType> subTypes) {
            this.subTypes = subTypes;
            this.changedFields = changedFields.add("SubTypes");
            return this;
        }

        public Builder subTypesNextLink(String subTypesNextLink) {
            this.subTypesNextLink = subTypesNextLink;
            this.changedFields = changedFields.add("SubTypes");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder preferredIdentifierType(IdentifierType preferredIdentifierType) {
            this.preferredIdentifierType = preferredIdentifierType;
            this.changedFields = changedFields.add("PreferredIdentifierType");
            return this;
        }

        public FundSearchRequest build() {
            FundSearchRequest _x = new FundSearchRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.FundSearchRequest";
            _x.assetStatus = assetStatus;
            _x.fundName = fundName;
            _x.fundAdministrator = fundAdministrator;
            _x.portfolioManager = portfolioManager;
            _x.domicileCodes = domicileCodes;
            _x.domicileCodesNextLink = domicileCodesNextLink;
            _x.currencyCodes = currencyCodes;
            _x.currencyCodesNextLink = currencyCodesNextLink;
            _x.subTypes = subTypes;
            _x.subTypesNextLink = subTypesNextLink;
            _x.identifierType = identifierType;
            _x.identifier = identifier;
            _x.preferredIdentifierType = preferredIdentifierType;
            return _x;
        }
    }

    private FundSearchRequest _copy() {
        FundSearchRequest _x = new FundSearchRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.assetStatus = assetStatus;
        _x.fundName = fundName;
        _x.fundAdministrator = fundAdministrator;
        _x.portfolioManager = portfolioManager;
        _x.domicileCodes = domicileCodes;
        _x.currencyCodes = currencyCodes;
        _x.subTypes = subTypes;
        _x.identifierType = identifierType;
        _x.identifier = identifier;
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FundSearchRequest[");
        b.append("AssetStatus=");
        b.append(this.assetStatus);
        b.append(", ");
        b.append("FundName=");
        b.append(this.fundName);
        b.append(", ");
        b.append("FundAdministrator=");
        b.append(this.fundAdministrator);
        b.append(", ");
        b.append("PortfolioManager=");
        b.append(this.portfolioManager);
        b.append(", ");
        b.append("DomicileCodes=");
        b.append(this.domicileCodes);
        b.append(", ");
        b.append("CurrencyCodes=");
        b.append(this.currencyCodes);
        b.append(", ");
        b.append("SubTypes=");
        b.append(this.subTypes);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("PreferredIdentifierType=");
        b.append(this.preferredIdentifierType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
