package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.content.complex.ValidatedEntity;
import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.enums.InstrumentType;
import thomsonreuters.dss.api.content.fund.enums.FundStatus;
import thomsonreuters.dss.api.content.fund.enums.FundSubType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "FundName", 
    "FundAdministrator", 
    "PortfolioManager", 
    "DomicileCode", 
    "CurrencyCode", 
    "InvestmentType", 
    "SubType", 
    "AssetStatus", 
    "IssuerName", 
    "IssuerOrgId"})
public class FundSearchResult extends ValidatedEntity implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("FundName")
    protected String fundName;

    @JsonProperty("FundAdministrator")
    protected String fundAdministrator;

    @JsonProperty("PortfolioManager")
    protected String portfolioManager;

    @JsonProperty("DomicileCode")
    protected String domicileCode;

    @JsonProperty("CurrencyCode")
    protected String currencyCode;

    @JsonProperty("InvestmentType")
    protected String investmentType;

    @JsonProperty("SubType")
    protected FundSubType subType;

    @JsonProperty("AssetStatus")
    protected FundStatus assetStatus;

    @JsonProperty("IssuerName")
    protected String issuerName;

    @JsonProperty("IssuerOrgId")
    protected String issuerOrgId;

    protected FundSearchResult() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.FundSearchResult";
    }

    @Property(name="FundName")
    @JsonIgnore
    public Optional<String> getFundName() {
        return Optional.ofNullable(fundName);
    }

    public FundSearchResult withFundName(String fundName) {
        FundSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchResult");
        _x.fundName = fundName;
        return _x;
    }

    @Property(name="FundAdministrator")
    @JsonIgnore
    public Optional<String> getFundAdministrator() {
        return Optional.ofNullable(fundAdministrator);
    }

    public FundSearchResult withFundAdministrator(String fundAdministrator) {
        FundSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchResult");
        _x.fundAdministrator = fundAdministrator;
        return _x;
    }

    @Property(name="PortfolioManager")
    @JsonIgnore
    public Optional<String> getPortfolioManager() {
        return Optional.ofNullable(portfolioManager);
    }

    public FundSearchResult withPortfolioManager(String portfolioManager) {
        FundSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchResult");
        _x.portfolioManager = portfolioManager;
        return _x;
    }

    @Property(name="DomicileCode")
    @JsonIgnore
    public Optional<String> getDomicileCode() {
        return Optional.ofNullable(domicileCode);
    }

    public FundSearchResult withDomicileCode(String domicileCode) {
        FundSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchResult");
        _x.domicileCode = domicileCode;
        return _x;
    }

    @Property(name="CurrencyCode")
    @JsonIgnore
    public Optional<String> getCurrencyCode() {
        return Optional.ofNullable(currencyCode);
    }

    public FundSearchResult withCurrencyCode(String currencyCode) {
        FundSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchResult");
        _x.currencyCode = currencyCode;
        return _x;
    }

    @Property(name="InvestmentType")
    @JsonIgnore
    public Optional<String> getInvestmentType() {
        return Optional.ofNullable(investmentType);
    }

    public FundSearchResult withInvestmentType(String investmentType) {
        FundSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchResult");
        _x.investmentType = investmentType;
        return _x;
    }

    @Property(name="SubType")
    @JsonIgnore
    public Optional<FundSubType> getSubType() {
        return Optional.ofNullable(subType);
    }

    public FundSearchResult withSubType(FundSubType subType) {
        FundSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchResult");
        _x.subType = subType;
        return _x;
    }

    @Property(name="AssetStatus")
    @JsonIgnore
    public Optional<FundStatus> getAssetStatus() {
        return Optional.ofNullable(assetStatus);
    }

    public FundSearchResult withAssetStatus(FundStatus assetStatus) {
        FundSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchResult");
        _x.assetStatus = assetStatus;
        return _x;
    }

    @Property(name="IssuerName")
    @JsonIgnore
    public Optional<String> getIssuerName() {
        return Optional.ofNullable(issuerName);
    }

    public FundSearchResult withIssuerName(String issuerName) {
        FundSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchResult");
        _x.issuerName = issuerName;
        return _x;
    }

    @Property(name="IssuerOrgId")
    @JsonIgnore
    public Optional<String> getIssuerOrgId() {
        return Optional.ofNullable(issuerOrgId);
    }

    public FundSearchResult withIssuerOrgId(String issuerOrgId) {
        FundSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FundSearchResult");
        _x.issuerOrgId = issuerOrgId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderFundSearchResult() {
        return new Builder();
    }

    public static final class Builder {
        private String key;
        private String description;
        private InstrumentType instrumentType;
        private String identifier;
        private IdentifierType identifierType;
        private String userDefinedIdentifier;
        private String userDefinedIdentifier2;
        private String userDefinedIdentifier3;
        private String userDefinedIdentifier4;
        private String userDefinedIdentifier5;
        private String userDefinedIdentifier6;
        private String fundName;
        private String fundAdministrator;
        private String portfolioManager;
        private String domicileCode;
        private String currencyCode;
        private String investmentType;
        private FundSubType subType;
        private FundStatus assetStatus;
        private String issuerName;
        private String issuerOrgId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder key(String key) {
            this.key = key;
            this.changedFields = changedFields.add("Key");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder instrumentType(InstrumentType instrumentType) {
            this.instrumentType = instrumentType;
            this.changedFields = changedFields.add("InstrumentType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder userDefinedIdentifier(String userDefinedIdentifier) {
            this.userDefinedIdentifier = userDefinedIdentifier;
            this.changedFields = changedFields.add("UserDefinedIdentifier");
            return this;
        }

        public Builder userDefinedIdentifier2(String userDefinedIdentifier2) {
            this.userDefinedIdentifier2 = userDefinedIdentifier2;
            this.changedFields = changedFields.add("UserDefinedIdentifier2");
            return this;
        }

        public Builder userDefinedIdentifier3(String userDefinedIdentifier3) {
            this.userDefinedIdentifier3 = userDefinedIdentifier3;
            this.changedFields = changedFields.add("UserDefinedIdentifier3");
            return this;
        }

        public Builder userDefinedIdentifier4(String userDefinedIdentifier4) {
            this.userDefinedIdentifier4 = userDefinedIdentifier4;
            this.changedFields = changedFields.add("UserDefinedIdentifier4");
            return this;
        }

        public Builder userDefinedIdentifier5(String userDefinedIdentifier5) {
            this.userDefinedIdentifier5 = userDefinedIdentifier5;
            this.changedFields = changedFields.add("UserDefinedIdentifier5");
            return this;
        }

        public Builder userDefinedIdentifier6(String userDefinedIdentifier6) {
            this.userDefinedIdentifier6 = userDefinedIdentifier6;
            this.changedFields = changedFields.add("UserDefinedIdentifier6");
            return this;
        }

        public Builder fundName(String fundName) {
            this.fundName = fundName;
            this.changedFields = changedFields.add("FundName");
            return this;
        }

        public Builder fundAdministrator(String fundAdministrator) {
            this.fundAdministrator = fundAdministrator;
            this.changedFields = changedFields.add("FundAdministrator");
            return this;
        }

        public Builder portfolioManager(String portfolioManager) {
            this.portfolioManager = portfolioManager;
            this.changedFields = changedFields.add("PortfolioManager");
            return this;
        }

        public Builder domicileCode(String domicileCode) {
            this.domicileCode = domicileCode;
            this.changedFields = changedFields.add("DomicileCode");
            return this;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            this.changedFields = changedFields.add("CurrencyCode");
            return this;
        }

        public Builder investmentType(String investmentType) {
            this.investmentType = investmentType;
            this.changedFields = changedFields.add("InvestmentType");
            return this;
        }

        public Builder subType(FundSubType subType) {
            this.subType = subType;
            this.changedFields = changedFields.add("SubType");
            return this;
        }

        public Builder assetStatus(FundStatus assetStatus) {
            this.assetStatus = assetStatus;
            this.changedFields = changedFields.add("AssetStatus");
            return this;
        }

        public Builder issuerName(String issuerName) {
            this.issuerName = issuerName;
            this.changedFields = changedFields.add("IssuerName");
            return this;
        }

        public Builder issuerOrgId(String issuerOrgId) {
            this.issuerOrgId = issuerOrgId;
            this.changedFields = changedFields.add("IssuerOrgId");
            return this;
        }

        public FundSearchResult build() {
            FundSearchResult _x = new FundSearchResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.FundSearchResult";
            _x.key = key;
            _x.description = description;
            _x.instrumentType = instrumentType;
            _x.identifier = identifier;
            _x.identifierType = identifierType;
            _x.userDefinedIdentifier = userDefinedIdentifier;
            _x.userDefinedIdentifier2 = userDefinedIdentifier2;
            _x.userDefinedIdentifier3 = userDefinedIdentifier3;
            _x.userDefinedIdentifier4 = userDefinedIdentifier4;
            _x.userDefinedIdentifier5 = userDefinedIdentifier5;
            _x.userDefinedIdentifier6 = userDefinedIdentifier6;
            _x.fundName = fundName;
            _x.fundAdministrator = fundAdministrator;
            _x.portfolioManager = portfolioManager;
            _x.domicileCode = domicileCode;
            _x.currencyCode = currencyCode;
            _x.investmentType = investmentType;
            _x.subType = subType;
            _x.assetStatus = assetStatus;
            _x.issuerName = issuerName;
            _x.issuerOrgId = issuerOrgId;
            return _x;
        }
    }

    private FundSearchResult _copy() {
        FundSearchResult _x = new FundSearchResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.key = key;
        _x.description = description;
        _x.instrumentType = instrumentType;
        _x.identifier = identifier;
        _x.identifierType = identifierType;
        _x.userDefinedIdentifier = userDefinedIdentifier;
        _x.userDefinedIdentifier2 = userDefinedIdentifier2;
        _x.userDefinedIdentifier3 = userDefinedIdentifier3;
        _x.userDefinedIdentifier4 = userDefinedIdentifier4;
        _x.userDefinedIdentifier5 = userDefinedIdentifier5;
        _x.userDefinedIdentifier6 = userDefinedIdentifier6;
        _x.fundName = fundName;
        _x.fundAdministrator = fundAdministrator;
        _x.portfolioManager = portfolioManager;
        _x.domicileCode = domicileCode;
        _x.currencyCode = currencyCode;
        _x.investmentType = investmentType;
        _x.subType = subType;
        _x.assetStatus = assetStatus;
        _x.issuerName = issuerName;
        _x.issuerOrgId = issuerOrgId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FundSearchResult[");
        b.append("Key=");
        b.append(this.key);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("InstrumentType=");
        b.append(this.instrumentType);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("UserDefinedIdentifier=");
        b.append(this.userDefinedIdentifier);
        b.append(", ");
        b.append("UserDefinedIdentifier2=");
        b.append(this.userDefinedIdentifier2);
        b.append(", ");
        b.append("UserDefinedIdentifier3=");
        b.append(this.userDefinedIdentifier3);
        b.append(", ");
        b.append("UserDefinedIdentifier4=");
        b.append(this.userDefinedIdentifier4);
        b.append(", ");
        b.append("UserDefinedIdentifier5=");
        b.append(this.userDefinedIdentifier5);
        b.append(", ");
        b.append("UserDefinedIdentifier6=");
        b.append(this.userDefinedIdentifier6);
        b.append(", ");
        b.append("FundName=");
        b.append(this.fundName);
        b.append(", ");
        b.append("FundAdministrator=");
        b.append(this.fundAdministrator);
        b.append(", ");
        b.append("PortfolioManager=");
        b.append(this.portfolioManager);
        b.append(", ");
        b.append("DomicileCode=");
        b.append(this.domicileCode);
        b.append(", ");
        b.append("CurrencyCode=");
        b.append(this.currencyCode);
        b.append(", ");
        b.append("InvestmentType=");
        b.append(this.investmentType);
        b.append(", ");
        b.append("SubType=");
        b.append(this.subType);
        b.append(", ");
        b.append("AssetStatus=");
        b.append(this.assetStatus);
        b.append(", ");
        b.append("IssuerName=");
        b.append(this.issuerName);
        b.append(", ");
        b.append("IssuerOrgId=");
        b.append(this.issuerOrgId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
