package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.futuresandoptions.enums.ExerciseStyle;
import thomsonreuters.dss.api.content.futuresandoptions.enums.FuturesAndOptionsStatus;
import thomsonreuters.dss.api.content.futuresandoptions.enums.FuturesAndOptionsType;
import thomsonreuters.dss.api.content.futuresandoptions.enums.PutCall;
import thomsonreuters.dss.api.search.complex.DateComparison;
import thomsonreuters.dss.api.search.complex.NumericComparison;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "FuturesAndOptionsType", 
    "PutCall", 
    "FileCodes", 
    "UnderlyingRic", 
    "ExerciseStyle", 
    "CurrencyCodes", 
    "Description", 
    "ExchangeCodes", 
    "StrikePrice", 
    "ExpirationDate", 
    "AssetStatus", 
    "IdentifierType", 
    "Identifier", 
    "PreferredIdentifierType"})
public class FuturesAndOptionsSearchRequest implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("FuturesAndOptionsType")
    protected FuturesAndOptionsType futuresAndOptionsType;

    @JsonProperty("PutCall")
    protected PutCall putCall;

    @JsonProperty("FileCodes")
    protected List<String> fileCodes;

    @JsonProperty("FileCodes@nextLink")
    protected String fileCodesNextLink;

    @JsonProperty("UnderlyingRic")
    protected String underlyingRic;

    @JsonProperty("ExerciseStyle")
    protected ExerciseStyle exerciseStyle;

    @JsonProperty("CurrencyCodes")
    protected List<String> currencyCodes;

    @JsonProperty("CurrencyCodes@nextLink")
    protected String currencyCodesNextLink;

    @JsonProperty("Description")
    protected String description;

    @JsonProperty("ExchangeCodes")
    protected List<String> exchangeCodes;

    @JsonProperty("ExchangeCodes@nextLink")
    protected String exchangeCodesNextLink;

    @JsonProperty("StrikePrice")
    protected NumericComparison strikePrice;

    @JsonProperty("ExpirationDate")
    protected DateComparison expirationDate;

    @JsonProperty("AssetStatus")
    protected FuturesAndOptionsStatus assetStatus;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("PreferredIdentifierType")
    protected IdentifierType preferredIdentifierType;

    protected FuturesAndOptionsSearchRequest() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchRequest";
    }

    @Property(name="FuturesAndOptionsType")
    @JsonIgnore
    public Optional<FuturesAndOptionsType> getFuturesAndOptionsType() {
        return Optional.ofNullable(futuresAndOptionsType);
    }

    public FuturesAndOptionsSearchRequest withFuturesAndOptionsType(FuturesAndOptionsType futuresAndOptionsType) {
        FuturesAndOptionsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchRequest");
        _x.futuresAndOptionsType = futuresAndOptionsType;
        return _x;
    }

    @Property(name="PutCall")
    @JsonIgnore
    public Optional<PutCall> getPutCall() {
        return Optional.ofNullable(putCall);
    }

    public FuturesAndOptionsSearchRequest withPutCall(PutCall putCall) {
        FuturesAndOptionsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchRequest");
        _x.putCall = putCall;
        return _x;
    }

    @Property(name="FileCodes")
    @JsonIgnore
    public CollectionPage<String> getFileCodes() {
        return new CollectionPage<String>(contextPath, String.class, fileCodes, Optional.ofNullable(fileCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="UnderlyingRic")
    @JsonIgnore
    public Optional<String> getUnderlyingRic() {
        return Optional.ofNullable(underlyingRic);
    }

    public FuturesAndOptionsSearchRequest withUnderlyingRic(String underlyingRic) {
        FuturesAndOptionsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchRequest");
        _x.underlyingRic = underlyingRic;
        return _x;
    }

    @Property(name="ExerciseStyle")
    @JsonIgnore
    public Optional<ExerciseStyle> getExerciseStyle() {
        return Optional.ofNullable(exerciseStyle);
    }

    public FuturesAndOptionsSearchRequest withExerciseStyle(ExerciseStyle exerciseStyle) {
        FuturesAndOptionsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchRequest");
        _x.exerciseStyle = exerciseStyle;
        return _x;
    }

    @Property(name="CurrencyCodes")
    @JsonIgnore
    public CollectionPage<String> getCurrencyCodes() {
        return new CollectionPage<String>(contextPath, String.class, currencyCodes, Optional.ofNullable(currencyCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public FuturesAndOptionsSearchRequest withDescription(String description) {
        FuturesAndOptionsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchRequest");
        _x.description = description;
        return _x;
    }

    @Property(name="ExchangeCodes")
    @JsonIgnore
    public CollectionPage<String> getExchangeCodes() {
        return new CollectionPage<String>(contextPath, String.class, exchangeCodes, Optional.ofNullable(exchangeCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="StrikePrice")
    @JsonIgnore
    public Optional<NumericComparison> getStrikePrice() {
        return Optional.ofNullable(strikePrice);
    }

    public FuturesAndOptionsSearchRequest withStrikePrice(NumericComparison strikePrice) {
        FuturesAndOptionsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchRequest");
        _x.strikePrice = strikePrice;
        return _x;
    }

    @Property(name="ExpirationDate")
    @JsonIgnore
    public Optional<DateComparison> getExpirationDate() {
        return Optional.ofNullable(expirationDate);
    }

    public FuturesAndOptionsSearchRequest withExpirationDate(DateComparison expirationDate) {
        FuturesAndOptionsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchRequest");
        _x.expirationDate = expirationDate;
        return _x;
    }

    @Property(name="AssetStatus")
    @JsonIgnore
    public Optional<FuturesAndOptionsStatus> getAssetStatus() {
        return Optional.ofNullable(assetStatus);
    }

    public FuturesAndOptionsSearchRequest withAssetStatus(FuturesAndOptionsStatus assetStatus) {
        FuturesAndOptionsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchRequest");
        _x.assetStatus = assetStatus;
        return _x;
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public FuturesAndOptionsSearchRequest withIdentifierType(IdentifierType identifierType) {
        FuturesAndOptionsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchRequest");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public FuturesAndOptionsSearchRequest withIdentifier(String identifier) {
        FuturesAndOptionsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchRequest");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="PreferredIdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getPreferredIdentifierType() {
        return Optional.ofNullable(preferredIdentifierType);
    }

    public FuturesAndOptionsSearchRequest withPreferredIdentifierType(IdentifierType preferredIdentifierType) {
        FuturesAndOptionsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchRequest");
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private FuturesAndOptionsType futuresAndOptionsType;
        private PutCall putCall;
        private List<String> fileCodes;
        private String fileCodesNextLink;
        private String underlyingRic;
        private ExerciseStyle exerciseStyle;
        private List<String> currencyCodes;
        private String currencyCodesNextLink;
        private String description;
        private List<String> exchangeCodes;
        private String exchangeCodesNextLink;
        private NumericComparison strikePrice;
        private DateComparison expirationDate;
        private FuturesAndOptionsStatus assetStatus;
        private IdentifierType identifierType;
        private String identifier;
        private IdentifierType preferredIdentifierType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder futuresAndOptionsType(FuturesAndOptionsType futuresAndOptionsType) {
            this.futuresAndOptionsType = futuresAndOptionsType;
            this.changedFields = changedFields.add("FuturesAndOptionsType");
            return this;
        }

        public Builder putCall(PutCall putCall) {
            this.putCall = putCall;
            this.changedFields = changedFields.add("PutCall");
            return this;
        }

        public Builder fileCodes(List<String> fileCodes) {
            this.fileCodes = fileCodes;
            this.changedFields = changedFields.add("FileCodes");
            return this;
        }

        public Builder fileCodesNextLink(String fileCodesNextLink) {
            this.fileCodesNextLink = fileCodesNextLink;
            this.changedFields = changedFields.add("FileCodes");
            return this;
        }

        public Builder underlyingRic(String underlyingRic) {
            this.underlyingRic = underlyingRic;
            this.changedFields = changedFields.add("UnderlyingRic");
            return this;
        }

        public Builder exerciseStyle(ExerciseStyle exerciseStyle) {
            this.exerciseStyle = exerciseStyle;
            this.changedFields = changedFields.add("ExerciseStyle");
            return this;
        }

        public Builder currencyCodes(List<String> currencyCodes) {
            this.currencyCodes = currencyCodes;
            this.changedFields = changedFields.add("CurrencyCodes");
            return this;
        }

        public Builder currencyCodesNextLink(String currencyCodesNextLink) {
            this.currencyCodesNextLink = currencyCodesNextLink;
            this.changedFields = changedFields.add("CurrencyCodes");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder exchangeCodes(List<String> exchangeCodes) {
            this.exchangeCodes = exchangeCodes;
            this.changedFields = changedFields.add("ExchangeCodes");
            return this;
        }

        public Builder exchangeCodesNextLink(String exchangeCodesNextLink) {
            this.exchangeCodesNextLink = exchangeCodesNextLink;
            this.changedFields = changedFields.add("ExchangeCodes");
            return this;
        }

        public Builder strikePrice(NumericComparison strikePrice) {
            this.strikePrice = strikePrice;
            this.changedFields = changedFields.add("StrikePrice");
            return this;
        }

        public Builder expirationDate(DateComparison expirationDate) {
            this.expirationDate = expirationDate;
            this.changedFields = changedFields.add("ExpirationDate");
            return this;
        }

        public Builder assetStatus(FuturesAndOptionsStatus assetStatus) {
            this.assetStatus = assetStatus;
            this.changedFields = changedFields.add("AssetStatus");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder preferredIdentifierType(IdentifierType preferredIdentifierType) {
            this.preferredIdentifierType = preferredIdentifierType;
            this.changedFields = changedFields.add("PreferredIdentifierType");
            return this;
        }

        public FuturesAndOptionsSearchRequest build() {
            FuturesAndOptionsSearchRequest _x = new FuturesAndOptionsSearchRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchRequest";
            _x.futuresAndOptionsType = futuresAndOptionsType;
            _x.putCall = putCall;
            _x.fileCodes = fileCodes;
            _x.fileCodesNextLink = fileCodesNextLink;
            _x.underlyingRic = underlyingRic;
            _x.exerciseStyle = exerciseStyle;
            _x.currencyCodes = currencyCodes;
            _x.currencyCodesNextLink = currencyCodesNextLink;
            _x.description = description;
            _x.exchangeCodes = exchangeCodes;
            _x.exchangeCodesNextLink = exchangeCodesNextLink;
            _x.strikePrice = strikePrice;
            _x.expirationDate = expirationDate;
            _x.assetStatus = assetStatus;
            _x.identifierType = identifierType;
            _x.identifier = identifier;
            _x.preferredIdentifierType = preferredIdentifierType;
            return _x;
        }
    }

    private FuturesAndOptionsSearchRequest _copy() {
        FuturesAndOptionsSearchRequest _x = new FuturesAndOptionsSearchRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.futuresAndOptionsType = futuresAndOptionsType;
        _x.putCall = putCall;
        _x.fileCodes = fileCodes;
        _x.underlyingRic = underlyingRic;
        _x.exerciseStyle = exerciseStyle;
        _x.currencyCodes = currencyCodes;
        _x.description = description;
        _x.exchangeCodes = exchangeCodes;
        _x.strikePrice = strikePrice;
        _x.expirationDate = expirationDate;
        _x.assetStatus = assetStatus;
        _x.identifierType = identifierType;
        _x.identifier = identifier;
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FuturesAndOptionsSearchRequest[");
        b.append("FuturesAndOptionsType=");
        b.append(this.futuresAndOptionsType);
        b.append(", ");
        b.append("PutCall=");
        b.append(this.putCall);
        b.append(", ");
        b.append("FileCodes=");
        b.append(this.fileCodes);
        b.append(", ");
        b.append("UnderlyingRic=");
        b.append(this.underlyingRic);
        b.append(", ");
        b.append("ExerciseStyle=");
        b.append(this.exerciseStyle);
        b.append(", ");
        b.append("CurrencyCodes=");
        b.append(this.currencyCodes);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("ExchangeCodes=");
        b.append(this.exchangeCodes);
        b.append(", ");
        b.append("StrikePrice=");
        b.append(this.strikePrice);
        b.append(", ");
        b.append("ExpirationDate=");
        b.append(this.expirationDate);
        b.append(", ");
        b.append("AssetStatus=");
        b.append(this.assetStatus);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("PreferredIdentifierType=");
        b.append(this.preferredIdentifierType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
