package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.content.complex.ValidatedInstrument;
import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.enums.InstrumentType;
import thomsonreuters.dss.api.content.enums.ValidityStatus;
import thomsonreuters.dss.api.content.futuresandoptions.enums.FuturesAndOptionsStatus;
import thomsonreuters.dss.api.content.futuresandoptions.enums.FuturesAndOptionsType;
import thomsonreuters.dss.api.content.futuresandoptions.enums.PutCall;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ExchangeCode", 
    "CurrencyCode", 
    "FuturesAndOptionsType", 
    "PutCallCode", 
    "ExpirationDate", 
    "StrikePrice", 
    "AssetStatus"})
public class FuturesAndOptionsSearchResult extends ValidatedInstrument implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("ExchangeCode")
    protected String exchangeCode;

    @JsonProperty("CurrencyCode")
    protected String currencyCode;

    @JsonProperty("FuturesAndOptionsType")
    protected FuturesAndOptionsType futuresAndOptionsType;

    @JsonProperty("PutCallCode")
    protected PutCall putCallCode;

    @JsonProperty("ExpirationDate")
    protected OffsetDateTime expirationDate;

    @JsonProperty("StrikePrice")
    protected BigDecimal strikePrice;

    @JsonProperty("AssetStatus")
    protected FuturesAndOptionsStatus assetStatus;

    protected FuturesAndOptionsSearchResult() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchResult";
    }

    @Property(name="ExchangeCode")
    @JsonIgnore
    public Optional<String> getExchangeCode() {
        return Optional.ofNullable(exchangeCode);
    }

    public FuturesAndOptionsSearchResult withExchangeCode(String exchangeCode) {
        FuturesAndOptionsSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchResult");
        _x.exchangeCode = exchangeCode;
        return _x;
    }

    @Property(name="CurrencyCode")
    @JsonIgnore
    public Optional<String> getCurrencyCode() {
        return Optional.ofNullable(currencyCode);
    }

    public FuturesAndOptionsSearchResult withCurrencyCode(String currencyCode) {
        FuturesAndOptionsSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchResult");
        _x.currencyCode = currencyCode;
        return _x;
    }

    @Property(name="FuturesAndOptionsType")
    @JsonIgnore
    public Optional<FuturesAndOptionsType> getFuturesAndOptionsType() {
        return Optional.ofNullable(futuresAndOptionsType);
    }

    public FuturesAndOptionsSearchResult withFuturesAndOptionsType(FuturesAndOptionsType futuresAndOptionsType) {
        FuturesAndOptionsSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchResult");
        _x.futuresAndOptionsType = futuresAndOptionsType;
        return _x;
    }

    @Property(name="PutCallCode")
    @JsonIgnore
    public Optional<PutCall> getPutCallCode() {
        return Optional.ofNullable(putCallCode);
    }

    public FuturesAndOptionsSearchResult withPutCallCode(PutCall putCallCode) {
        FuturesAndOptionsSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchResult");
        _x.putCallCode = putCallCode;
        return _x;
    }

    @Property(name="ExpirationDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDate() {
        return Optional.ofNullable(expirationDate);
    }

    public FuturesAndOptionsSearchResult withExpirationDate(OffsetDateTime expirationDate) {
        FuturesAndOptionsSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchResult");
        _x.expirationDate = expirationDate;
        return _x;
    }

    @Property(name="StrikePrice")
    @JsonIgnore
    public Optional<BigDecimal> getStrikePrice() {
        return Optional.ofNullable(strikePrice);
    }

    public FuturesAndOptionsSearchResult withStrikePrice(BigDecimal strikePrice) {
        FuturesAndOptionsSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchResult");
        _x.strikePrice = strikePrice;
        return _x;
    }

    @Property(name="AssetStatus")
    @JsonIgnore
    public Optional<FuturesAndOptionsStatus> getAssetStatus() {
        return Optional.ofNullable(assetStatus);
    }

    public FuturesAndOptionsSearchResult withAssetStatus(FuturesAndOptionsStatus assetStatus) {
        FuturesAndOptionsSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchResult");
        _x.assetStatus = assetStatus;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderFuturesAndOptionsSearchResult() {
        return new Builder();
    }

    public static final class Builder {
        private String key;
        private String description;
        private InstrumentType instrumentType;
        private ValidityStatus status;
        private String source;
        private String identifier;
        private IdentifierType identifierType;
        private String userDefinedIdentifier;
        private String userDefinedIdentifier2;
        private String userDefinedIdentifier3;
        private String userDefinedIdentifier4;
        private String userDefinedIdentifier5;
        private String userDefinedIdentifier6;
        private String exchangeCode;
        private String currencyCode;
        private FuturesAndOptionsType futuresAndOptionsType;
        private PutCall putCallCode;
        private OffsetDateTime expirationDate;
        private BigDecimal strikePrice;
        private FuturesAndOptionsStatus assetStatus;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder key(String key) {
            this.key = key;
            this.changedFields = changedFields.add("Key");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder instrumentType(InstrumentType instrumentType) {
            this.instrumentType = instrumentType;
            this.changedFields = changedFields.add("InstrumentType");
            return this;
        }

        public Builder status(ValidityStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("Status");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.changedFields = changedFields.add("Source");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder userDefinedIdentifier(String userDefinedIdentifier) {
            this.userDefinedIdentifier = userDefinedIdentifier;
            this.changedFields = changedFields.add("UserDefinedIdentifier");
            return this;
        }

        public Builder userDefinedIdentifier2(String userDefinedIdentifier2) {
            this.userDefinedIdentifier2 = userDefinedIdentifier2;
            this.changedFields = changedFields.add("UserDefinedIdentifier2");
            return this;
        }

        public Builder userDefinedIdentifier3(String userDefinedIdentifier3) {
            this.userDefinedIdentifier3 = userDefinedIdentifier3;
            this.changedFields = changedFields.add("UserDefinedIdentifier3");
            return this;
        }

        public Builder userDefinedIdentifier4(String userDefinedIdentifier4) {
            this.userDefinedIdentifier4 = userDefinedIdentifier4;
            this.changedFields = changedFields.add("UserDefinedIdentifier4");
            return this;
        }

        public Builder userDefinedIdentifier5(String userDefinedIdentifier5) {
            this.userDefinedIdentifier5 = userDefinedIdentifier5;
            this.changedFields = changedFields.add("UserDefinedIdentifier5");
            return this;
        }

        public Builder userDefinedIdentifier6(String userDefinedIdentifier6) {
            this.userDefinedIdentifier6 = userDefinedIdentifier6;
            this.changedFields = changedFields.add("UserDefinedIdentifier6");
            return this;
        }

        public Builder exchangeCode(String exchangeCode) {
            this.exchangeCode = exchangeCode;
            this.changedFields = changedFields.add("ExchangeCode");
            return this;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            this.changedFields = changedFields.add("CurrencyCode");
            return this;
        }

        public Builder futuresAndOptionsType(FuturesAndOptionsType futuresAndOptionsType) {
            this.futuresAndOptionsType = futuresAndOptionsType;
            this.changedFields = changedFields.add("FuturesAndOptionsType");
            return this;
        }

        public Builder putCallCode(PutCall putCallCode) {
            this.putCallCode = putCallCode;
            this.changedFields = changedFields.add("PutCallCode");
            return this;
        }

        public Builder expirationDate(OffsetDateTime expirationDate) {
            this.expirationDate = expirationDate;
            this.changedFields = changedFields.add("ExpirationDate");
            return this;
        }

        public Builder strikePrice(BigDecimal strikePrice) {
            this.strikePrice = strikePrice;
            this.changedFields = changedFields.add("StrikePrice");
            return this;
        }

        public Builder assetStatus(FuturesAndOptionsStatus assetStatus) {
            this.assetStatus = assetStatus;
            this.changedFields = changedFields.add("AssetStatus");
            return this;
        }

        public FuturesAndOptionsSearchResult build() {
            FuturesAndOptionsSearchResult _x = new FuturesAndOptionsSearchResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchResult";
            _x.key = key;
            _x.description = description;
            _x.instrumentType = instrumentType;
            _x.status = status;
            _x.source = source;
            _x.identifier = identifier;
            _x.identifierType = identifierType;
            _x.userDefinedIdentifier = userDefinedIdentifier;
            _x.userDefinedIdentifier2 = userDefinedIdentifier2;
            _x.userDefinedIdentifier3 = userDefinedIdentifier3;
            _x.userDefinedIdentifier4 = userDefinedIdentifier4;
            _x.userDefinedIdentifier5 = userDefinedIdentifier5;
            _x.userDefinedIdentifier6 = userDefinedIdentifier6;
            _x.exchangeCode = exchangeCode;
            _x.currencyCode = currencyCode;
            _x.futuresAndOptionsType = futuresAndOptionsType;
            _x.putCallCode = putCallCode;
            _x.expirationDate = expirationDate;
            _x.strikePrice = strikePrice;
            _x.assetStatus = assetStatus;
            return _x;
        }
    }

    private FuturesAndOptionsSearchResult _copy() {
        FuturesAndOptionsSearchResult _x = new FuturesAndOptionsSearchResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.key = key;
        _x.description = description;
        _x.instrumentType = instrumentType;
        _x.status = status;
        _x.source = source;
        _x.identifier = identifier;
        _x.identifierType = identifierType;
        _x.userDefinedIdentifier = userDefinedIdentifier;
        _x.userDefinedIdentifier2 = userDefinedIdentifier2;
        _x.userDefinedIdentifier3 = userDefinedIdentifier3;
        _x.userDefinedIdentifier4 = userDefinedIdentifier4;
        _x.userDefinedIdentifier5 = userDefinedIdentifier5;
        _x.userDefinedIdentifier6 = userDefinedIdentifier6;
        _x.exchangeCode = exchangeCode;
        _x.currencyCode = currencyCode;
        _x.futuresAndOptionsType = futuresAndOptionsType;
        _x.putCallCode = putCallCode;
        _x.expirationDate = expirationDate;
        _x.strikePrice = strikePrice;
        _x.assetStatus = assetStatus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FuturesAndOptionsSearchResult[");
        b.append("Key=");
        b.append(this.key);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("InstrumentType=");
        b.append(this.instrumentType);
        b.append(", ");
        b.append("Status=");
        b.append(this.status);
        b.append(", ");
        b.append("Source=");
        b.append(this.source);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("UserDefinedIdentifier=");
        b.append(this.userDefinedIdentifier);
        b.append(", ");
        b.append("UserDefinedIdentifier2=");
        b.append(this.userDefinedIdentifier2);
        b.append(", ");
        b.append("UserDefinedIdentifier3=");
        b.append(this.userDefinedIdentifier3);
        b.append(", ");
        b.append("UserDefinedIdentifier4=");
        b.append(this.userDefinedIdentifier4);
        b.append(", ");
        b.append("UserDefinedIdentifier5=");
        b.append(this.userDefinedIdentifier5);
        b.append(", ");
        b.append("UserDefinedIdentifier6=");
        b.append(this.userDefinedIdentifier6);
        b.append(", ");
        b.append("ExchangeCode=");
        b.append(this.exchangeCode);
        b.append(", ");
        b.append("CurrencyCode=");
        b.append(this.currencyCode);
        b.append(", ");
        b.append("FuturesAndOptionsType=");
        b.append(this.futuresAndOptionsType);
        b.append(", ");
        b.append("PutCallCode=");
        b.append(this.putCallCode);
        b.append(", ");
        b.append("ExpirationDate=");
        b.append(this.expirationDate);
        b.append(", ");
        b.append("StrikePrice=");
        b.append(this.strikePrice);
        b.append(", ");
        b.append("AssetStatus=");
        b.append(this.assetStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
