package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.search.complex.DateComparison;
import thomsonreuters.dss.api.search.complex.GovCorpSecurityGroups;
import thomsonreuters.dss.api.search.complex.NumericComparison;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "AssetStatuses", 
    "GovCorpContributorCode", 
    "CountryCode", 
    "Coupon", 
    "CurrencyCodes", 
    "IndustrySectorCode", 
    "Group", 
    "MoodyRatingsCodes", 
    "StandardPoorsRatingsCodes", 
    "Callable", 
    "Convertable", 
    "Extendable", 
    "Putable", 
    "Sinkable", 
    "Issuer", 
    "IssueDate", 
    "MaturityDate", 
    "NextPayDate", 
    "OrgId", 
    "Ticker", 
    "IdentifierType", 
    "Identifier", 
    "PreferredIdentifierType"})
public class GovCorpSearchRequest implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AssetStatuses")
    protected List<String> assetStatuses;

    @JsonProperty("AssetStatuses@nextLink")
    protected String assetStatusesNextLink;

    @JsonProperty("GovCorpContributorCode")
    protected String govCorpContributorCode;

    @JsonProperty("CountryCode")
    protected String countryCode;

    @JsonProperty("Coupon")
    protected NumericComparison coupon;

    @JsonProperty("CurrencyCodes")
    protected List<String> currencyCodes;

    @JsonProperty("CurrencyCodes@nextLink")
    protected String currencyCodesNextLink;

    @JsonProperty("IndustrySectorCode")
    protected String industrySectorCode;

    @JsonProperty("Group")
    protected GovCorpSecurityGroups group;

    @JsonProperty("MoodyRatingsCodes")
    protected List<String> moodyRatingsCodes;

    @JsonProperty("MoodyRatingsCodes@nextLink")
    protected String moodyRatingsCodesNextLink;

    @JsonProperty("StandardPoorsRatingsCodes")
    protected List<String> standardPoorsRatingsCodes;

    @JsonProperty("StandardPoorsRatingsCodes@nextLink")
    protected String standardPoorsRatingsCodesNextLink;

    @JsonProperty("Callable")
    protected Boolean callable;

    @JsonProperty("Convertable")
    protected Boolean convertable;

    @JsonProperty("Extendable")
    protected Boolean extendable;

    @JsonProperty("Putable")
    protected Boolean putable;

    @JsonProperty("Sinkable")
    protected Boolean sinkable;

    @JsonProperty("Issuer")
    protected String issuer;

    @JsonProperty("IssueDate")
    protected DateComparison issueDate;

    @JsonProperty("MaturityDate")
    protected DateComparison maturityDate;

    @JsonProperty("NextPayDate")
    protected DateComparison nextPayDate;

    @JsonProperty("OrgId")
    protected String orgId;

    @JsonProperty("Ticker")
    protected String ticker;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("PreferredIdentifierType")
    protected IdentifierType preferredIdentifierType;

    protected GovCorpSearchRequest() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest";
    }

    @Property(name="AssetStatuses")
    @JsonIgnore
    public CollectionPage<String> getAssetStatuses() {
        return new CollectionPage<String>(contextPath, String.class, assetStatuses, Optional.ofNullable(assetStatusesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="GovCorpContributorCode")
    @JsonIgnore
    public Optional<String> getGovCorpContributorCode() {
        return Optional.ofNullable(govCorpContributorCode);
    }

    public GovCorpSearchRequest withGovCorpContributorCode(String govCorpContributorCode) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.govCorpContributorCode = govCorpContributorCode;
        return _x;
    }

    @Property(name="CountryCode")
    @JsonIgnore
    public Optional<String> getCountryCode() {
        return Optional.ofNullable(countryCode);
    }

    public GovCorpSearchRequest withCountryCode(String countryCode) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.countryCode = countryCode;
        return _x;
    }

    @Property(name="Coupon")
    @JsonIgnore
    public Optional<NumericComparison> getCoupon() {
        return Optional.ofNullable(coupon);
    }

    public GovCorpSearchRequest withCoupon(NumericComparison coupon) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.coupon = coupon;
        return _x;
    }

    @Property(name="CurrencyCodes")
    @JsonIgnore
    public CollectionPage<String> getCurrencyCodes() {
        return new CollectionPage<String>(contextPath, String.class, currencyCodes, Optional.ofNullable(currencyCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="IndustrySectorCode")
    @JsonIgnore
    public Optional<String> getIndustrySectorCode() {
        return Optional.ofNullable(industrySectorCode);
    }

    public GovCorpSearchRequest withIndustrySectorCode(String industrySectorCode) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.industrySectorCode = industrySectorCode;
        return _x;
    }

    @Property(name="Group")
    @JsonIgnore
    public Optional<GovCorpSecurityGroups> getGroup() {
        return Optional.ofNullable(group);
    }

    public GovCorpSearchRequest withGroup(GovCorpSecurityGroups group) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.group = group;
        return _x;
    }

    @Property(name="MoodyRatingsCodes")
    @JsonIgnore
    public CollectionPage<String> getMoodyRatingsCodes() {
        return new CollectionPage<String>(contextPath, String.class, moodyRatingsCodes, Optional.ofNullable(moodyRatingsCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="StandardPoorsRatingsCodes")
    @JsonIgnore
    public CollectionPage<String> getStandardPoorsRatingsCodes() {
        return new CollectionPage<String>(contextPath, String.class, standardPoorsRatingsCodes, Optional.ofNullable(standardPoorsRatingsCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="Callable")
    @JsonIgnore
    public Optional<Boolean> getCallable() {
        return Optional.ofNullable(callable);
    }

    public GovCorpSearchRequest withCallable(Boolean callable) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.callable = callable;
        return _x;
    }

    @Property(name="Convertable")
    @JsonIgnore
    public Optional<Boolean> getConvertable() {
        return Optional.ofNullable(convertable);
    }

    public GovCorpSearchRequest withConvertable(Boolean convertable) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.convertable = convertable;
        return _x;
    }

    @Property(name="Extendable")
    @JsonIgnore
    public Optional<Boolean> getExtendable() {
        return Optional.ofNullable(extendable);
    }

    public GovCorpSearchRequest withExtendable(Boolean extendable) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.extendable = extendable;
        return _x;
    }

    @Property(name="Putable")
    @JsonIgnore
    public Optional<Boolean> getPutable() {
        return Optional.ofNullable(putable);
    }

    public GovCorpSearchRequest withPutable(Boolean putable) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.putable = putable;
        return _x;
    }

    @Property(name="Sinkable")
    @JsonIgnore
    public Optional<Boolean> getSinkable() {
        return Optional.ofNullable(sinkable);
    }

    public GovCorpSearchRequest withSinkable(Boolean sinkable) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.sinkable = sinkable;
        return _x;
    }

    @Property(name="Issuer")
    @JsonIgnore
    public Optional<String> getIssuer() {
        return Optional.ofNullable(issuer);
    }

    public GovCorpSearchRequest withIssuer(String issuer) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.issuer = issuer;
        return _x;
    }

    @Property(name="IssueDate")
    @JsonIgnore
    public Optional<DateComparison> getIssueDate() {
        return Optional.ofNullable(issueDate);
    }

    public GovCorpSearchRequest withIssueDate(DateComparison issueDate) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.issueDate = issueDate;
        return _x;
    }

    @Property(name="MaturityDate")
    @JsonIgnore
    public Optional<DateComparison> getMaturityDate() {
        return Optional.ofNullable(maturityDate);
    }

    public GovCorpSearchRequest withMaturityDate(DateComparison maturityDate) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.maturityDate = maturityDate;
        return _x;
    }

    @Property(name="NextPayDate")
    @JsonIgnore
    public Optional<DateComparison> getNextPayDate() {
        return Optional.ofNullable(nextPayDate);
    }

    public GovCorpSearchRequest withNextPayDate(DateComparison nextPayDate) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.nextPayDate = nextPayDate;
        return _x;
    }

    @Property(name="OrgId")
    @JsonIgnore
    public Optional<String> getOrgId() {
        return Optional.ofNullable(orgId);
    }

    public GovCorpSearchRequest withOrgId(String orgId) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.orgId = orgId;
        return _x;
    }

    @Property(name="Ticker")
    @JsonIgnore
    public Optional<String> getTicker() {
        return Optional.ofNullable(ticker);
    }

    public GovCorpSearchRequest withTicker(String ticker) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.ticker = ticker;
        return _x;
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public GovCorpSearchRequest withIdentifierType(IdentifierType identifierType) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public GovCorpSearchRequest withIdentifier(String identifier) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="PreferredIdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getPreferredIdentifierType() {
        return Optional.ofNullable(preferredIdentifierType);
    }

    public GovCorpSearchRequest withPreferredIdentifierType(IdentifierType preferredIdentifierType) {
        GovCorpSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest");
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> assetStatuses;
        private String assetStatusesNextLink;
        private String govCorpContributorCode;
        private String countryCode;
        private NumericComparison coupon;
        private List<String> currencyCodes;
        private String currencyCodesNextLink;
        private String industrySectorCode;
        private GovCorpSecurityGroups group;
        private List<String> moodyRatingsCodes;
        private String moodyRatingsCodesNextLink;
        private List<String> standardPoorsRatingsCodes;
        private String standardPoorsRatingsCodesNextLink;
        private Boolean callable;
        private Boolean convertable;
        private Boolean extendable;
        private Boolean putable;
        private Boolean sinkable;
        private String issuer;
        private DateComparison issueDate;
        private DateComparison maturityDate;
        private DateComparison nextPayDate;
        private String orgId;
        private String ticker;
        private IdentifierType identifierType;
        private String identifier;
        private IdentifierType preferredIdentifierType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder assetStatuses(List<String> assetStatuses) {
            this.assetStatuses = assetStatuses;
            this.changedFields = changedFields.add("AssetStatuses");
            return this;
        }

        public Builder assetStatusesNextLink(String assetStatusesNextLink) {
            this.assetStatusesNextLink = assetStatusesNextLink;
            this.changedFields = changedFields.add("AssetStatuses");
            return this;
        }

        public Builder govCorpContributorCode(String govCorpContributorCode) {
            this.govCorpContributorCode = govCorpContributorCode;
            this.changedFields = changedFields.add("GovCorpContributorCode");
            return this;
        }

        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            this.changedFields = changedFields.add("CountryCode");
            return this;
        }

        public Builder coupon(NumericComparison coupon) {
            this.coupon = coupon;
            this.changedFields = changedFields.add("Coupon");
            return this;
        }

        public Builder currencyCodes(List<String> currencyCodes) {
            this.currencyCodes = currencyCodes;
            this.changedFields = changedFields.add("CurrencyCodes");
            return this;
        }

        public Builder currencyCodesNextLink(String currencyCodesNextLink) {
            this.currencyCodesNextLink = currencyCodesNextLink;
            this.changedFields = changedFields.add("CurrencyCodes");
            return this;
        }

        public Builder industrySectorCode(String industrySectorCode) {
            this.industrySectorCode = industrySectorCode;
            this.changedFields = changedFields.add("IndustrySectorCode");
            return this;
        }

        public Builder group(GovCorpSecurityGroups group) {
            this.group = group;
            this.changedFields = changedFields.add("Group");
            return this;
        }

        public Builder moodyRatingsCodes(List<String> moodyRatingsCodes) {
            this.moodyRatingsCodes = moodyRatingsCodes;
            this.changedFields = changedFields.add("MoodyRatingsCodes");
            return this;
        }

        public Builder moodyRatingsCodesNextLink(String moodyRatingsCodesNextLink) {
            this.moodyRatingsCodesNextLink = moodyRatingsCodesNextLink;
            this.changedFields = changedFields.add("MoodyRatingsCodes");
            return this;
        }

        public Builder standardPoorsRatingsCodes(List<String> standardPoorsRatingsCodes) {
            this.standardPoorsRatingsCodes = standardPoorsRatingsCodes;
            this.changedFields = changedFields.add("StandardPoorsRatingsCodes");
            return this;
        }

        public Builder standardPoorsRatingsCodesNextLink(String standardPoorsRatingsCodesNextLink) {
            this.standardPoorsRatingsCodesNextLink = standardPoorsRatingsCodesNextLink;
            this.changedFields = changedFields.add("StandardPoorsRatingsCodes");
            return this;
        }

        public Builder callable(Boolean callable) {
            this.callable = callable;
            this.changedFields = changedFields.add("Callable");
            return this;
        }

        public Builder convertable(Boolean convertable) {
            this.convertable = convertable;
            this.changedFields = changedFields.add("Convertable");
            return this;
        }

        public Builder extendable(Boolean extendable) {
            this.extendable = extendable;
            this.changedFields = changedFields.add("Extendable");
            return this;
        }

        public Builder putable(Boolean putable) {
            this.putable = putable;
            this.changedFields = changedFields.add("Putable");
            return this;
        }

        public Builder sinkable(Boolean sinkable) {
            this.sinkable = sinkable;
            this.changedFields = changedFields.add("Sinkable");
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            this.changedFields = changedFields.add("Issuer");
            return this;
        }

        public Builder issueDate(DateComparison issueDate) {
            this.issueDate = issueDate;
            this.changedFields = changedFields.add("IssueDate");
            return this;
        }

        public Builder maturityDate(DateComparison maturityDate) {
            this.maturityDate = maturityDate;
            this.changedFields = changedFields.add("MaturityDate");
            return this;
        }

        public Builder nextPayDate(DateComparison nextPayDate) {
            this.nextPayDate = nextPayDate;
            this.changedFields = changedFields.add("NextPayDate");
            return this;
        }

        public Builder orgId(String orgId) {
            this.orgId = orgId;
            this.changedFields = changedFields.add("OrgId");
            return this;
        }

        public Builder ticker(String ticker) {
            this.ticker = ticker;
            this.changedFields = changedFields.add("Ticker");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder preferredIdentifierType(IdentifierType preferredIdentifierType) {
            this.preferredIdentifierType = preferredIdentifierType;
            this.changedFields = changedFields.add("PreferredIdentifierType");
            return this;
        }

        public GovCorpSearchRequest build() {
            GovCorpSearchRequest _x = new GovCorpSearchRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest";
            _x.assetStatuses = assetStatuses;
            _x.assetStatusesNextLink = assetStatusesNextLink;
            _x.govCorpContributorCode = govCorpContributorCode;
            _x.countryCode = countryCode;
            _x.coupon = coupon;
            _x.currencyCodes = currencyCodes;
            _x.currencyCodesNextLink = currencyCodesNextLink;
            _x.industrySectorCode = industrySectorCode;
            _x.group = group;
            _x.moodyRatingsCodes = moodyRatingsCodes;
            _x.moodyRatingsCodesNextLink = moodyRatingsCodesNextLink;
            _x.standardPoorsRatingsCodes = standardPoorsRatingsCodes;
            _x.standardPoorsRatingsCodesNextLink = standardPoorsRatingsCodesNextLink;
            _x.callable = callable;
            _x.convertable = convertable;
            _x.extendable = extendable;
            _x.putable = putable;
            _x.sinkable = sinkable;
            _x.issuer = issuer;
            _x.issueDate = issueDate;
            _x.maturityDate = maturityDate;
            _x.nextPayDate = nextPayDate;
            _x.orgId = orgId;
            _x.ticker = ticker;
            _x.identifierType = identifierType;
            _x.identifier = identifier;
            _x.preferredIdentifierType = preferredIdentifierType;
            return _x;
        }
    }

    private GovCorpSearchRequest _copy() {
        GovCorpSearchRequest _x = new GovCorpSearchRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.assetStatuses = assetStatuses;
        _x.govCorpContributorCode = govCorpContributorCode;
        _x.countryCode = countryCode;
        _x.coupon = coupon;
        _x.currencyCodes = currencyCodes;
        _x.industrySectorCode = industrySectorCode;
        _x.group = group;
        _x.moodyRatingsCodes = moodyRatingsCodes;
        _x.standardPoorsRatingsCodes = standardPoorsRatingsCodes;
        _x.callable = callable;
        _x.convertable = convertable;
        _x.extendable = extendable;
        _x.putable = putable;
        _x.sinkable = sinkable;
        _x.issuer = issuer;
        _x.issueDate = issueDate;
        _x.maturityDate = maturityDate;
        _x.nextPayDate = nextPayDate;
        _x.orgId = orgId;
        _x.ticker = ticker;
        _x.identifierType = identifierType;
        _x.identifier = identifier;
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovCorpSearchRequest[");
        b.append("AssetStatuses=");
        b.append(this.assetStatuses);
        b.append(", ");
        b.append("GovCorpContributorCode=");
        b.append(this.govCorpContributorCode);
        b.append(", ");
        b.append("CountryCode=");
        b.append(this.countryCode);
        b.append(", ");
        b.append("Coupon=");
        b.append(this.coupon);
        b.append(", ");
        b.append("CurrencyCodes=");
        b.append(this.currencyCodes);
        b.append(", ");
        b.append("IndustrySectorCode=");
        b.append(this.industrySectorCode);
        b.append(", ");
        b.append("Group=");
        b.append(this.group);
        b.append(", ");
        b.append("MoodyRatingsCodes=");
        b.append(this.moodyRatingsCodes);
        b.append(", ");
        b.append("StandardPoorsRatingsCodes=");
        b.append(this.standardPoorsRatingsCodes);
        b.append(", ");
        b.append("Callable=");
        b.append(this.callable);
        b.append(", ");
        b.append("Convertable=");
        b.append(this.convertable);
        b.append(", ");
        b.append("Extendable=");
        b.append(this.extendable);
        b.append(", ");
        b.append("Putable=");
        b.append(this.putable);
        b.append(", ");
        b.append("Sinkable=");
        b.append(this.sinkable);
        b.append(", ");
        b.append("Issuer=");
        b.append(this.issuer);
        b.append(", ");
        b.append("IssueDate=");
        b.append(this.issueDate);
        b.append(", ");
        b.append("MaturityDate=");
        b.append(this.maturityDate);
        b.append(", ");
        b.append("NextPayDate=");
        b.append(this.nextPayDate);
        b.append(", ");
        b.append("OrgId=");
        b.append(this.orgId);
        b.append(", ");
        b.append("Ticker=");
        b.append(this.ticker);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("PreferredIdentifierType=");
        b.append(this.preferredIdentifierType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
