package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Agency", 
    "Government", 
    "Corporate", 
    "Supra", 
    "SubGroupCode"})
public class GovCorpSecurityGroups implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Agency")
    protected Boolean agency;

    @JsonProperty("Government")
    protected Boolean government;

    @JsonProperty("Corporate")
    protected Boolean corporate;

    @JsonProperty("Supra")
    protected Boolean supra;

    @JsonProperty("SubGroupCode")
    protected String subGroupCode;

    protected GovCorpSecurityGroups() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.GovCorpSecurityGroups";
    }

    @Property(name="Agency")
    @JsonIgnore
    public Optional<Boolean> getAgency() {
        return Optional.ofNullable(agency);
    }

    public GovCorpSecurityGroups withAgency(Boolean agency) {
        GovCorpSecurityGroups _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSecurityGroups");
        _x.agency = agency;
        return _x;
    }

    @Property(name="Government")
    @JsonIgnore
    public Optional<Boolean> getGovernment() {
        return Optional.ofNullable(government);
    }

    public GovCorpSecurityGroups withGovernment(Boolean government) {
        GovCorpSecurityGroups _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSecurityGroups");
        _x.government = government;
        return _x;
    }

    @Property(name="Corporate")
    @JsonIgnore
    public Optional<Boolean> getCorporate() {
        return Optional.ofNullable(corporate);
    }

    public GovCorpSecurityGroups withCorporate(Boolean corporate) {
        GovCorpSecurityGroups _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSecurityGroups");
        _x.corporate = corporate;
        return _x;
    }

    @Property(name="Supra")
    @JsonIgnore
    public Optional<Boolean> getSupra() {
        return Optional.ofNullable(supra);
    }

    public GovCorpSecurityGroups withSupra(Boolean supra) {
        GovCorpSecurityGroups _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSecurityGroups");
        _x.supra = supra;
        return _x;
    }

    @Property(name="SubGroupCode")
    @JsonIgnore
    public Optional<String> getSubGroupCode() {
        return Optional.ofNullable(subGroupCode);
    }

    public GovCorpSecurityGroups withSubGroupCode(String subGroupCode) {
        GovCorpSecurityGroups _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.GovCorpSecurityGroups");
        _x.subGroupCode = subGroupCode;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean agency;
        private Boolean government;
        private Boolean corporate;
        private Boolean supra;
        private String subGroupCode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder agency(Boolean agency) {
            this.agency = agency;
            this.changedFields = changedFields.add("Agency");
            return this;
        }

        public Builder government(Boolean government) {
            this.government = government;
            this.changedFields = changedFields.add("Government");
            return this;
        }

        public Builder corporate(Boolean corporate) {
            this.corporate = corporate;
            this.changedFields = changedFields.add("Corporate");
            return this;
        }

        public Builder supra(Boolean supra) {
            this.supra = supra;
            this.changedFields = changedFields.add("Supra");
            return this;
        }

        public Builder subGroupCode(String subGroupCode) {
            this.subGroupCode = subGroupCode;
            this.changedFields = changedFields.add("SubGroupCode");
            return this;
        }

        public GovCorpSecurityGroups build() {
            GovCorpSecurityGroups _x = new GovCorpSecurityGroups();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.GovCorpSecurityGroups";
            _x.agency = agency;
            _x.government = government;
            _x.corporate = corporate;
            _x.supra = supra;
            _x.subGroupCode = subGroupCode;
            return _x;
        }
    }

    private GovCorpSecurityGroups _copy() {
        GovCorpSecurityGroups _x = new GovCorpSecurityGroups();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.agency = agency;
        _x.government = government;
        _x.corporate = corporate;
        _x.supra = supra;
        _x.subGroupCode = subGroupCode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovCorpSecurityGroups[");
        b.append("Agency=");
        b.append(this.agency);
        b.append(", ");
        b.append("Government=");
        b.append(this.government);
        b.append(", ");
        b.append("Corporate=");
        b.append(this.corporate);
        b.append(", ");
        b.append("Supra=");
        b.append(this.supra);
        b.append(", ");
        b.append("SubGroupCode=");
        b.append(this.subGroupCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
