package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Identifier", 
    "IdentifierType", 
    "LineNumber", 
    "Exchange", 
    "Currency"})
public class HistoricalBulkSearchIdentifier implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("LineNumber")
    protected String lineNumber;

    @JsonProperty("Exchange")
    protected String exchange;

    @JsonProperty("Currency")
    protected String currency;

    protected HistoricalBulkSearchIdentifier() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchIdentifier";
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public HistoricalBulkSearchIdentifier withIdentifier(String identifier) {
        HistoricalBulkSearchIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchIdentifier");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public HistoricalBulkSearchIdentifier withIdentifierType(IdentifierType identifierType) {
        HistoricalBulkSearchIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchIdentifier");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="LineNumber")
    @JsonIgnore
    public Optional<String> getLineNumber() {
        return Optional.ofNullable(lineNumber);
    }

    public HistoricalBulkSearchIdentifier withLineNumber(String lineNumber) {
        HistoricalBulkSearchIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchIdentifier");
        _x.lineNumber = lineNumber;
        return _x;
    }

    @Property(name="Exchange")
    @JsonIgnore
    public Optional<String> getExchange() {
        return Optional.ofNullable(exchange);
    }

    public HistoricalBulkSearchIdentifier withExchange(String exchange) {
        HistoricalBulkSearchIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchIdentifier");
        _x.exchange = exchange;
        return _x;
    }

    @Property(name="Currency")
    @JsonIgnore
    public Optional<String> getCurrency() {
        return Optional.ofNullable(currency);
    }

    public HistoricalBulkSearchIdentifier withCurrency(String currency) {
        HistoricalBulkSearchIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchIdentifier");
        _x.currency = currency;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String identifier;
        private IdentifierType identifierType;
        private String lineNumber;
        private String exchange;
        private String currency;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder lineNumber(String lineNumber) {
            this.lineNumber = lineNumber;
            this.changedFields = changedFields.add("LineNumber");
            return this;
        }

        public Builder exchange(String exchange) {
            this.exchange = exchange;
            this.changedFields = changedFields.add("Exchange");
            return this;
        }

        public Builder currency(String currency) {
            this.currency = currency;
            this.changedFields = changedFields.add("Currency");
            return this;
        }

        public HistoricalBulkSearchIdentifier build() {
            HistoricalBulkSearchIdentifier _x = new HistoricalBulkSearchIdentifier();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchIdentifier";
            _x.identifier = identifier;
            _x.identifierType = identifierType;
            _x.lineNumber = lineNumber;
            _x.exchange = exchange;
            _x.currency = currency;
            return _x;
        }
    }

    private HistoricalBulkSearchIdentifier _copy() {
        HistoricalBulkSearchIdentifier _x = new HistoricalBulkSearchIdentifier();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.identifier = identifier;
        _x.identifierType = identifierType;
        _x.lineNumber = lineNumber;
        _x.exchange = exchange;
        _x.currency = currency;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HistoricalBulkSearchIdentifier[");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("LineNumber=");
        b.append(this.lineNumber);
        b.append(", ");
        b.append("Exchange=");
        b.append(this.exchange);
        b.append(", ");
        b.append("Currency=");
        b.append(this.currency);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
