package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.search.complex.DateTimeRange;
import thomsonreuters.dss.api.search.complex.HistoricalBulkSearchIdentifier;
import thomsonreuters.dss.api.search.enums.HistoricalResultsBy;
import thomsonreuters.dss.api.search.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Identifiers", 
    "Range", 
    "ResultsBy"})
public class HistoricalBulkSearchRequest implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Identifiers")
    protected List<HistoricalBulkSearchIdentifier> identifiers;

    @JsonProperty("Identifiers@nextLink")
    protected String identifiersNextLink;

    @JsonProperty("Range")
    protected DateTimeRange range;

    @JsonProperty("ResultsBy")
    protected HistoricalResultsBy resultsBy;

    protected HistoricalBulkSearchRequest() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchRequest";
    }

    @Property(name="Identifiers")
    @JsonIgnore
    public CollectionPage<HistoricalBulkSearchIdentifier> getIdentifiers() {
        return new CollectionPage<HistoricalBulkSearchIdentifier>(contextPath, HistoricalBulkSearchIdentifier.class, identifiers, Optional.ofNullable(identifiersNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="Range")
    @JsonIgnore
    public Optional<DateTimeRange> getRange() {
        return Optional.ofNullable(range);
    }

    public HistoricalBulkSearchRequest withRange(DateTimeRange range) {
        HistoricalBulkSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchRequest");
        _x.range = range;
        return _x;
    }

    @Property(name="ResultsBy")
    @JsonIgnore
    public Optional<HistoricalResultsBy> getResultsBy() {
        return Optional.ofNullable(resultsBy);
    }

    public HistoricalBulkSearchRequest withResultsBy(HistoricalResultsBy resultsBy) {
        HistoricalBulkSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchRequest");
        _x.resultsBy = resultsBy;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<HistoricalBulkSearchIdentifier> identifiers;
        private String identifiersNextLink;
        private DateTimeRange range;
        private HistoricalResultsBy resultsBy;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder identifiers(List<HistoricalBulkSearchIdentifier> identifiers) {
            this.identifiers = identifiers;
            this.changedFields = changedFields.add("Identifiers");
            return this;
        }

        public Builder identifiersNextLink(String identifiersNextLink) {
            this.identifiersNextLink = identifiersNextLink;
            this.changedFields = changedFields.add("Identifiers");
            return this;
        }

        public Builder range(DateTimeRange range) {
            this.range = range;
            this.changedFields = changedFields.add("Range");
            return this;
        }

        public Builder resultsBy(HistoricalResultsBy resultsBy) {
            this.resultsBy = resultsBy;
            this.changedFields = changedFields.add("ResultsBy");
            return this;
        }

        public HistoricalBulkSearchRequest build() {
            HistoricalBulkSearchRequest _x = new HistoricalBulkSearchRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchRequest";
            _x.identifiers = identifiers;
            _x.identifiersNextLink = identifiersNextLink;
            _x.range = range;
            _x.resultsBy = resultsBy;
            return _x;
        }
    }

    private HistoricalBulkSearchRequest _copy() {
        HistoricalBulkSearchRequest _x = new HistoricalBulkSearchRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.identifiers = identifiers;
        _x.range = range;
        _x.resultsBy = resultsBy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HistoricalBulkSearchRequest[");
        b.append("Identifiers=");
        b.append(this.identifiers);
        b.append(", ");
        b.append("Range=");
        b.append(this.range);
        b.append(", ");
        b.append("ResultsBy=");
        b.append(this.resultsBy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
