package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.search.complex.HistoricalSearchResult;
import thomsonreuters.dss.api.search.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Results", 
    "TruncatedIdentifier", 
    "TruncatedIdentiferExpansionCount", 
    "Truncated", 
    "ValidationMessages"})
public class HistoricalBulkSearchResult implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Results")
    protected List<HistoricalSearchResult> results;

    @JsonProperty("Results@nextLink")
    protected String resultsNextLink;

    @JsonProperty("TruncatedIdentifier")
    protected String truncatedIdentifier;

    @JsonProperty("TruncatedIdentiferExpansionCount")
    protected Integer truncatedIdentiferExpansionCount;

    @JsonProperty("Truncated")
    protected Boolean truncated;

    @JsonProperty("ValidationMessages")
    protected List<String> validationMessages;

    @JsonProperty("ValidationMessages@nextLink")
    protected String validationMessagesNextLink;

    protected HistoricalBulkSearchResult() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchResult";
    }

    @Property(name="Results")
    @JsonIgnore
    public CollectionPage<HistoricalSearchResult> getResults() {
        return new CollectionPage<HistoricalSearchResult>(contextPath, HistoricalSearchResult.class, results, Optional.ofNullable(resultsNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="TruncatedIdentifier")
    @JsonIgnore
    public Optional<String> getTruncatedIdentifier() {
        return Optional.ofNullable(truncatedIdentifier);
    }

    public HistoricalBulkSearchResult withTruncatedIdentifier(String truncatedIdentifier) {
        HistoricalBulkSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchResult");
        _x.truncatedIdentifier = truncatedIdentifier;
        return _x;
    }

    @Property(name="TruncatedIdentiferExpansionCount")
    @JsonIgnore
    public Optional<Integer> getTruncatedIdentiferExpansionCount() {
        return Optional.ofNullable(truncatedIdentiferExpansionCount);
    }

    public HistoricalBulkSearchResult withTruncatedIdentiferExpansionCount(Integer truncatedIdentiferExpansionCount) {
        HistoricalBulkSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchResult");
        _x.truncatedIdentiferExpansionCount = truncatedIdentiferExpansionCount;
        return _x;
    }

    @Property(name="Truncated")
    @JsonIgnore
    public Optional<Boolean> getTruncated() {
        return Optional.ofNullable(truncated);
    }

    public HistoricalBulkSearchResult withTruncated(Boolean truncated) {
        HistoricalBulkSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchResult");
        _x.truncated = truncated;
        return _x;
    }

    @Property(name="ValidationMessages")
    @JsonIgnore
    public CollectionPage<String> getValidationMessages() {
        return new CollectionPage<String>(contextPath, String.class, validationMessages, Optional.ofNullable(validationMessagesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<HistoricalSearchResult> results;
        private String resultsNextLink;
        private String truncatedIdentifier;
        private Integer truncatedIdentiferExpansionCount;
        private Boolean truncated;
        private List<String> validationMessages;
        private String validationMessagesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder results(List<HistoricalSearchResult> results) {
            this.results = results;
            this.changedFields = changedFields.add("Results");
            return this;
        }

        public Builder resultsNextLink(String resultsNextLink) {
            this.resultsNextLink = resultsNextLink;
            this.changedFields = changedFields.add("Results");
            return this;
        }

        public Builder truncatedIdentifier(String truncatedIdentifier) {
            this.truncatedIdentifier = truncatedIdentifier;
            this.changedFields = changedFields.add("TruncatedIdentifier");
            return this;
        }

        public Builder truncatedIdentiferExpansionCount(Integer truncatedIdentiferExpansionCount) {
            this.truncatedIdentiferExpansionCount = truncatedIdentiferExpansionCount;
            this.changedFields = changedFields.add("TruncatedIdentiferExpansionCount");
            return this;
        }

        public Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            this.changedFields = changedFields.add("Truncated");
            return this;
        }

        public Builder validationMessages(List<String> validationMessages) {
            this.validationMessages = validationMessages;
            this.changedFields = changedFields.add("ValidationMessages");
            return this;
        }

        public Builder validationMessagesNextLink(String validationMessagesNextLink) {
            this.validationMessagesNextLink = validationMessagesNextLink;
            this.changedFields = changedFields.add("ValidationMessages");
            return this;
        }

        public HistoricalBulkSearchResult build() {
            HistoricalBulkSearchResult _x = new HistoricalBulkSearchResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchResult";
            _x.results = results;
            _x.resultsNextLink = resultsNextLink;
            _x.truncatedIdentifier = truncatedIdentifier;
            _x.truncatedIdentiferExpansionCount = truncatedIdentiferExpansionCount;
            _x.truncated = truncated;
            _x.validationMessages = validationMessages;
            _x.validationMessagesNextLink = validationMessagesNextLink;
            return _x;
        }
    }

    private HistoricalBulkSearchResult _copy() {
        HistoricalBulkSearchResult _x = new HistoricalBulkSearchResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.results = results;
        _x.truncatedIdentifier = truncatedIdentifier;
        _x.truncatedIdentiferExpansionCount = truncatedIdentiferExpansionCount;
        _x.truncated = truncated;
        _x.validationMessages = validationMessages;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HistoricalBulkSearchResult[");
        b.append("Results=");
        b.append(this.results);
        b.append(", ");
        b.append("TruncatedIdentifier=");
        b.append(this.truncatedIdentifier);
        b.append(", ");
        b.append("TruncatedIdentiferExpansionCount=");
        b.append(this.truncatedIdentiferExpansionCount);
        b.append(", ");
        b.append("Truncated=");
        b.append(this.truncated);
        b.append(", ");
        b.append("ValidationMessages=");
        b.append(this.validationMessages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
