package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.search.complex.DateTimeRange;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ChainRics", 
    "Range"})
public class HistoricalChainResolutionRequest implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ChainRics")
    protected List<String> chainRics;

    @JsonProperty("ChainRics@nextLink")
    protected String chainRicsNextLink;

    @JsonProperty("Range")
    protected DateTimeRange range;

    protected HistoricalChainResolutionRequest() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.HistoricalChainResolutionRequest";
    }

    @Property(name="ChainRics")
    @JsonIgnore
    public CollectionPage<String> getChainRics() {
        return new CollectionPage<String>(contextPath, String.class, chainRics, Optional.ofNullable(chainRicsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="Range")
    @JsonIgnore
    public Optional<DateTimeRange> getRange() {
        return Optional.ofNullable(range);
    }

    public HistoricalChainResolutionRequest withRange(DateTimeRange range) {
        HistoricalChainResolutionRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalChainResolutionRequest");
        _x.range = range;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> chainRics;
        private String chainRicsNextLink;
        private DateTimeRange range;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder chainRics(List<String> chainRics) {
            this.chainRics = chainRics;
            this.changedFields = changedFields.add("ChainRics");
            return this;
        }

        public Builder chainRicsNextLink(String chainRicsNextLink) {
            this.chainRicsNextLink = chainRicsNextLink;
            this.changedFields = changedFields.add("ChainRics");
            return this;
        }

        public Builder range(DateTimeRange range) {
            this.range = range;
            this.changedFields = changedFields.add("Range");
            return this;
        }

        public HistoricalChainResolutionRequest build() {
            HistoricalChainResolutionRequest _x = new HistoricalChainResolutionRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.HistoricalChainResolutionRequest";
            _x.chainRics = chainRics;
            _x.chainRicsNextLink = chainRicsNextLink;
            _x.range = range;
            return _x;
        }
    }

    private HistoricalChainResolutionRequest _copy() {
        HistoricalChainResolutionRequest _x = new HistoricalChainResolutionRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.chainRics = chainRics;
        _x.range = range;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HistoricalChainResolutionRequest[");
        b.append("ChainRics=");
        b.append(this.chainRics);
        b.append(", ");
        b.append("Range=");
        b.append(this.range);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
