package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Ric", 
    "ValidFrom", 
    "ValidTo", 
    "FirstDate", 
    "LastDate"})
public class HistoricalInstrumentRicChangeHistory implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Ric")
    protected String ric;

    @JsonProperty("ValidFrom")
    protected OffsetDateTime validFrom;

    @JsonProperty("ValidTo")
    protected OffsetDateTime validTo;

    @JsonProperty("FirstDate")
    protected OffsetDateTime firstDate;

    @JsonProperty("LastDate")
    protected OffsetDateTime lastDate;

    protected HistoricalInstrumentRicChangeHistory() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.HistoricalInstrumentRicChangeHistory";
    }

    @Property(name="Ric")
    @JsonIgnore
    public Optional<String> getRic() {
        return Optional.ofNullable(ric);
    }

    public HistoricalInstrumentRicChangeHistory withRic(String ric) {
        HistoricalInstrumentRicChangeHistory _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalInstrumentRicChangeHistory");
        _x.ric = ric;
        return _x;
    }

    @Property(name="ValidFrom")
    @JsonIgnore
    public Optional<OffsetDateTime> getValidFrom() {
        return Optional.ofNullable(validFrom);
    }

    public HistoricalInstrumentRicChangeHistory withValidFrom(OffsetDateTime validFrom) {
        HistoricalInstrumentRicChangeHistory _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalInstrumentRicChangeHistory");
        _x.validFrom = validFrom;
        return _x;
    }

    @Property(name="ValidTo")
    @JsonIgnore
    public Optional<OffsetDateTime> getValidTo() {
        return Optional.ofNullable(validTo);
    }

    public HistoricalInstrumentRicChangeHistory withValidTo(OffsetDateTime validTo) {
        HistoricalInstrumentRicChangeHistory _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalInstrumentRicChangeHistory");
        _x.validTo = validTo;
        return _x;
    }

    @Property(name="FirstDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getFirstDate() {
        return Optional.ofNullable(firstDate);
    }

    public HistoricalInstrumentRicChangeHistory withFirstDate(OffsetDateTime firstDate) {
        HistoricalInstrumentRicChangeHistory _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalInstrumentRicChangeHistory");
        _x.firstDate = firstDate;
        return _x;
    }

    @Property(name="LastDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastDate() {
        return Optional.ofNullable(lastDate);
    }

    public HistoricalInstrumentRicChangeHistory withLastDate(OffsetDateTime lastDate) {
        HistoricalInstrumentRicChangeHistory _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalInstrumentRicChangeHistory");
        _x.lastDate = lastDate;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String ric;
        private OffsetDateTime validFrom;
        private OffsetDateTime validTo;
        private OffsetDateTime firstDate;
        private OffsetDateTime lastDate;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder ric(String ric) {
            this.ric = ric;
            this.changedFields = changedFields.add("Ric");
            return this;
        }

        public Builder validFrom(OffsetDateTime validFrom) {
            this.validFrom = validFrom;
            this.changedFields = changedFields.add("ValidFrom");
            return this;
        }

        public Builder validTo(OffsetDateTime validTo) {
            this.validTo = validTo;
            this.changedFields = changedFields.add("ValidTo");
            return this;
        }

        public Builder firstDate(OffsetDateTime firstDate) {
            this.firstDate = firstDate;
            this.changedFields = changedFields.add("FirstDate");
            return this;
        }

        public Builder lastDate(OffsetDateTime lastDate) {
            this.lastDate = lastDate;
            this.changedFields = changedFields.add("LastDate");
            return this;
        }

        public HistoricalInstrumentRicChangeHistory build() {
            HistoricalInstrumentRicChangeHistory _x = new HistoricalInstrumentRicChangeHistory();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.HistoricalInstrumentRicChangeHistory";
            _x.ric = ric;
            _x.validFrom = validFrom;
            _x.validTo = validTo;
            _x.firstDate = firstDate;
            _x.lastDate = lastDate;
            return _x;
        }
    }

    private HistoricalInstrumentRicChangeHistory _copy() {
        HistoricalInstrumentRicChangeHistory _x = new HistoricalInstrumentRicChangeHistory();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.ric = ric;
        _x.validFrom = validFrom;
        _x.validTo = validTo;
        _x.firstDate = firstDate;
        _x.lastDate = lastDate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HistoricalInstrumentRicChangeHistory[");
        b.append("Ric=");
        b.append(this.ric);
        b.append(", ");
        b.append("ValidFrom=");
        b.append(this.validFrom);
        b.append(", ");
        b.append("ValidTo=");
        b.append(this.validTo);
        b.append(", ");
        b.append("FirstDate=");
        b.append(this.firstDate);
        b.append(", ");
        b.append("LastDate=");
        b.append(this.lastDate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
