package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.search.complex.DateTimeRange;
import thomsonreuters.dss.api.search.enums.HistoricalResultsBy;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Identifier", 
    "IdentifierType", 
    "Range", 
    "ResultsBy", 
    "DomainCodes"})
public class HistoricalSearchRequest implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("Range")
    protected DateTimeRange range;

    @JsonProperty("ResultsBy")
    protected HistoricalResultsBy resultsBy;

    @JsonProperty("DomainCodes")
    protected List<String> domainCodes;

    @JsonProperty("DomainCodes@nextLink")
    protected String domainCodesNextLink;

    protected HistoricalSearchRequest() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.HistoricalSearchRequest";
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public HistoricalSearchRequest withIdentifier(String identifier) {
        HistoricalSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalSearchRequest");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public HistoricalSearchRequest withIdentifierType(IdentifierType identifierType) {
        HistoricalSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalSearchRequest");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="Range")
    @JsonIgnore
    public Optional<DateTimeRange> getRange() {
        return Optional.ofNullable(range);
    }

    public HistoricalSearchRequest withRange(DateTimeRange range) {
        HistoricalSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalSearchRequest");
        _x.range = range;
        return _x;
    }

    @Property(name="ResultsBy")
    @JsonIgnore
    public Optional<HistoricalResultsBy> getResultsBy() {
        return Optional.ofNullable(resultsBy);
    }

    public HistoricalSearchRequest withResultsBy(HistoricalResultsBy resultsBy) {
        HistoricalSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.HistoricalSearchRequest");
        _x.resultsBy = resultsBy;
        return _x;
    }

    @Property(name="DomainCodes")
    @JsonIgnore
    public CollectionPage<String> getDomainCodes() {
        return new CollectionPage<String>(contextPath, String.class, domainCodes, Optional.ofNullable(domainCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String identifier;
        private IdentifierType identifierType;
        private DateTimeRange range;
        private HistoricalResultsBy resultsBy;
        private List<String> domainCodes;
        private String domainCodesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder range(DateTimeRange range) {
            this.range = range;
            this.changedFields = changedFields.add("Range");
            return this;
        }

        public Builder resultsBy(HistoricalResultsBy resultsBy) {
            this.resultsBy = resultsBy;
            this.changedFields = changedFields.add("ResultsBy");
            return this;
        }

        public Builder domainCodes(List<String> domainCodes) {
            this.domainCodes = domainCodes;
            this.changedFields = changedFields.add("DomainCodes");
            return this;
        }

        public Builder domainCodesNextLink(String domainCodesNextLink) {
            this.domainCodesNextLink = domainCodesNextLink;
            this.changedFields = changedFields.add("DomainCodes");
            return this;
        }

        public HistoricalSearchRequest build() {
            HistoricalSearchRequest _x = new HistoricalSearchRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.HistoricalSearchRequest";
            _x.identifier = identifier;
            _x.identifierType = identifierType;
            _x.range = range;
            _x.resultsBy = resultsBy;
            _x.domainCodes = domainCodes;
            _x.domainCodesNextLink = domainCodesNextLink;
            return _x;
        }
    }

    private HistoricalSearchRequest _copy() {
        HistoricalSearchRequest _x = new HistoricalSearchRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.identifier = identifier;
        _x.identifierType = identifierType;
        _x.range = range;
        _x.resultsBy = resultsBy;
        _x.domainCodes = domainCodes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HistoricalSearchRequest[");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("Range=");
        b.append(this.range);
        b.append(", ");
        b.append("ResultsBy=");
        b.append(this.resultsBy);
        b.append(", ");
        b.append("DomainCodes=");
        b.append(this.domainCodes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
