package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.enums.Month;
import thomsonreuters.dss.api.content.fixedincome.mortgage.enums.MortgageAmortizationType;
import thomsonreuters.dss.api.content.fixedincome.mortgage.enums.MortgageSecurityGroup;
import thomsonreuters.dss.api.content.fixedincome.mortgage.enums.MortgageStatus;
import thomsonreuters.dss.api.content.fixedincome.mortgage.schema.SchemaInfo;
import thomsonreuters.dss.api.search.complex.NumericComparison;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "AgencyCode", 
    "PoolNumber", 
    "PoolTypeCode", 
    "CouponRate", 
    "AmortizationType", 
    "AssetStatuses", 
    "SecurityGroup", 
    "SettleMonth", 
    "IdentifierType", 
    "Identifier", 
    "PreferredIdentifierType"})
public class MortgageSearchRequest implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AgencyCode")
    protected String agencyCode;

    @JsonProperty("PoolNumber")
    protected String poolNumber;

    @JsonProperty("PoolTypeCode")
    protected String poolTypeCode;

    @JsonProperty("CouponRate")
    protected NumericComparison couponRate;

    @JsonProperty("AmortizationType")
    protected MortgageAmortizationType amortizationType;

    @JsonProperty("AssetStatuses")
    protected List<MortgageStatus> assetStatuses;

    @JsonProperty("AssetStatuses@nextLink")
    protected String assetStatusesNextLink;

    @JsonProperty("SecurityGroup")
    protected MortgageSecurityGroup securityGroup;

    @JsonProperty("SettleMonth")
    protected Month settleMonth;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("PreferredIdentifierType")
    protected IdentifierType preferredIdentifierType;

    protected MortgageSearchRequest() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.MortgageSearchRequest";
    }

    @Property(name="AgencyCode")
    @JsonIgnore
    public Optional<String> getAgencyCode() {
        return Optional.ofNullable(agencyCode);
    }

    public MortgageSearchRequest withAgencyCode(String agencyCode) {
        MortgageSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.MortgageSearchRequest");
        _x.agencyCode = agencyCode;
        return _x;
    }

    @Property(name="PoolNumber")
    @JsonIgnore
    public Optional<String> getPoolNumber() {
        return Optional.ofNullable(poolNumber);
    }

    public MortgageSearchRequest withPoolNumber(String poolNumber) {
        MortgageSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.MortgageSearchRequest");
        _x.poolNumber = poolNumber;
        return _x;
    }

    @Property(name="PoolTypeCode")
    @JsonIgnore
    public Optional<String> getPoolTypeCode() {
        return Optional.ofNullable(poolTypeCode);
    }

    public MortgageSearchRequest withPoolTypeCode(String poolTypeCode) {
        MortgageSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.MortgageSearchRequest");
        _x.poolTypeCode = poolTypeCode;
        return _x;
    }

    @Property(name="CouponRate")
    @JsonIgnore
    public Optional<NumericComparison> getCouponRate() {
        return Optional.ofNullable(couponRate);
    }

    public MortgageSearchRequest withCouponRate(NumericComparison couponRate) {
        MortgageSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.MortgageSearchRequest");
        _x.couponRate = couponRate;
        return _x;
    }

    @Property(name="AmortizationType")
    @JsonIgnore
    public Optional<MortgageAmortizationType> getAmortizationType() {
        return Optional.ofNullable(amortizationType);
    }

    public MortgageSearchRequest withAmortizationType(MortgageAmortizationType amortizationType) {
        MortgageSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.MortgageSearchRequest");
        _x.amortizationType = amortizationType;
        return _x;
    }

    @Property(name="AssetStatuses")
    @JsonIgnore
    public CollectionPage<MortgageStatus> getAssetStatuses() {
        return new CollectionPage<MortgageStatus>(contextPath, MortgageStatus.class, assetStatuses, Optional.ofNullable(assetStatusesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="SecurityGroup")
    @JsonIgnore
    public Optional<MortgageSecurityGroup> getSecurityGroup() {
        return Optional.ofNullable(securityGroup);
    }

    public MortgageSearchRequest withSecurityGroup(MortgageSecurityGroup securityGroup) {
        MortgageSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.MortgageSearchRequest");
        _x.securityGroup = securityGroup;
        return _x;
    }

    @Property(name="SettleMonth")
    @JsonIgnore
    public Optional<Month> getSettleMonth() {
        return Optional.ofNullable(settleMonth);
    }

    public MortgageSearchRequest withSettleMonth(Month settleMonth) {
        MortgageSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.MortgageSearchRequest");
        _x.settleMonth = settleMonth;
        return _x;
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public MortgageSearchRequest withIdentifierType(IdentifierType identifierType) {
        MortgageSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.MortgageSearchRequest");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public MortgageSearchRequest withIdentifier(String identifier) {
        MortgageSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.MortgageSearchRequest");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="PreferredIdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getPreferredIdentifierType() {
        return Optional.ofNullable(preferredIdentifierType);
    }

    public MortgageSearchRequest withPreferredIdentifierType(IdentifierType preferredIdentifierType) {
        MortgageSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.MortgageSearchRequest");
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String agencyCode;
        private String poolNumber;
        private String poolTypeCode;
        private NumericComparison couponRate;
        private MortgageAmortizationType amortizationType;
        private List<MortgageStatus> assetStatuses;
        private String assetStatusesNextLink;
        private MortgageSecurityGroup securityGroup;
        private Month settleMonth;
        private IdentifierType identifierType;
        private String identifier;
        private IdentifierType preferredIdentifierType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder agencyCode(String agencyCode) {
            this.agencyCode = agencyCode;
            this.changedFields = changedFields.add("AgencyCode");
            return this;
        }

        public Builder poolNumber(String poolNumber) {
            this.poolNumber = poolNumber;
            this.changedFields = changedFields.add("PoolNumber");
            return this;
        }

        public Builder poolTypeCode(String poolTypeCode) {
            this.poolTypeCode = poolTypeCode;
            this.changedFields = changedFields.add("PoolTypeCode");
            return this;
        }

        public Builder couponRate(NumericComparison couponRate) {
            this.couponRate = couponRate;
            this.changedFields = changedFields.add("CouponRate");
            return this;
        }

        public Builder amortizationType(MortgageAmortizationType amortizationType) {
            this.amortizationType = amortizationType;
            this.changedFields = changedFields.add("AmortizationType");
            return this;
        }

        public Builder assetStatuses(List<MortgageStatus> assetStatuses) {
            this.assetStatuses = assetStatuses;
            this.changedFields = changedFields.add("AssetStatuses");
            return this;
        }

        public Builder assetStatusesNextLink(String assetStatusesNextLink) {
            this.assetStatusesNextLink = assetStatusesNextLink;
            this.changedFields = changedFields.add("AssetStatuses");
            return this;
        }

        public Builder securityGroup(MortgageSecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            this.changedFields = changedFields.add("SecurityGroup");
            return this;
        }

        public Builder settleMonth(Month settleMonth) {
            this.settleMonth = settleMonth;
            this.changedFields = changedFields.add("SettleMonth");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder preferredIdentifierType(IdentifierType preferredIdentifierType) {
            this.preferredIdentifierType = preferredIdentifierType;
            this.changedFields = changedFields.add("PreferredIdentifierType");
            return this;
        }

        public MortgageSearchRequest build() {
            MortgageSearchRequest _x = new MortgageSearchRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.MortgageSearchRequest";
            _x.agencyCode = agencyCode;
            _x.poolNumber = poolNumber;
            _x.poolTypeCode = poolTypeCode;
            _x.couponRate = couponRate;
            _x.amortizationType = amortizationType;
            _x.assetStatuses = assetStatuses;
            _x.assetStatusesNextLink = assetStatusesNextLink;
            _x.securityGroup = securityGroup;
            _x.settleMonth = settleMonth;
            _x.identifierType = identifierType;
            _x.identifier = identifier;
            _x.preferredIdentifierType = preferredIdentifierType;
            return _x;
        }
    }

    private MortgageSearchRequest _copy() {
        MortgageSearchRequest _x = new MortgageSearchRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.agencyCode = agencyCode;
        _x.poolNumber = poolNumber;
        _x.poolTypeCode = poolTypeCode;
        _x.couponRate = couponRate;
        _x.amortizationType = amortizationType;
        _x.assetStatuses = assetStatuses;
        _x.securityGroup = securityGroup;
        _x.settleMonth = settleMonth;
        _x.identifierType = identifierType;
        _x.identifier = identifier;
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MortgageSearchRequest[");
        b.append("AgencyCode=");
        b.append(this.agencyCode);
        b.append(", ");
        b.append("PoolNumber=");
        b.append(this.poolNumber);
        b.append(", ");
        b.append("PoolTypeCode=");
        b.append(this.poolTypeCode);
        b.append(", ");
        b.append("CouponRate=");
        b.append(this.couponRate);
        b.append(", ");
        b.append("AmortizationType=");
        b.append(this.amortizationType);
        b.append(", ");
        b.append("AssetStatuses=");
        b.append(this.assetStatuses);
        b.append(", ");
        b.append("SecurityGroup=");
        b.append(this.securityGroup);
        b.append(", ");
        b.append("SettleMonth=");
        b.append(this.settleMonth);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("PreferredIdentifierType=");
        b.append(this.preferredIdentifierType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
