package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.math.BigDecimal;
import java.util.Optional;

import thomsonreuters.dss.api.search.complex.NumericComparison;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "From", 
    "To"})
public class NumericRangeComparison extends NumericComparison implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("From")
    protected BigDecimal from;

    @JsonProperty("To")
    protected BigDecimal to;

    protected NumericRangeComparison() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.NumericRangeComparison";
    }

    @Property(name="From")
    @JsonIgnore
    public Optional<BigDecimal> getFrom() {
        return Optional.ofNullable(from);
    }

    public NumericRangeComparison withFrom(BigDecimal from) {
        NumericRangeComparison _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.NumericRangeComparison");
        _x.from = from;
        return _x;
    }

    @Property(name="To")
    @JsonIgnore
    public Optional<BigDecimal> getTo() {
        return Optional.ofNullable(to);
    }

    public NumericRangeComparison withTo(BigDecimal to) {
        NumericRangeComparison _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.NumericRangeComparison");
        _x.to = to;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderNumericRangeComparison() {
        return new Builder();
    }

    public static final class Builder {
        private BigDecimal from;
        private BigDecimal to;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder from(BigDecimal from) {
            this.from = from;
            this.changedFields = changedFields.add("From");
            return this;
        }

        public Builder to(BigDecimal to) {
            this.to = to;
            this.changedFields = changedFields.add("To");
            return this;
        }

        public NumericRangeComparison build() {
            NumericRangeComparison _x = new NumericRangeComparison();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.NumericRangeComparison";
            _x.from = from;
            _x.to = to;
            return _x;
        }
    }

    private NumericRangeComparison _copy() {
        NumericRangeComparison _x = new NumericRangeComparison();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.from = from;
        _x.to = to;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NumericRangeComparison[");
        b.append("From=");
        b.append(this.from);
        b.append(", ");
        b.append("To=");
        b.append(this.to);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
