package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.math.BigDecimal;
import java.util.Optional;

import thomsonreuters.dss.api.search.complex.NumericComparison;
import thomsonreuters.dss.api.search.enums.ComparisonOperator;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ComparisonOperator", 
    "Value"})
public class NumericValueComparison extends NumericComparison implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("ComparisonOperator")
    protected ComparisonOperator comparisonOperator;

    @JsonProperty("Value")
    protected BigDecimal value;

    protected NumericValueComparison() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.NumericValueComparison";
    }

    @Property(name="ComparisonOperator")
    @JsonIgnore
    public Optional<ComparisonOperator> getComparisonOperator() {
        return Optional.ofNullable(comparisonOperator);
    }

    public NumericValueComparison withComparisonOperator(ComparisonOperator comparisonOperator) {
        NumericValueComparison _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.NumericValueComparison");
        _x.comparisonOperator = comparisonOperator;
        return _x;
    }

    @Property(name="Value")
    @JsonIgnore
    public Optional<BigDecimal> getValue() {
        return Optional.ofNullable(value);
    }

    public NumericValueComparison withValue(BigDecimal value) {
        NumericValueComparison _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.NumericValueComparison");
        _x.value = value;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderNumericValueComparison() {
        return new Builder();
    }

    public static final class Builder {
        private ComparisonOperator comparisonOperator;
        private BigDecimal value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            this.changedFields = changedFields.add("ComparisonOperator");
            return this;
        }

        public Builder value(BigDecimal value) {
            this.value = value;
            this.changedFields = changedFields.add("Value");
            return this;
        }

        public NumericValueComparison build() {
            NumericValueComparison _x = new NumericValueComparison();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.NumericValueComparison";
            _x.comparisonOperator = comparisonOperator;
            _x.value = value;
            return _x;
        }
    }

    private NumericValueComparison _copy() {
        NumericValueComparison _x = new NumericValueComparison();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.comparisonOperator = comparisonOperator;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NumericValueComparison[");
        b.append("ComparisonOperator=");
        b.append(this.comparisonOperator);
        b.append(", ");
        b.append("Value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
