package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.enums.OtcsStatus;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "IdentifierType", 
    "Identifier", 
    "AssetStatus"})
public class OtcsSearchRequest implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("AssetStatus")
    protected OtcsStatus assetStatus;

    protected OtcsSearchRequest() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.OtcsSearchRequest";
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public OtcsSearchRequest withIdentifierType(IdentifierType identifierType) {
        OtcsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.OtcsSearchRequest");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public OtcsSearchRequest withIdentifier(String identifier) {
        OtcsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.OtcsSearchRequest");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="AssetStatus")
    @JsonIgnore
    public Optional<OtcsStatus> getAssetStatus() {
        return Optional.ofNullable(assetStatus);
    }

    public OtcsSearchRequest withAssetStatus(OtcsStatus assetStatus) {
        OtcsSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.OtcsSearchRequest");
        _x.assetStatus = assetStatus;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IdentifierType identifierType;
        private String identifier;
        private OtcsStatus assetStatus;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder assetStatus(OtcsStatus assetStatus) {
            this.assetStatus = assetStatus;
            this.changedFields = changedFields.add("AssetStatus");
            return this;
        }

        public OtcsSearchRequest build() {
            OtcsSearchRequest _x = new OtcsSearchRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.OtcsSearchRequest";
            _x.identifierType = identifierType;
            _x.identifier = identifier;
            _x.assetStatus = assetStatus;
            return _x;
        }
    }

    private OtcsSearchRequest _copy() {
        OtcsSearchRequest _x = new OtcsSearchRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.identifierType = identifierType;
        _x.identifier = identifier;
        _x.assetStatus = assetStatus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OtcsSearchRequest[");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("AssetStatus=");
        b.append(this.assetStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
